/*
 * Decompiled with CFR 0.152.
 */
package ch.docbox.elexis;

import ch.docbox.elexis.CDACHServicesClient;
import ch.docbox.elexis.Messages;
import ch.docbox.model.CdaMessage;
import ch.docbox.model.DocboxContact;
import ch.docbox.ws.cdachservices.CDACHServices;
import ch.docbox.ws.cdachservices.CDACHServices_Service;
import ch.elexis.agenda.data.Termin;
import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.preferences.ConfigServicePreferenceStore;
import ch.elexis.core.ui.util.Log;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Anwender;
import ch.elexis.docbox.ws.client.WsClientConfig;
import ch.elexis.docbox.ws.client.WsClientUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import javax.xml.ws.Service;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.slf4j.LoggerFactory;

public class UserDocboxPreferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private String oldSha1Password;
    private String oldLoginId;
    private StringFieldEditor loginIdFieldEditor;
    private StringFieldEditor passwordFieldEditor;
    private DirectoryFieldEditor directoryFieldEditor;
    private Button buttonAgendaSettingsPerUser;
    private Combo agendaBereichCombo;
    private Button buttonGetAppointmentsEmergencyService;
    private Button buttonGetAppointmentsPharmaVisits;
    private Button buttonGetAppointmentsTerminvereinbarung;
    private Button buttonClearDocboxInbox;
    private String[] bereiche;
    protected static Log log = Log.get((String)"UserDocboxPreferences");
    public static final String ID = "ch.docbox.elexis.UserDocboxPreferences";
    public static final String USR_DEFDOCBOXPATHFILES = "docbox/pathfiles";
    public static final String USR_DEFDOCBOXPATHHCARDAPI = "docbox/pathhcardapi";
    public static final String USR_AGENDASETTINGSPERUSER = "docbox/agendasettingsperuser";
    public static final String USR_USEHCARD = "docbox/usefmhcard";
    public static final String USR_GETAPPOINTMENTSEMERGENCYSERVICE = "docbox/getappointmentsemergencyservice";
    public static final String USR_GETAPPOINTMENTSPHARMAVISITS = "docbox/getappointmentspharmavisits";
    public static final String USR_GETAPPOINTMENTSTERMINVEREINBARUNG = "docbox/getappointmentsterminvereinbarung";
    public static final String USR_APPOINTMENTSBEREICH = "docbox/getappointmentsbereich";
    public static final String USR_ISDOCBOXTEST = "docbox/isdocboxtest";
    public static final String USR_UPDATEDOCTORDIRECTORY = "docbox/updatedoctordirectory";
    public static final String USR_USEPROXY = "docbox/useproxy";
    public static final String USR_PROXYHOST = "docbox/proxyhost";
    public static final String USR_PROXYPORT = "docbox/proxyport";
    public boolean oldAppointmentsEmergencyService;
    public boolean oldAppointmentsPharmaVisits;
    public boolean oldAppointmentsTerminvereinbarung;
    public String oldAppointmentsBereich;
    public static final String NOPASSWORD = "***NONE***";

    public static boolean isDocboxTest() {
        return UserDocboxPreferences.getDocboxLoginID(true) != null && UserDocboxPreferences.getDocboxLoginID(true).startsWith(WsClientConfig.TESTLOGINIDPREFIX);
    }

    public static String getSSOSignature(String ts) {
        String username = UserDocboxPreferences.getDocboxLoginID(false);
        String basicUser = WsClientConfig.getDocboxBasicUser();
        String message = String.valueOf(username) + ":" + ts + ":" + UserDocboxPreferences.getSha1DocboxPassword();
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(UserDocboxPreferences.toHex(UserDocboxPreferences.sha1(basicUser)).getBytes("UTF-8"), "HmacSHA1"));
            Base64 base64 = new Base64();
            return new String(base64.encode(mac.doFinal(message.getBytes("UTF-8"))));
        }
        catch (Exception e) {
            LoggerFactory.getLogger(UserDocboxPreferences.class).error("Exception getting SSO signature", (Throwable)e);
            return null;
        }
    }

    static byte[] sha1(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(text.getBytes("UTF-8"));
            return md.digest();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String toHex(byte[] v) {
        char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        String out = "";
        byte[] byArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            out = String.valueOf(out) + hex[element >> 4 & 0xF] + hex[element & 0xF];
            ++n2;
        }
        return out;
    }

    public UserDocboxPreferences() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.MANDATOR));
        this.setDescription(Messages.UserDocboxPreferences_Description);
        this.bereiche = Termin.TerminBereiche;
    }

    protected void createFieldEditors() {
        this.oldSha1Password = UserDocboxPreferences.getSha1DocboxPassword();
        this.oldLoginId = UserDocboxPreferences.getDocboxLoginID(true);
        this.oldAppointmentsEmergencyService = UserDocboxPreferences.isAppointmentsEmergencyService();
        this.oldAppointmentsPharmaVisits = UserDocboxPreferences.isAppointmentsPharmaVisits();
        this.oldAppointmentsTerminvereinbarung = UserDocboxPreferences.isAppointmentsTerminvereinbarung();
        this.oldAppointmentsBereich = UserDocboxPreferences.getAppointmentsBereich();
        boolean enableForMandant = AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(IUser.class, (Right)Right.UPDATE));
        this.loginIdFieldEditor = new StringFieldEditor("docbox/loginid", Messages.UserDocboxPreferences_LoginId, this.getFieldEditorParent());
        this.addField((FieldEditor)this.loginIdFieldEditor);
        this.loginIdFieldEditor.setEnabled(enableForMandant, this.getFieldEditorParent());
        this.passwordFieldEditor = new StringFieldEditor("docbox/password", Messages.UserDocboxPreferences_Password, this.getFieldEditorParent());
        this.passwordFieldEditor.getTextControl(this.getFieldEditorParent()).setEchoChar('*');
        this.passwordFieldEditor.setEnabled(enableForMandant, this.getFieldEditorParent());
        this.addField((FieldEditor)this.passwordFieldEditor);
        Button docboxConnectionTestButton = new Button(this.getFieldEditorParent(), 8);
        docboxConnectionTestButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String sha1Password = UserDocboxPreferences.this.passwordFieldEditor.getStringValue().equals(UserDocboxPreferences.this.oldSha1Password) ? UserDocboxPreferences.this.oldSha1Password : CDACHServicesClient.getSHA1(UserDocboxPreferences.this.passwordFieldEditor.getStringValue());
                ConfigServiceHolder.setMandator((String)"docbox/loginid", (String)UserDocboxPreferences.this.loginIdFieldEditor.getStringValue());
                ConfigServiceHolder.setMandator((String)"docbox/password", (String)sha1Password);
                Holder message = new Holder();
                boolean isOk = UserDocboxPreferences.this.performConnectionTest((Holder<String>)message);
                MessageBox box = new MessageBox(UiDesk.getDisplay().getActiveShell(), isOk ? 16 : 1);
                box.setText(Messages.UserDocboxPreferences_ConnectionTestWithDocbox);
                box.setMessage((String)message.value);
                box.open();
            }
        });
        docboxConnectionTestButton.setText(Messages.UserDocboxPreferences_ConnectionTest);
        docboxConnectionTestButton.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)false, (int)1, (boolean)false));
        new Label(this.getFieldEditorParent(), 258).setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        this.directoryFieldEditor = new DirectoryFieldEditor(USR_DEFDOCBOXPATHFILES, Messages.UserDocboxPreferences_PathFiles, this.getFieldEditorParent());
        this.addField((FieldEditor)this.directoryFieldEditor);
        this.directoryFieldEditor.setEnabled(enableForMandant, this.getFieldEditorParent());
        new Label(this.getFieldEditorParent(), 258).setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        if (UserDocboxPreferences.hasAgendaPlugin() && enableForMandant) {
            this.buttonAgendaSettingsPerUser = new Button(this.getFieldEditorParent(), 32);
            this.buttonAgendaSettingsPerUser.setText(Messages.UserDocboxPreferences_AgendaSettingsPerUser);
            this.buttonAgendaSettingsPerUser.setSelection(UserDocboxPreferences.getAgendaSettingsPerUser());
            this.buttonAgendaSettingsPerUser.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)false, (int)1, (boolean)false));
        }
        if (UserDocboxPreferences.hasAgendaPlugin()) {
            boolean enabled = UserDocboxPreferences.getAgendaSettingsPerUser() || enableForMandant;
            Label textLabel = new Label(this.getFieldEditorParent(), 0);
            textLabel.setText(Messages.UserDocboxPreferences_AgendaBerich);
            textLabel.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)false, (int)1, (boolean)false));
            this.agendaBereichCombo = new Combo(this.getFieldEditorParent(), 12);
            this.agendaBereichCombo.setItems(this.bereiche);
            this.agendaBereichCombo.select(this.getAgendaIndex());
            this.agendaBereichCombo.setEnabled(enabled);
            textLabel.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)false, (int)1, (boolean)false));
            this.buttonGetAppointmentsEmergencyService = new Button(this.getFieldEditorParent(), 32);
            this.buttonGetAppointmentsEmergencyService.setText(Messages.UserDocboxPreferences_GetAppointmentsEmergencyService);
            this.buttonGetAppointmentsEmergencyService.setSelection(UserDocboxPreferences.isAppointmentsEmergencyService());
            this.buttonGetAppointmentsEmergencyService.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)false, (int)1, (boolean)false));
            this.buttonGetAppointmentsEmergencyService.setEnabled(enabled);
            this.buttonGetAppointmentsPharmaVisits = new Button(this.getFieldEditorParent(), 32);
            this.buttonGetAppointmentsPharmaVisits.setText(Messages.UserDocboxPreferences_GetAppointmentsPharmaVisits);
            this.buttonGetAppointmentsPharmaVisits.setSelection(UserDocboxPreferences.isAppointmentsPharmaVisits());
            this.buttonGetAppointmentsPharmaVisits.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)false, (int)1, (boolean)false));
            this.buttonGetAppointmentsPharmaVisits.setEnabled(enabled);
            this.buttonGetAppointmentsTerminvereinbarung = new Button(this.getFieldEditorParent(), 32);
            this.buttonGetAppointmentsTerminvereinbarung.setText(Messages.UserDocboxPreferences_GetAppointmentsTerminvereinbarungen);
            this.buttonGetAppointmentsTerminvereinbarung.setSelection(UserDocboxPreferences.isAppointmentsTerminvereinbarung());
            this.buttonGetAppointmentsTerminvereinbarung.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)false, (int)1, (boolean)false));
            this.buttonGetAppointmentsTerminvereinbarung.setEnabled(enabled);
        }
        if (enableForMandant) {
            new Label(this.getFieldEditorParent(), 258).setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
            this.buttonClearDocboxInbox = new Button(this.getFieldEditorParent(), 8);
            this.buttonClearDocboxInbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    MessageBox box = new MessageBox(UiDesk.getDisplay().getActiveShell(), 200);
                    box.setText(Messages.UserDocboxPreferences_ClearDocboxInbox);
                    box.setMessage(Messages.UserDocboxPreferences_ClearDocboxInboxConfirm);
                    if (box.open() == 64) {
                        CdaMessage.deleteCdaMessages((Anwender)CoreHub.actMandant);
                    }
                }
            });
            this.buttonClearDocboxInbox.setText(Messages.UserDocboxPreferences_ClearDocboxInbox);
            this.buttonClearDocboxInbox.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)false, (int)1, (boolean)false));
        }
        Button btnConvertDocboxIds = new Button(this.getFieldEditorParent(), 8);
        btnConvertDocboxIds.setText(Messages.UserDocboxPreferences_ConvertDocboxIds);
        btnConvertDocboxIds.setToolTipText(Messages.UserDocboxPreferences_ConvertDocboxIds_Tooltip);
        btnConvertDocboxIds.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)false, (int)1, (boolean)false));
        btnConvertDocboxIds.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                IProgressService progService = PlatformUI.getWorkbench().getProgressService();
                try {
                    progService.runInUI((IRunnableContext)progService, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            DocboxContact.importDocboxIdsFromKontaktExtinfo(monitor);
                        }
                    }, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public int getAgendaIndex() {
        String agendaBereich = UserDocboxPreferences.getAppointmentsBereich();
        if (agendaBereich != null && !"".equals(agendaBereich)) {
            int i = 0;
            while (this.bereiche != null && i < this.bereiche.length) {
                if (this.bereiche[i].equals(agendaBereich)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static boolean hasAgendaPlugin() {
        Termin termin = Termin.load((String)"1");
        return termin != null && termin.exists();
    }

    public static String getDocboxLoginID(boolean prefixed) {
        String loginId = ConfigServiceHolder.getMandator((String)"docbox/loginid", (String)"");
        if (!prefixed && loginId.startsWith(WsClientConfig.TESTLOGINIDPREFIX)) {
            loginId = loginId.substring(WsClientConfig.TESTLOGINIDPREFIX.length());
        }
        return loginId;
    }

    public static String getSha1DocboxPassword() {
        String sha1Password = ConfigServiceHolder.getMandator((String)"docbox/password", (String)"");
        return sha1Password;
    }

    public static String getSha1DocboxSecretKey() {
        String docboxSha1SecretKey = "";
        if (UserDocboxPreferences.isDocboxTest()) {
            return CDACHServicesClient.getSHA1("docboxtest");
        }
        URL baseUrl = CDACHServices_Service.class.getResource("");
        try {
            URL url = new URL(baseUrl + "/product.key");
            InputStream in = url.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
            docboxSha1SecretKey = bufferedReader.readLine();
        }
        catch (Exception e) {
            docboxSha1SecretKey = CDACHServicesClient.getSHA1(ConfigServiceHolder.getMandator((String)"docbox/secretkey", (String)""));
        }
        return docboxSha1SecretKey;
    }

    public static String getPathFiles() {
        return ConfigServiceHolder.getMandator((String)USR_DEFDOCBOXPATHFILES, (String)"");
    }

    public static String getPathHCardAPI() {
        return ConfigServiceHolder.getMandator((String)USR_DEFDOCBOXPATHHCARDAPI, (String)"");
    }

    public static boolean getAgendaSettingsPerUser() {
        if (CoreHub.getLoggedInContact() == null || !ContextServiceHolder.get().getActiveMandator().isPresent()) {
            return false;
        }
        boolean value = ConfigServiceHolder.getMandator((String)USR_AGENDASETTINGSPERUSER, (String)"0").equals("1");
        return value;
    }

    private static String getBrowserHost() {
        String host = "";
        host = UserDocboxPreferences.isDocboxTest() ? "www.test.docbox.ch" : "www.docbox.ch";
        return host;
    }

    private static String getHost() {
        String host = "";
        host = UserDocboxPreferences.useHCard() ? (UserDocboxPreferences.isDocboxTest() ? "swissmedicalsuite.test.docbox.ch" : "swissmedicalsuite.docbox.ch") : (UserDocboxPreferences.isDocboxTest() ? "soap.test.docbox.swiss" : "soap.docbox.swiss");
        return host;
    }

    public static String getDocboxBrowserHome() {
        return "http://www.docbox.ch";
    }

    public static String getDocboxBrowserUrl() {
        String test = UserDocboxPreferences.isDocboxTest() ? "test" : "";
        String host = UserDocboxPreferences.getBrowserHost();
        String cgibin = "cgi-bin";
        return "https://" + host + "/" + cgibin + "/WebObjects/docbox" + test + ".woa/wa/default";
    }

    public static String getDocboxServiceUrl() {
        String host = UserDocboxPreferences.getHost();
        return "https://" + host + "/CDACHServices";
    }

    private void setAgendaSettingsPerUser(boolean value) {
        ConfigServiceHolder.setMandator((String)USR_AGENDASETTINGSPERUSER, (String)(value ? "1" : "0"));
    }

    public boolean performOk() {
        super.performOk();
        String sha1Password = this.passwordFieldEditor.getStringValue().equals(this.oldSha1Password) ? this.oldSha1Password : CDACHServicesClient.getSHA1(this.passwordFieldEditor.getStringValue());
        ConfigServiceHolder.setMandator((String)"docbox/loginid", (String)this.loginIdFieldEditor.getStringValue());
        ConfigServiceHolder.setMandator((String)"docbox/password", (String)sha1Password);
        ConfigServiceHolder.setMandator((String)USR_DEFDOCBOXPATHFILES, (String)this.directoryFieldEditor.getStringValue());
        if (this.buttonAgendaSettingsPerUser != null) {
            this.setAgendaSettingsPerUser(this.buttonAgendaSettingsPerUser.getSelection());
        }
        if (UserDocboxPreferences.hasAgendaPlugin()) {
            if (!this.oldAppointmentsBereich.equals(this.getSelectedAgendaBereich())) {
                UserDocboxPreferences.setAppointmentsBereich(this.getSelectedAgendaBereich());
            }
            if (this.buttonGetAppointmentsEmergencyService.getSelection() != this.oldAppointmentsEmergencyService) {
                UserDocboxPreferences.setAppointmentsEmergencyService(this.buttonGetAppointmentsEmergencyService.getSelection());
            }
            if (this.buttonGetAppointmentsPharmaVisits.getSelection() != this.oldAppointmentsPharmaVisits) {
                UserDocboxPreferences.setAppointmentsPharmaVisits(this.buttonGetAppointmentsPharmaVisits.getSelection());
            }
            if (this.buttonGetAppointmentsTerminvereinbarung.getSelection() != this.oldAppointmentsTerminvereinbarung) {
                UserDocboxPreferences.setAppointmentsTerminvereinbarung(this.buttonGetAppointmentsTerminvereinbarung.getSelection());
            }
        }
        return true;
    }

    private String getSelectedAgendaBereich() {
        String bereich = "";
        if (this.agendaBereichCombo.getSelectionIndex() != -1) {
            return this.bereiche[this.agendaBereichCombo.getSelectionIndex()];
        }
        return bereich;
    }

    public boolean performCancel() {
        super.performCancel();
        ConfigServiceHolder.setMandator((String)"docbox/loginid", (String)this.oldLoginId);
        ConfigServiceHolder.setMandator((String)"docbox/password", (String)this.oldSha1Password);
        return true;
    }

    protected void performDefaults() {
        this.initialize();
    }

    public boolean performConnectionTest(Holder<String> message) {
        Holder _checkAccess_success = new Holder();
        try {
            CDACHServices port = UserDocboxPreferences.getPort();
            port.checkAccess((Holder<Boolean>)_checkAccess_success, message);
        }
        catch (Exception e) {
            message.value = "Verbindungsproblem mit docbox";
            message.value = String.valueOf(message.value) + "\n";
            message.value = e.getMessage();
            return false;
        }
        catch (NoClassDefFoundError e) {
            message.value = "Verbindungsproblem mit docbox";
            message.value = String.valueOf(message.value) + "\n";
            message.value = String.valueOf(message.value) + e.getMessage();
            return false;
        }
        catch (ExceptionInInitializerError e2) {
            message.value = "Verbindungsproblem mit docbox";
            message.value = String.valueOf(message.value) + "\n";
            return false;
        }
        return (Boolean)_checkAccess_success.value;
    }

    public static boolean hasValidDocboxCredentials() {
        return !"".equals(UserDocboxPreferences.getDocboxLoginID(true)) && !"".equals(UserDocboxPreferences.getSha1DocboxPassword());
    }

    public void init(IWorkbench workbench) {
    }

    public static IPreferenceStore getSettingsForUser() {
        Optional activeMandator = ContextServiceHolder.get().getActiveMandator();
        Optional activeUserContact = ContextServiceHolder.get().getActiveUserContact();
        if (activeUserContact.isPresent() && activeMandator.isPresent() && ((IContact)activeUserContact.get()).getId().equals(((IMandator)activeMandator.get()).getId())) {
            return new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.MANDATOR);
        }
        ConfigServicePreferenceStore settings = UserDocboxPreferences.getAgendaSettingsPerUser() ? new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.USER) : new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.MANDATOR);
        return settings;
    }

    public static boolean isAppointmentsEmergencyService() {
        if (CoreHub.getLoggedInContact() == null || !ContextServiceHolder.get().getActiveMandator().isPresent()) {
            return false;
        }
        return UserDocboxPreferences.getSettingsForUser().getBoolean(USR_GETAPPOINTMENTSEMERGENCYSERVICE);
    }

    public static void setAppointmentsEmergencyService(boolean appointmentsEmergencyService) {
        UserDocboxPreferences.getSettingsForUser().setValue(USR_GETAPPOINTMENTSEMERGENCYSERVICE, appointmentsEmergencyService);
    }

    public static boolean isAppointmentsPharmaVisits() {
        if (CoreHub.getLoggedInContact() == null || !ContextServiceHolder.get().getActiveMandator().isPresent()) {
            return false;
        }
        return UserDocboxPreferences.getSettingsForUser().getBoolean(USR_GETAPPOINTMENTSPHARMAVISITS);
    }

    public static void setAppointmentsPharmaVisits(boolean appointmentsPharmaVisits) {
        UserDocboxPreferences.getSettingsForUser().setValue(USR_GETAPPOINTMENTSPHARMAVISITS, appointmentsPharmaVisits);
    }

    public static boolean isAppointmentsTerminvereinbarung() {
        if (CoreHub.getLoggedInContact() == null || !ContextServiceHolder.get().getActiveMandator().isPresent()) {
            return false;
        }
        return UserDocboxPreferences.getSettingsForUser().getBoolean(USR_GETAPPOINTMENTSTERMINVEREINBARUNG);
    }

    public static void setAppointmentsTerminvereinbarung(boolean appointmentsTerminvereinbarung) {
        UserDocboxPreferences.getSettingsForUser().setValue(USR_GETAPPOINTMENTSTERMINVEREINBARUNG, appointmentsTerminvereinbarung);
    }

    public static String getAppointmentsBereich() {
        if (CoreHub.getLoggedInContact() == null || !ContextServiceHolder.get().getActiveMandator().isPresent()) {
            return "";
        }
        return UserDocboxPreferences.getSettingsForUser().getString(USR_APPOINTMENTSBEREICH);
    }

    public static void setAppointmentsBereich(String appointmentsBereich) {
        UserDocboxPreferences.getSettingsForUser().setValue(USR_APPOINTMENTSBEREICH, appointmentsBereich);
    }

    public static boolean useHCard() {
        return ConfigServiceHolder.getMandator((String)USR_USEHCARD, (boolean)false);
    }

    public static void setUseHCard(boolean useHCard) {
        ConfigServiceHolder.setMandator((String)USR_USEHCARD, (boolean)useHCard);
    }

    public static boolean useProxy() {
        return ConfigServiceHolder.getMandator((String)USR_USEPROXY, (boolean)false);
    }

    public static void setUseProxy(boolean useHCard) {
        ConfigServiceHolder.setMandator((String)USR_USEPROXY, (boolean)useHCard);
    }

    public static synchronized CDACHServices getPort() {
        CDACHServices_Service serviceClient = new CDACHServices_Service();
        WsClientUtil.addWsSecurityAndHttpConfigWithClientCert((Service)serviceClient, (String)WsClientConfig.getUsername(), (String)WsClientConfig.getPassword());
        CDACHServices port = serviceClient.getCDACHServices();
        ((BindingProvider)port).getRequestContext().put("javax.xml.ws.service.endpoint.address", UserDocboxPreferences.getDocboxServiceUrl());
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("Authorization", Collections.singletonList("Basic " + WsClientConfig.getDocboxBasicAuth()));
        ((BindingProvider)port).getRequestContext().put("javax.xml.ws.http.request.headers", headers);
        return port;
    }

    public static boolean downloadAppointments() {
        return UserDocboxPreferences.getAppointmentsBereich() != null && !"".equals(UserDocboxPreferences.getAppointmentsBereich()) && (UserDocboxPreferences.isAppointmentsPharmaVisits() || UserDocboxPreferences.isAppointmentsEmergencyService() || UserDocboxPreferences.isAppointmentsTerminvereinbarung());
    }
}

