/*
 * Decompiled with CFR 0.152.
 */
package ch.docbox.elexis;

import ch.docbox.elexis.UserDocboxPreferences;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.IUser;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import com.equo.chromium.swt.Browser;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.part.ViewPart;

public class DocboxView
extends ViewPart {
    public static final String ID = "ch.docbox.elexis.DocboxView";
    private Browser browser;

    @Inject
    void activeUser(@Optional IUser user) {
        Display.getDefault().asyncExec(() -> {
            if (user != null) {
                this.userChanged();
            }
        });
    }

    private String getDoboxLoginUrl() {
        return UserDocboxPreferences.getDocboxBrowserUrl();
    }

    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 8);
        this.setHome();
    }

    void userChanged() {
        this.setHome();
    }

    public void setHome() {
        if (CoreHub.getLoggedInContact() != null && UserDocboxPreferences.hasValidDocboxCredentials()) {
            this.browser.setUrl(String.valueOf(this.getDoboxLoginUrl()) + this.getSSOLoginParams("MainWelcome"));
        } else {
            this.browser.setUrl(UserDocboxPreferences.getDocboxBrowserHome());
        }
    }

    public void setHospitalReferral() {
        if (CoreHub.getLoggedInContact() != null && UserDocboxPreferences.hasValidDocboxCredentials()) {
            this.browser.setUrl(String.valueOf(this.getDoboxLoginUrl()) + this.getSSOLoginParams("HospitalApplicationsOverview"));
        }
    }

    public void setMyPatient() {
        if (CoreHub.getLoggedInContact() != null && UserDocboxPreferences.hasValidDocboxCredentials()) {
            this.browser.setUrl(String.valueOf(this.getDoboxLoginUrl()) + this.getSSOLoginParams("MyPatient"));
        }
    }

    public void setTerminvereinbarung() {
        if (CoreHub.getLoggedInContact() != null && UserDocboxPreferences.hasValidDocboxCredentials()) {
            this.browser.setUrl(String.valueOf(this.getDoboxLoginUrl()) + this.getSSOLoginParams("AppBookingWizzard"));
        }
    }

    public void setAppointment(String termin) {
        if (CoreHub.getLoggedInContact() != null && UserDocboxPreferences.hasValidDocboxCredentials()) {
            String url = String.valueOf(this.getDoboxLoginUrl()) + this.getSSOLoginParams("DocCalendar");
            if (termin != null) {
                try {
                    url = String.valueOf(url) + "&id=" + URLEncoder.encode(termin, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            this.browser.setUrl(url);
        }
    }

    private String getSSOLoginParams(String page) {
        String ts = "" + System.currentTimeMillis() / 1000L;
        String username = UserDocboxPreferences.getDocboxLoginID(false);
        String signature = UserDocboxPreferences.getSSOSignature(ts);
        try {
            return "?ts=" + ts + "&loginId=" + URLEncoder.encode(username, "UTF-8") + "&sig=" + URLEncoder.encode(signature, "UTF-8") + "&page=" + URLEncoder.encode(page, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public void setFocus() {
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }
}

