/*
 * Decompiled with CFR 0.152.
 */
package ch.docbox.elexis;

import ch.docbox.cdach.DocboxCDA;
import ch.docbox.elexis.DocboxAction;
import ch.docbox.elexis.DocboxView;
import ch.docbox.elexis.Messages;
import ch.docbox.elexis.UserDocboxPreferences;
import ch.docbox.model.DocboxContact;
import ch.docbox.ws.cdachservices.CDACHServices;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.Log;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.TimeTool;
import ch.swissmedicalsuite.HCardBrowser;
import java.util.Date;
import javax.xml.ws.Holder;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.hl7.v3.ClinicalDocumentType;
import org.hl7.v3.POCDMT000040Author;
import org.hl7.v3.POCDMT000040Custodian;
import org.hl7.v3.POCDMT000040InformationRecipient;
import org.hl7.v3.POCDMT000040RecordTarget;

public class DocboxTerminvereinbarungAction
extends DocboxAction {
    private IWorkbenchWindow window;
    private Patient patient;
    private Fall fall;
    private Kontakt kontakt;
    protected static Log log = Log.get((String)"DocboxTerminvereinbarungAction");

    public void run(IAction action) {
        try {
            if (CoreHub.getLoggedInContact() != null) {
                Boolean terminvereinbarung;
                this.patient = ElexisEventDispatcher.getSelectedPatient();
                this.kontakt = (Kontakt)ElexisEventDispatcher.getSelected(Kontakt.class);
                if (this.patient == null) {
                    MessageBox box = new MessageBox(UiDesk.getDisplay().getActiveShell(), 1);
                    box.setText(Messages.DocboxTerminvereinbarungAction_NoPatientSelectedText);
                    box.setMessage(Messages.DocboxTerminvereinbarungAction_NoPatientSelectedMessage);
                    box.open();
                    return;
                }
                if (!(this.kontakt == null || (terminvereinbarung = (Boolean)this.kontakt.getInfoElement("terminvereinbarung")) != null && terminvereinbarung.booleanValue())) {
                    MessageBox box = new MessageBox(UiDesk.getDisplay().getActiveShell(), 1);
                    box.setText(Messages.DocboxTerminvereinbarungAction_NoDoctorSelectedText);
                    box.setMessage(Messages.DocboxTerminvereinbarungAction_NoDoctorSelectedMessage);
                    box.open();
                }
                if (!this.hasValidDocboxCredentials()) {
                    return;
                }
                Runnable longJob = new Runnable(){
                    boolean done = false;

                    @Override
                    public void run() {
                        Thread thread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                log.log("job started", 5);
                                try {
                                    DocboxTerminvereinbarungAction.this.makeReferral((this).DocboxTerminvereinbarungAction.this.kontakt);
                                }
                                catch (Exception e) {
                                    ExHandler.handle((Throwable)e);
                                    log.log("excetion in makereferral", 5);
                                    log.log(e.toString(), 5);
                                }
                                log.log("job done", 5);
                                done = true;
                                if (UiDesk.getDisplay().isDisposed()) {
                                    return;
                                }
                                UiDesk.getDisplay().wake();
                            }
                        });
                        log.log("thread starting", 5);
                        thread.start();
                        while (!this.done && !UiDesk.getTopShell().isDisposed()) {
                            if (UiDesk.getDisplay().readAndDispatch()) continue;
                            UiDesk.getDisplay().sleep();
                        }
                        log.log("thread ended", 5);
                    }
                };
                BusyIndicator.showWhile((Display)UiDesk.getDisplay(), (Runnable)longJob);
                if (UserDocboxPreferences.useHCard()) {
                    new HCardBrowser(UserDocboxPreferences.getDocboxLoginID(false), UserDocboxPreferences.getDocboxBrowserUrl()).setTerminvereinbarung();
                } else {
                    DocboxView docboxView = (DocboxView)this.window.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.docbox.elexis.DocboxView");
                    if (docboxView != null) {
                        docboxView.setTerminvereinbarung();
                    }
                }
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    private void makeReferral(Kontakt kontakt) {
        DocboxCDA docboxCDA = new DocboxCDA();
        System.out.println("Invoking makeReferral...");
        try {
            this.addVersicherung(this.fall, docboxCDA);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Date birthday = null;
        if (!"".equals(this.patient.getGeburtsdatum())) {
            TimeTool ttBirthday = new TimeTool(this.patient.getGeburtsdatum());
            birthday = ttBirthday.getTime();
        }
        POCDMT000040RecordTarget recordTarget = docboxCDA.getRecordTarget(this.patient.getPatCode(), null, this.patient.getAnschrift().getStrasse(), this.patient.getAnschrift().getPlz(), this.patient.getAnschrift().getOrt(), null, null, this.patient.getNatel(), this.patient.getMailAddress(), this.patient.getVorname(), this.patient.getName(), "w".equals(this.patient.getGeschlecht()), "m".equals(this.patient.getGeschlecht()), false, birthday);
        POCDMT000040Author author = docboxCDA.getAuthor(CoreHub.actMandant.get("Titel"), CoreHub.actMandant.getVorname(), CoreHub.actMandant.getName(), CoreHub.actMandant.getNatel(), null, null, CoreHub.actMandant.getMailAddress(), null, null, null);
        POCDMT000040Custodian custodian = docboxCDA.getCustodian(null, null, null, null, null, null);
        log.log("Invoking addReferral...", 5);
        POCDMT000040InformationRecipient informationRecipient = null;
        if (kontakt != null) {
            informationRecipient = docboxCDA.getInformationRecipient(null, null, null, DocboxContact.getDocboxIdFor(kontakt), null);
        }
        ClinicalDocumentType _addReferral_document = new ClinicalDocumentType();
        _addReferral_document.setClinicalDocument(docboxCDA.getClinicalDocument("", recordTarget, author, custodian, informationRecipient, docboxCDA.getCodeReferral(), null, null));
        log.log("makeReferral ended...", 5);
        byte[] _addReferral_attachment = new byte[]{};
        Holder _addReferral_success = new Holder();
        Holder _addReferral_message = new Holder();
        Holder _addReferral_documentID = new Holder();
        CDACHServices port = UserDocboxPreferences.getPort();
        port.addReferral(_addReferral_document, _addReferral_attachment, (Holder<Boolean>)_addReferral_success, (Holder<String>)_addReferral_message, (Holder<String>)_addReferral_documentID);
        log.log("addReferral._addReferral_success=" + _addReferral_success.value, 5);
        log.log("addReferral._addReferral_message=" + (String)_addReferral_message.value, 5);
        log.log("addReferral._addReferral_documentID=" + (String)_addReferral_documentID.value, 5);
    }

    private void addVersicherung(Fall fall, DocboxCDA docboxCDA) {
        if (fall != null) {
            Kontakt costBearer = fall.getCostBearer();
            if ("UVG".equals(fall.getAbrechnungsSystem())) {
                try {
                    docboxCDA.addUnfallversicherung(costBearer.getLabel());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    docboxCDA.addUnfallversicherungPolicenummer(fall.getRequiredString("Unfallnummer"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ("KVG".equals(fall.getAbrechnungsSystem())) {
                try {
                    docboxCDA.addKrankenkasse(costBearer.getLabel());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    docboxCDA.addKrankenkassePolicenummer(fall.getRequiredString("Versicherungsnummer"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void init(IWorkbenchWindow window) {
        this.window = window;
    }
}

