/*
 * Decompiled with CFR 0.152.
 */
package ch.docbox.elexis;

import ch.docbox.cdach.CdaChXPath;
import ch.docbox.cdach.DocboxCDA;
import ch.docbox.elexis.Activator;
import ch.docbox.elexis.DocboxTermin;
import ch.docbox.elexis.Messages;
import ch.docbox.elexis.UserDocboxPreferences;
import ch.docbox.model.CdaMessage;
import ch.docbox.model.DocboxContact;
import ch.docbox.ws.cdachservices.AppointmentType;
import ch.docbox.ws.cdachservices.CDACHServices;
import ch.docbox.ws.cdachservices.DocumentInfoType;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import java.io.Serializable;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.ws.Holder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.hl7.v3.AD;
import org.hl7.v3.AdxpCity;
import org.hl7.v3.AdxpPostalCode;
import org.hl7.v3.AdxpStreetAddressLine;
import org.hl7.v3.ClinicalDocumentType;
import org.hl7.v3.EnFamily;
import org.hl7.v3.EnGiven;
import org.hl7.v3.EnPrefix;
import org.hl7.v3.II;
import org.hl7.v3.ON;
import org.hl7.v3.PN;
import org.hl7.v3.POCDMT000040IntendedRecipient;
import org.hl7.v3.POCDMT000040Organization;
import org.hl7.v3.POCDMT000040Person;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocboxBackgroundJob
extends Job {
    private static Logger log = LoggerFactory.getLogger(DocboxBackgroundJob.class);

    public DocboxBackgroundJob() {
        super(Messages.DocboxBackgroundJob_Title);
        this.setUser(false);
        this.setPriority(30);
    }

    public synchronized int fetchAppointments(IProgressMonitor monitor) {
        CDACHServices port = UserDocboxPreferences.getPort();
        int count = 0;
        List<DocboxTermin> docboxTermine = DocboxTermin.getDocboxTermine();
        monitor.worked(20);
        List<AppointmentType> appointments = port.getCalendar();
        if (appointments != null) {
            for (AppointmentType appointment : appointments) {
                DocboxTermin docboxTermin = new DocboxTermin();
                if (appointment.getState() == null || !(appointment.getState().contains("salesrepresentative") && UserDocboxPreferences.isAppointmentsPharmaVisits() || appointment.getState().contains("emergencyservice") && UserDocboxPreferences.isAppointmentsEmergencyService()) && (!appointment.getState().contains("terminierung") || !UserDocboxPreferences.isAppointmentsTerminvereinbarung())) continue;
                ++count;
                docboxTermin.create(appointment, UserDocboxPreferences.getAppointmentsBereich());
                if (!docboxTermine.contains(docboxTermin)) continue;
                docboxTermine.remove(docboxTermin);
            }
            monitor.worked(20);
            for (DocboxTermin docboxTermin : docboxTermine) {
                docboxTermin.delete();
            }
        }
        monitor.worked(20);
        return count;
    }

    public synchronized int updateDoctorDirectory(IProgressMonitor monitor) {
        CDACHServices port = UserDocboxPreferences.getPort();
        int count = 0;
        String myDocboxId = (String)CoreHub.actMandant.getInfoElement("docboxId");
        if (myDocboxId == null || "".equals(myDocboxId)) {
            this.updateDoctorDirectoryByApp(port, count, "self");
        }
        count = this.updateDoctorDirectoryByApp(port, count, "doctodoc");
        monitor.worked(30);
        count += this.updateDoctorDirectoryByApp(port, count, "terminvereinbarung");
        monitor.worked(30);
        return count;
    }

    /*
     * WARNING - void declaration
     */
    private int updateDoctorDirectoryByApp(CDACHServices port, int count, String application) {
        List<POCDMT000040IntendedRecipient> recipients = port.getRecipients(application);
        if (recipients != null) {
            for (POCDMT000040IntendedRecipient recipient : recipients) {
                void var19_20;
                String docboxId = "";
                String ean = "";
                String given = "";
                String family = "";
                String prefix = "";
                List<II> iis = recipient.getId();
                for (II ii : iis) {
                    if ("1.3.88".equals(ii.getRoot())) {
                        ean = ii.getExtension();
                    }
                    if (!CdaChXPath.getOidUserDocboxId().equals(ii.getRoot())) continue;
                    docboxId = ii.getExtension();
                }
                POCDMT000040Person person = recipient.getInformationRecipient();
                POCDMT000040Organization organization = recipient.getReceivedOrganization();
                List<PN> pns = person.getName();
                for (PN pn : pns) {
                    List<Serializable> ens = pn.getContent();
                    for (Serializable serializable : ens) {
                        if (ens == null) continue;
                        JAXBElement t = (JAXBElement)serializable;
                        if (t.getDeclaredType().getName().equals(EnGiven.class.getName())) {
                            given = ((EnGiven)t.getValue()).content();
                        }
                        if (t.getDeclaredType().getName().equals(EnFamily.class.getName())) {
                            family = ((EnFamily)t.getValue()).content();
                        }
                        if (!t.getDeclaredType().getName().equals(EnPrefix.class.getName()) || (prefix = ((EnPrefix)t.getValue()).content()) == null || prefix.length() <= 20) continue;
                        prefix = prefix.substring(0, 19);
                    }
                }
                String organizationName = "";
                List<ON> ons = organization.getName();
                if (ons != null) {
                    for (ON on : ons) {
                        List<Serializable> ens;
                        if (on == null || (ens = on.getContent()) == null) continue;
                        for (Serializable en2 : ens) {
                            organizationName = en2.toString();
                        }
                    }
                }
                boolean first = false;
                String string = "";
                String city = "";
                String plz = "";
                List<AD> ads = organization.getAddr();
                for (AD ad : ads) {
                    List<Serializable> ens = ad.getContent();
                    if (ens == null) continue;
                    for (Serializable en : ens) {
                        JAXBElement t = (JAXBElement)en;
                        if (t.getDeclaredType().getName().equals(AdxpStreetAddressLine.class.getName())) {
                            if (!first) {
                                String string2 = ((AdxpStreetAddressLine)t.getValue()).content();
                                first = true;
                            } else {
                                String content = ((AdxpStreetAddressLine)t.getValue()).content();
                                if (content != null && content.length() > 0) {
                                    String string3 = String.valueOf(var19_20) + content;
                                }
                            }
                        }
                        if (t.getDeclaredType().getName().equals(AdxpCity.class.getName())) {
                            city = ((AdxpCity)t.getValue()).content();
                        }
                        if (!t.getDeclaredType().getName().equals(AdxpPostalCode.class.getName())) continue;
                        plz = ((AdxpPostalCode)t.getValue()).content();
                    }
                }
                if (docboxId.length() <= 0) continue;
                ++count;
                Person p = null;
                Kontakt cMatching = DocboxContact.findContactForDocboxId(docboxId);
                if (cMatching != null) {
                    p = (Person)cMatching;
                }
                if (p == null && "self".equals(application)) {
                    p = (Person)ElexisEventDispatcher.getSelected(Mandant.class);
                    new DocboxContact(docboxId, (Kontakt)p);
                }
                if (p == null || UserDocboxPreferences.isDocboxTest()) {
                    boolean newPerson;
                    boolean bl = newPerson = p == null;
                    if (!newPerson) {
                        log.warn("newPerson is false, skipping intialization cMatching: " + cMatching + "/ docboxId: " + docboxId);
                        continue;
                    }
                    p = new Person(family, given, "", "");
                    new DocboxContact(docboxId, (Kontakt)p);
                    p.set("Name", family);
                    p.set("Vorname", given);
                    p.set("Titel", prefix);
                    if (!PersistentObject.checkNull((Object)p.get("istAnwender")).equals("1")) {
                        p.set("Bezeichnung3", organizationName);
                    }
                    p.set("Strasse", (String)var19_20);
                    p.set("Plz", plz);
                    p.set("Ort", city);
                    p.addXid("www.xid.ch/id/ean", ean, true);
                }
                p.setInfoElement(application, (Object)true);
            }
        }
        return count;
    }

    public synchronized int fetchInboxClinicalDocuments(IProgressMonitor monitor) {
        log.debug("fetchInboxClinicalDocuments");
        boolean result = true;
        int count = 0;
        CDACHServices port = UserDocboxPreferences.getPort();
        List<DocumentInfoType> documentInfoTypes = port.getInboxClinicalDocuments(null);
        int maxworked = 60;
        int worked = 0;
        if (documentInfoTypes != null) {
            DocboxCDA docboxCDA = new DocboxCDA();
            int j = 0;
            while (j < documentInfoTypes.size()) {
                double tmpWorked;
                int newWorked;
                DocumentInfoType documentInfoType = documentInfoTypes.get(j);
                String id = documentInfoType.getDocumentID();
                CdaMessage cdaMessage = CdaMessage.getCdaMessageEvenIfDocsDeleted(id);
                if (cdaMessage == null || !cdaMessage.isDownloaded() && !cdaMessage.isDeleted()) {
                    if (cdaMessage == null) {
                        GregorianCalendar cal = (GregorianCalendar)GregorianCalendar.getInstance();
                        if (documentInfoType.getCreationDate() != null) {
                            cal.setTimeInMillis(documentInfoType.getCreationDate().toGregorianCalendar().getTimeInMillis());
                        } else {
                            cal = null;
                        }
                        cdaMessage = new CdaMessage(id, documentInfoType.getTitle(), cal);
                        log.debug("creating messseage with id " + id);
                    } else {
                        log.debug("redo download for document id " + id);
                    }
                    Holder clincialDocumentTypeHolder = new Holder();
                    Holder attachmentHolder = new Holder();
                    port.getClinicalDocument(id, (Holder<ClinicalDocumentType>)clincialDocumentTypeHolder, (Holder<byte[]>)attachmentHolder);
                    boolean unzipSuccessful = true;
                    if (attachmentHolder.value != null && !cdaMessage.unzipAttachment((byte[])attachmentHolder.value)) {
                        log.debug("unzip of attachment failed" + id);
                        unzipSuccessful = false;
                    }
                    if (clincialDocumentTypeHolder.value != null && unzipSuccessful) {
                        String receivedCDA = docboxCDA.marshallIntoString(((ClinicalDocumentType)clincialDocumentTypeHolder.value).getClinicalDocument());
                        CdaChXPath cdaChXPath = new CdaChXPath();
                        cdaChXPath.setPatientDocument(receivedCDA);
                        if (cdaMessage.setCda(receivedCDA)) {
                            String firstName = cdaChXPath.getPatientFirstName();
                            String lastName = cdaChXPath.getPatientLastName();
                            boolean first = !StringTool.isNothing((Object)firstName);
                            boolean last = !StringTool.isNothing((Object)firstName);
                            String patient = String.valueOf(first ? firstName : "") + (first && last ? " " : "") + (last ? lastName : "");
                            firstName = cdaChXPath.getAuthorFirstName();
                            lastName = cdaChXPath.getAuthorLastName();
                            String organization = cdaChXPath.getCustodianHospitalName();
                            boolean org = !StringTool.isNothing((Object)organization);
                            first = !StringTool.isNothing((Object)firstName);
                            last = !StringTool.isNothing((Object)lastName);
                            String sender = String.valueOf(first ? firstName : "") + (first && last ? " " : "") + (last ? lastName : "") + (org && (first || last) ? ", " : "") + (org ? organization : "");
                            if (!cdaMessage.setDownloaded(sender, patient)) {
                                log.debug("failed to set cda message downloaded with id " + id);
                                result = false;
                            } else {
                                ElexisEventDispatcher.update((PersistentObject)cdaMessage);
                                ++count;
                            }
                        } else {
                            log.debug("failed to set cda message downloaded with id " + id);
                            result = false;
                        }
                    }
                }
                if ((newWorked = (int)(tmpWorked = (double)(maxworked * (j + 1) / documentInfoTypes.size())) - worked) > 0 && newWorked > 0) {
                    monitor.worked(newWorked);
                    worked += newWorked;
                }
                ++j;
            }
        }
        ElexisEventDispatcher.reload(CdaMessage.class);
        int newWorked = maxworked - worked;
        if (newWorked > 0) {
            monitor.worked(newWorked);
        }
        return result ? count : -1;
    }

    public static void showResultInPopup(final String message) {
        Display display = UiDesk.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Display display = UiDesk.getDisplay();
                Shell shell = UiDesk.getTopShell();
                if (shell != null) {
                    ToolTip tip = new ToolTip(shell, 4098);
                    tip.setMessage(message);
                    Tray tray = display.getSystemTray();
                    TrayItem item = null;
                    if (tray != null) {
                        item = new TrayItem(tray, 0);
                        item.setImage(Activator.getImageDescriptor("icons/docbox16.png").createImage());
                        tip.setText("docbox");
                        item.setToolTip(tip);
                    } else {
                        tip.setText("docbox");
                        tip.setLocation(400, 400);
                    }
                    tip.setVisible(true);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        ExHandler.handle((Throwable)e);
                    }
                    tip.setVisible(false);
                    tip.dispose();
                    if (item != null) {
                        item.setVisible(false);
                        item.dispose();
                    }
                }
            }
        });
    }

    protected IStatus run(IProgressMonitor monitor) {
        boolean success = true;
        String msg = "";
        log.debug("running");
        if (CoreHub.getLoggedInContact() != null) {
            try {
                if (CoreHub.getLoggedInContact() != null && UserDocboxPreferences.hasValidDocboxCredentials()) {
                    log.debug("beginTask");
                    monitor.beginTask(Messages.DocboxBackgroundJob_Title, 200);
                    monitor.worked(10);
                    if (!monitor.isCanceled()) {
                        log.debug("fetchInboxClinicalDocuments");
                        int downloadedDocuments = this.fetchInboxClinicalDocuments(monitor);
                        if (downloadedDocuments > 0) {
                            msg = String.valueOf(msg) + String.format(Messages.DocboxBackgroundJob_DocumentsDownloaded, downloadedDocuments);
                        }
                        log.debug(msg);
                    }
                    if (UserDocboxPreferences.hasAgendaPlugin() && UserDocboxPreferences.downloadAppointments() && !monitor.isCanceled()) {
                        log.debug("fetchAppointments");
                        int downloadedAppointments = this.fetchAppointments(monitor);
                        if (!"".equals(msg)) {
                            msg = String.valueOf(msg) + "\n";
                        }
                        msg = String.valueOf(msg) + String.format(Messages.DocboxBackgroundJob_AppointmentsUpdated, downloadedAppointments);
                        log.debug(msg);
                    } else {
                        monitor.worked(60);
                    }
                    if (!monitor.isCanceled()) {
                        log.debug("updateDoctorDirectory");
                        int count = this.updateDoctorDirectory(monitor);
                        if (!"".equals(msg)) {
                            msg = String.valueOf(msg) + "\n";
                        }
                        msg = String.valueOf(msg) + String.format(Messages.DocboxBackgroundJob_DoctorDirecotoryUpdated, count);
                        log.debug(msg);
                    } else {
                        monitor.worked(60);
                    }
                    monitor.worked(10);
                    monitor.done();
                    if (msg != null && msg.length() > 0) {
                        DocboxBackgroundJob.showResultInPopup(msg);
                    }
                }
            }
            catch (Exception e) {
                ExHandler.handle((Throwable)e);
                log.debug("error in task", (Throwable)e);
            }
        }
        log.debug("stopped");
        return success ? Status.OK_STATUS : Status.CANCEL_STATUS;
    }
}

