/*
 * Decompiled with CFR 0.152.
 */
package ch.berchtold.emanuel.privatrechnung.rechnung;

import ch.berchtold.emanuel.privatrechnung.rechnung.RnPrintView;
import ch.elexis.core.data.interfaces.IRnOutputter;
import ch.elexis.core.data.util.ResultAdapter;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Fall;
import ch.elexis.data.Rechnung;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Result;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.slf4j.LoggerFactory;

public class RechnungsDrucker
implements IRnOutputter {
    private Button bFirst;
    private Button bSecond;
    private Button bThird;
    private boolean bSummary;
    private boolean bDetail;
    private boolean bReclaim;

    public boolean canBill(Fall fall) {
        return true;
    }

    public boolean canStorno(Rechnung rn) {
        return false;
    }

    public Object createSettingsControl(Object parent) {
        Composite compParent = (Composite)parent;
        Composite ret = new Composite(compParent, 0);
        ret.setLayout((Layout)new GridLayout());
        this.bFirst = new Button(ret, 32);
        this.bFirst.setText("Zusammenfassung");
        this.bSecond = new Button(ret, 32);
        this.bSecond.setText("Detail");
        this.bThird = new Button(ret, 32);
        this.bThird.setText("R\u00fcckforderungsbeleg");
        this.bFirst.setSelection(true);
        this.bSecond.setSelection(true);
        this.bThird.setSelection(true);
        return ret;
    }

    public Result<Rechnung> doOutput(IRnOutputter.TYPE type, final Collection<Rechnung> rnn, final Properties props) {
        final Result result = new Result();
        IWorkbenchPage rnPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        final Result res = new Result();
        props.setProperty("Summary", Boolean.toString(this.bSummary));
        props.setProperty("Detail", Boolean.toString(this.bDetail));
        props.setProperty("OutputWithReclaim", Boolean.toString(this.bReclaim));
        try {
            final RnPrintView rnp = (RnPrintView)rnPage.showView("ch.berchtold.privatrechung.view");
            progressService.runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask("Drucke Rechnungen", rnn.size() * 10);
                    int errors = 0;
                    for (Rechnung rn : rnn) {
                        try {
                            result.add(rnp.doPrint(rn, props));
                            monitor.worked(10);
                            if (!result.isOK()) {
                                String errms = "Rechnung " + rn.getNr() + "konnte nicht gedruckt werden";
                                res.add(Result.SEVERITY.ERROR, 1, errms, (Object)rn, true);
                                ++errors;
                                continue;
                            }
                            InvoiceState status_vorher = rn.getInvoiceState();
                            if (status_vorher == InvoiceState.OPEN || status_vorher == InvoiceState.DEMAND_NOTE_1 || status_vorher == InvoiceState.DEMAND_NOTE_2 || status_vorher == InvoiceState.DEMAND_NOTE_3) {
                                rn.setStatus(InvoiceState.fromState((int)(status_vorher.getState() + 1)));
                            }
                            rn.addTrace("Ausgegeben", String.valueOf(RechnungsDrucker.this.getDescription()) + ": " + rn.getInvoiceState().getLocaleText());
                        }
                        catch (Exception ex) {
                            LoggerFactory.getLogger(this.getClass()).error("Error printing", (Throwable)ex);
                            SWTHelper.showError((String)("Fehler beim Drucken der Rechnung " + rn.getRnId()), (String)ex.getMessage());
                            ++errors;
                        }
                    }
                    monitor.done();
                    if (errors == 0) {
                        SWTHelper.showInfo((String)"OK", (String)"OK");
                    } else {
                        SWTHelper.showError((String)"Fehler", (String)"Fehler");
                    }
                }
            }, null);
            rnPage.hideView((IViewPart)rnp);
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            res.add(Result.SEVERITY.ERROR, 2, ex.getMessage(), null, true);
            ErrorDialog.openError(null, (String)"Exception", (String)"Exception", (IStatus)ResultAdapter.getResultAsStatus((Result)res));
            return res;
        }
        if (!result.isOK()) {
            ResultAdapter.displayResult((Result)result, (String)"Fehler beim Rechnungsdruck");
        }
        return result;
    }

    public String getDescription() {
        return "Privatrechnung B. auf Drucker";
    }

    public void saveComposite() {
        this.bSummary = this.bFirst.getSelection();
        this.bDetail = this.bSecond.getSelection();
        this.bReclaim = this.bThird.getSelection();
    }
}

