/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.outbox.model.impl;

import at.medevit.elexis.outbox.model.IOutboxElement;
import at.medevit.elexis.outbox.model.IOutboxElementService;
import at.medevit.elexis.outbox.model.OutboxElementType;
import at.medevit.elexis.outbox.model.impl.DocumentStoreServiceHolder;
import at.medevit.elexis.outbox.model.impl.ModelUtil;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class OutboxElement
extends AbstractIdDeleteModelAdapter<ch.elexis.core.jpa.entities.OutboxElement>
implements IOutboxElement {
    public OutboxElement(ch.elexis.core.jpa.entities.OutboxElement entity) {
        super((EntityWithId)entity);
    }

    @Override
    public IOutboxElementService.State getState() {
        String stateStr = ((ch.elexis.core.jpa.entities.OutboxElement)this.getEntity()).getState();
        if (StringUtils.isEmpty((CharSequence)stateStr)) {
            return IOutboxElementService.State.NEW;
        }
        return IOutboxElementService.State.values()[Integer.parseInt(stateStr.trim())];
    }

    @Override
    public void setState(IOutboxElementService.State state) {
        ((ch.elexis.core.jpa.entities.OutboxElement)this.getEntityMarkDirty()).setState(Integer.toString(state.ordinal()));
    }

    @Override
    public void setUri(String uri) {
        ((ch.elexis.core.jpa.entities.OutboxElement)this.getEntityMarkDirty()).setUri(uri);
    }

    @Override
    public String getUri() {
        return ((ch.elexis.core.jpa.entities.OutboxElement)this.getEntity()).getUri();
    }

    @Override
    public Object getObject() {
        String uri = ((ch.elexis.core.jpa.entities.OutboxElement)this.getEntity()).getUri();
        OutboxElementType outboxElementType = OutboxElementType.parseType(uri);
        if (outboxElementType != null) {
            switch (outboxElementType) {
                case DB: {
                    Optional loaded = StoreToStringServiceHolder.get().loadFromString(uri);
                    if (!loaded.isPresent()) break;
                    return loaded.get();
                }
                case FILE: {
                    String refFile = uri.substring(OutboxElementType.FILE.getPrefix().length());
                    Path p = Paths.get(refFile, new String[0]);
                    return p;
                }
                case DOC: {
                    Optional doc;
                    String refDoc = uri.substring(OutboxElementType.DOC.getPrefix().length());
                    String[] splits = refDoc.split(":-:-:");
                    if (splits.length != 2 || !(doc = DocumentStoreServiceHolder.getService().loadDocument(splits[0], splits[1])).isPresent()) break;
                    return doc.get();
                }
            }
        }
        return null;
    }

    @Override
    public IPatient getPatient() {
        return ModelUtil.loadCoreModel((EntityWithId)((ch.elexis.core.jpa.entities.OutboxElement)this.getEntity()).getPatient(), IPatient.class);
    }

    @Override
    public void setPatient(IPatient value) {
        if (value instanceof AbstractIdDeleteModelAdapter) {
            ((ch.elexis.core.jpa.entities.OutboxElement)this.getEntityMarkDirty()).setPatient((Kontakt)((AbstractIdDeleteModelAdapter)value).getEntity());
        } else if (value == null) {
            ((ch.elexis.core.jpa.entities.OutboxElement)this.getEntityMarkDirty()).setPatient(null);
        }
    }

    @Override
    public IMandator getMandator() {
        return ModelUtil.loadCoreModel((EntityWithId)((ch.elexis.core.jpa.entities.OutboxElement)this.getEntity()).getMandant(), IMandator.class);
    }

    @Override
    public void setMandator(IMandator value) {
        if (value instanceof AbstractIdDeleteModelAdapter) {
            ((ch.elexis.core.jpa.entities.OutboxElement)this.getEntityMarkDirty()).setMandant((Kontakt)((AbstractIdDeleteModelAdapter)value).getEntity());
        } else if (value == null) {
            ((ch.elexis.core.jpa.entities.OutboxElement)this.getEntityMarkDirty()).setMandant(null);
        }
    }

    public String getLabel() {
        Object element = this.getObject();
        if (element instanceof IDocument) {
            String ext;
            String lbl = ((IDocument)element).getLabel();
            return lbl.endsWith(ext = ((IDocument)element).getExtension()) ? lbl : String.valueOf(lbl) + "." + ext.toLowerCase();
        }
        if (element instanceof Identifiable) {
            return ((Identifiable)element).getLabel();
        }
        if (element instanceof Path) {
            return ((Path)element).getFileName().toString();
        }
        return "OutboxElement " + this.getId() + " with no object.";
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return false;
    }

    public IXid getXid(String domain) {
        return null;
    }
}

