/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.loinc.model.impl;

import at.medevit.elexis.loinc.model.ILoincCodeService;
import at.medevit.elexis.loinc.model.LoincCode;
import at.medevit.elexis.loinc.model.impl.LoincCodeService;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.codes.ICodingContribution;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component
public class LoincCodingContribution
implements ICodingContribution {
    private ILoincCodeService iLoincCodeService;

    @Activate
    public void activate() {
        this.iLoincCodeService = new LoincCodeService();
    }

    public String getCodeSystem() {
        return CodingSystem.LOINC_CODESYSTEM.getSystem();
    }

    public List<ICoding> getCodes() {
        ArrayList<ICoding> codings = new ArrayList<ICoding>();
        for (LoincCode c : this.iLoincCodeService.getAllCodes()) {
            codings.add(c);
        }
        return codings;
    }

    public Optional<ICoding> getCode(String code) {
        return Optional.ofNullable(this.iLoincCodeService.getByCode(code));
    }
}

