/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.loinc.ui.parts;

import at.medevit.elexis.loinc.model.LoincCode;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.views.IDetailDisplay;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class LoincCodeDetailDisplay
implements IDetailDisplay {
    private FormToolkit toolkit;
    private ScrolledForm form;
    protected LoincCode actCode;
    private Section infoSection;
    private Text codeCode;
    private Text codeShortDesc;
    private Text codeUnit;
    private Text codeText;
    private Text codeClazz;

    public Class getElementClass() {
        return LoincCode.class;
    }

    public String getTitle() {
        return "LOINC";
    }

    public Composite createDisplay(Composite parent, IViewSite site) {
        this.toolkit = UiDesk.getToolkit();
        this.form = this.toolkit.createScrolledForm(parent);
        TableWrapLayout twl = new TableWrapLayout();
        this.form.getBody().setLayout((Layout)twl);
        this.form.setText("Kein LOINC Code ausgew\u00e4hlt.");
        this.form.getToolBarManager().add((IAction)new RemoveAction());
        this.form.getToolBarManager().update(true);
        this.infoSection = this.toolkit.createSection(this.form.getBody(), 354);
        TableWrapData twd = new TableWrapData(256);
        twd.grabHorizontal = true;
        this.infoSection.setLayoutData((Object)twd);
        this.infoSection.addExpansionListener((IExpansionListener)new SectionExpansionHandler());
        this.infoSection.setText("Details");
        Composite info = this.toolkit.createComposite((Composite)this.infoSection);
        twl = new TableWrapLayout();
        info.setLayout((Layout)twl);
        Label lbl = this.toolkit.createLabel(info, "Code");
        FontData[] bfd = lbl.getFont().getFontData();
        bfd[0].setStyle(1);
        Font boldFont = new Font((Device)Display.getCurrent(), bfd[0]);
        lbl.setFont(boldFont);
        this.codeCode = this.toolkit.createText(info, "");
        this.codeCode.setEditable(false);
        this.codeCode.setLayoutData((Object)new TableWrapData(256));
        lbl = this.toolkit.createLabel(info, "Kurz Beschreibung");
        lbl.setFont(boldFont);
        this.codeShortDesc = this.toolkit.createText(info, "");
        this.codeShortDesc.setEditable(false);
        twd = new TableWrapData(256);
        this.codeShortDesc.setLayoutData((Object)twd);
        lbl = this.toolkit.createLabel(info, "Einheit");
        lbl.setFont(boldFont);
        this.codeUnit = this.toolkit.createText(info, "");
        this.codeUnit.setEditable(false);
        twd = new TableWrapData(256);
        this.codeUnit.setLayoutData((Object)twd);
        lbl = this.toolkit.createLabel(info, "Text");
        lbl.setFont(boldFont);
        this.codeText = this.toolkit.createText(info, "", 578);
        this.codeText.setEditable(false);
        twd = new TableWrapData(256);
        twd.heightHint = 100;
        this.codeText.setLayoutData((Object)twd);
        lbl = this.toolkit.createLabel(info, "Klassifikation");
        lbl.setFont(boldFont);
        this.codeClazz = this.toolkit.createText(info, "");
        this.codeClazz.setEditable(false);
        twd = new TableWrapData(256);
        this.codeClazz.setLayoutData((Object)twd);
        this.infoSection.setClient((Control)info);
        return this.form.getBody();
    }

    @Inject
    public void selection(@Optional @Named(value="at.medevit.elexis.loinc.ui.parts.selection") @Named(value="at.medevit.elexis.loinc.ui.parts.selection") LoincCode code) {
        if (this.form != null && !this.form.isDisposed()) {
            this.display(code);
        }
    }

    public void display(Object obj) {
        if (obj instanceof LoincCode) {
            this.actCode = (LoincCode)obj;
            this.form.setText(this.actCode.getLabel());
            this.codeCode.setText(this.actCode.getCode());
            this.codeShortDesc.setText(this.actCode.get("shortname"));
            this.codeUnit.setText(this.actCode.get("unit"));
            this.codeText.setText(this.actCode.getText());
            this.codeClazz.setText(this.actCode.get("class"));
        } else {
            this.actCode = null;
            this.form.setText("Kein LOINC Code ausgew\u00e4hlt.");
            this.codeCode.setText("");
            this.codeShortDesc.setText("");
            this.codeUnit.setText("");
            this.codeText.setText("");
            this.codeClazz.setText("");
        }
        this.infoSection.layout();
        this.form.reflow(true);
    }

    protected class RemoveAction
    extends Action {
        protected RemoveAction() {
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_DELETE.getImageDescriptor();
        }

        public void run() {
            if (LoincCodeDetailDisplay.this.actCode != null) {
                LoincCodeDetailDisplay.this.actCode.delete();
                LoincCodeDetailDisplay.this.display(null);
                ElexisEventDispatcher.reload(LoincCode.class);
            }
        }
    }

    private final class SectionExpansionHandler
    extends ExpansionAdapter {
        private SectionExpansionHandler() {
        }

        public void expansionStateChanged(ExpansionEvent e) {
            LoincCodeDetailDisplay.this.form.reflow(true);
        }
    }
}

