/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.kapsch.referral.internal;

import at.medevit.elexis.kapsch.referral.KapschReferralService;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.types.Gender;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component(service={KapschReferralService.class})
public class KapschReferralServiceImpl
implements KapschReferralService {
    @Override
    public Optional<String> getPatientReferralUrl(Patient patient) {
        String getParams;
        URL url = this.getUrl();
        Map<String, Object> params = this.getPatientParameterMap(patient);
        this.applyMapping("op_klinikseeschau", params);
        if (params != null && (getParams = this.getMapAsGetParams(params)) != null) {
            LoggerFactory.getLogger(this.getClass()).info("Referral URL " + url.toString() + "?" + getParams);
            return Optional.of(String.valueOf(url.toString()) + "?" + getParams);
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> sendPatient(Patient patient) {
        byte[] postDataBytes;
        URL url = this.getUrl();
        Map<String, Object> params = this.getPatientParameterMap(patient);
        this.applyMapping("op_klinikseeschau", params);
        if (params != null && (postDataBytes = this.getMapAsPostData(params)) != null) {
            try {
                String inputLine;
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                conn.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
                conn.setDoOutput(true);
                conn.getOutputStream().write(postDataBytes);
                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while ((inputLine = in.readLine()) != null) {
                    System.out.println(inputLine);
                }
                in.close();
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error sending post data", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    private void applyMapping(String mappingname, Map<String, Object> params) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream inStream = this.getClass().getResourceAsStream("/rsc/mapping/" + mappingname + ".properties");){
                if (inStream != null) {
                    Properties keyMapping = new Properties();
                    keyMapping.load(inStream);
                    ArrayList<String> paramsKeys = new ArrayList<String>(params.keySet());
                    for (String key : paramsKeys) {
                        if (keyMapping.get(key) == null) continue;
                        Object value = params.get(key);
                        params.remove(key);
                        params.put((String)keyMapping.get(key), value);
                    }
                } else {
                    LoggerFactory.getLogger(this.getClass()).warn("No mapping properties for [" + mappingname + "] found");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error loading mapping properties for [" + mappingname + "]", (Throwable)e);
        }
    }

    private byte[] getMapAsPostData(Map<String, Object> params) {
        try {
            StringBuilder postData = new StringBuilder();
            for (Map.Entry<String, Object> param : params.entrySet()) {
                if (postData.length() != 0) {
                    postData.append('&');
                }
                postData.append(URLEncoder.encode(param.getKey(), "UTF-8"));
                postData.append('=');
                postData.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
            }
            return postData.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error getting post data", (Throwable)e);
            return null;
        }
    }

    private String getMapAsGetParams(Map<String, Object> params) {
        try {
            StringBuilder postData = new StringBuilder();
            for (Map.Entry<String, Object> param : params.entrySet()) {
                if (postData.length() != 0) {
                    postData.append('&');
                }
                postData.append(URLEncoder.encode(param.getKey(), "UTF-8"));
                postData.append('=');
                postData.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
            }
            return postData.toString();
        }
        catch (UnsupportedEncodingException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error getting get params", (Throwable)e);
            return null;
        }
    }

    private Map<String, Object> getPatientParameterMap(Patient patient) {
        Kontakt garant;
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("PID", patient.getPatCode());
        params.put("Lastname", patient.getName());
        params.put("Firstname", patient.getVorname());
        params.put("Street", patient.getAnschrift().getStrasse());
        params.put("PostalCode", patient.getAnschrift().getPlz());
        params.put("City", patient.getAnschrift().getOrt());
        params.put("Birthday", patient.getGeburtsdatum());
        params.put("Sex", this.getSex(patient));
        params.put("SSN", this.getSsn(patient));
        params.put("eMail", patient.get("E-Mail"));
        params.put("Phone", patient.get("Telefon1"));
        params.put("Mobile", patient.get("NatelNr"));
        Mandant mandator = ElexisEventDispatcher.getSelectedMandator();
        params.put("Referral", this.getMandatorName(mandator));
        params.put("ReferralStreet", mandator.getAnschrift().getStrasse());
        params.put("ReferralPostalCode", mandator.getAnschrift().getPlz());
        params.put("ReferralCity", mandator.getAnschrift().getOrt());
        params.put("ReferralId", this.getGln((Kontakt)mandator));
        params.put("ReferralEmail", mandator.get("E-Mail"));
        params.put("ReferralPhone", mandator.get("Telefon1"));
        Fall fall = (Fall)ElexisEventDispatcher.getSelected(Fall.class);
        if (fall != null && (garant = fall.getGarant()) != null) {
            params.put("GuarantorName", garant.get("Bezeichnung1"));
            params.put("GuarantorStreet", garant.getAnschrift().getStrasse());
            params.put("GuarantorPostalCode", garant.getAnschrift().getPlz());
            params.put("GuarantorCity", garant.getAnschrift().getOrt());
            params.put("GuarantorPhone", garant.get("Telefon1"));
            params.put("GuarantorGln", this.getGln(garant));
            if (StringUtils.isNotEmpty((CharSequence)((String)fall.getExtInfoStoredObjectByKey((Object)"VEKANr")))) {
                params.put("InsuranceCardNr", (String)fall.getExtInfoStoredObjectByKey((Object)"VEKANr"));
            }
            if (StringUtils.isNotEmpty((CharSequence)((String)fall.getExtInfoStoredObjectByKey((Object)"VEKAValid")))) {
                params.put("InsuranceCardExpiryDate", (String)fall.getExtInfoStoredObjectByKey((Object)"VEKAValid"));
            }
            params.put("EntryReason", fall.getConfiguredBillingSystemLaw().name());
            if (fall.getConfiguredBillingSystemLaw() == BillingLaw.UVG) {
                if (params.containsKey("GuarantorName")) {
                    params.put("UvgName", params.get("GuarantorName"));
                }
                if (StringUtils.isNotEmpty((CharSequence)fall.getRequiredString("Unfallnummer"))) {
                    params.put("AccidentNr", fall.getRequiredString("Unfallnummer"));
                }
                if (StringUtils.isNotEmpty((CharSequence)fall.getInfoString("Unfalldatum"))) {
                    params.put("DateOfAccident", fall.getRequiredString("Unfalldatum"));
                }
            }
            if (fall.getConfiguredBillingSystemLaw() == BillingLaw.KVG) {
                if (params.containsKey("GuarantorName")) {
                    params.put("KvgName", params.get("GuarantorName"));
                }
                if (params.containsKey("InsuranceCardNr")) {
                    params.put("KvgCardNr", params.get("InsuranceCardNr"));
                }
                if (StringUtils.isNotBlank((CharSequence)fall.getRequiredString("Versicherungsnummer"))) {
                    params.put("KvgContractNr", fall.getRequiredString("Versicherungsnummer"));
                }
            }
            if (fall.getConfiguredBillingSystemLaw() == BillingLaw.VVG) {
                if (params.containsKey("GuarantorName")) {
                    params.put("VvgName", params.get("GuarantorName"));
                }
                if (params.containsKey("InsuranceCardNr")) {
                    params.put("VvgCardNr", params.get("InsuranceCardNr"));
                }
                if (StringUtils.isNotBlank((CharSequence)fall.getRequiredString("Versicherungsnummer"))) {
                    params.put("VvgContractNr", fall.getRequiredString("Versicherungsnummer"));
                }
            }
        }
        return params;
    }

    private Object getMandatorName(Mandant mandator) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)mandator.get("Titel"))) {
            sb.append(mandator.get("Titel"));
        }
        if (StringUtils.isNotBlank((CharSequence)mandator.get("Vorname"))) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(mandator.get("Vorname"));
        }
        if (StringUtils.isNotBlank((CharSequence)mandator.get("Name"))) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(mandator.get("Name"));
        }
        return sb.toString();
    }

    private String getGln(Kontakt contact) {
        return contact.getXid("www.xid.ch/id/ean");
    }

    private String getSsn(Patient patient) {
        return patient.getXid("www.ahv.ch/xid");
    }

    private String getSex(Patient patient) {
        Gender gender = patient.getGender();
        if (gender == Gender.FEMALE) {
            return "W";
        }
        if (gender == Gender.MALE) {
            return "M";
        }
        return "U";
    }

    private URL getUrl() {
        try {
            String configEndpoint = ConfigServiceHolder.getMandator((String)"kapsch.referral.endpoint", (String)"productiv");
            if ("productiv".equals(configEndpoint)) {
                return new URL("https://referral.kapsch.health/webapp");
            }
            return new URL("https://referral-test.kapsch.health/webapp");
        }
        catch (MalformedURLException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error getting url", (Throwable)e);
            return null;
        }
    }
}

