/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.inbox.model.impl;

import at.medevit.elexis.inbox.model.IInboxElement;
import at.medevit.elexis.inbox.model.IInboxElementService;
import at.medevit.elexis.inbox.model.IInboxUpdateListener;
import at.medevit.elexis.inbox.model.InboxElementType;
import at.medevit.elexis.inbox.model.impl.ElementsProviderExtension;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IStoreToStringService;
import ch.elexis.data.PersistentObject;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.FileUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class InboxElementService
implements IInboxElementService {
    @Reference(target="(service.model.name=at.medevit.elexis.inbox.model)")
    private IModelService modelService;
    @Reference
    private IStoreToStringService storeToString;
    HashSet<IInboxUpdateListener> listeners = new HashSet();

    @Override
    public void createInboxElement(IPatient patient, IMandator mandator, Identifiable object) {
        IInboxElement element = (IInboxElement)this.modelService.create(IInboxElement.class);
        element.setPatient(patient);
        element.setMandator(mandator);
        this.storeToString.storeToString(object).ifPresent(sts -> element.setObject((String)sts));
        element.setState(IInboxElementService.State.NEW);
        this.modelService.save((Identifiable)element);
        this.fireUpdate(element);
    }

    @Override
    public void createInboxElement(IPatient patient, IMandator mandator, PersistentObject object) {
        IInboxElement element = (IInboxElement)this.modelService.create(IInboxElement.class);
        element.setPatient(patient);
        element.setMandator(mandator);
        element.setObject(object.storeToString());
        element.setState(IInboxElementService.State.NEW);
        this.modelService.save((Identifiable)element);
        this.fireUpdate(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUpdateListener(IInboxUpdateListener listener) {
        HashSet<IInboxUpdateListener> hashSet = this.listeners;
        synchronized (hashSet) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUpdateListener(IInboxUpdateListener listener) {
        HashSet<IInboxUpdateListener> hashSet = this.listeners;
        synchronized (hashSet) {
            this.listeners.add(listener);
        }
    }

    @Override
    public List<IInboxElement> getInboxElements(IMandator mandant, IPatient patient, IInboxElementService.State state) {
        IQuery query = this.modelService.getQuery(IInboxElement.class);
        if (mandant != null) {
            query.and("mandant", IQuery.COMPARATOR.EQUALS, (Object)mandant);
        }
        if (patient != null) {
            query.and("patient", IQuery.COMPARATOR.EQUALS, (Object)patient);
        }
        if (state != null) {
            query.and("state", IQuery.COMPARATOR.EQUALS, (Object)Integer.toString(state.ordinal()));
        }
        query.orderBy("lastupdate", IQuery.ORDER.DESC);
        return query.execute();
    }

    @Override
    public void changeInboxElementState(IInboxElement element, IInboxElementService.State state) {
        element.setState(state);
        this.modelService.save((Identifiable)element);
        this.fireUpdate(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireUpdate(IInboxElement element) {
        HashSet<IInboxUpdateListener> hashSet = this.listeners;
        synchronized (hashSet) {
            for (IInboxUpdateListener listener : this.listeners) {
                listener.update(element);
            }
        }
    }

    @Activate
    public void activate() {
        this.activateProviders();
    }

    @Deactivate
    public void deactivate() {
        this.deactivateProviders();
    }

    @Override
    public void createInboxElement(IPatient patient, IMandator mandant, String file, boolean copyFile) {
        File src;
        String path = file;
        if (path != null && (src = new File(path)).exists()) {
            if (copyFile) {
                try {
                    StringBuilder pathBuilder = new StringBuilder();
                    pathBuilder.append("inbox");
                    pathBuilder.append(File.separator);
                    pathBuilder.append(patient.getPatientNr());
                    pathBuilder.append("_");
                    pathBuilder.append(System.currentTimeMillis());
                    pathBuilder.append("_");
                    pathBuilder.append(src.getName());
                    File dest = new File(CoreHub.getWritableUserDir(), pathBuilder.toString());
                    FileUtils.copyFile((File)src, (File)dest);
                    path = dest.getAbsolutePath();
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(InboxElementService.class).error("file copy error", (Throwable)e);
                    return;
                }
            }
            IInboxElement element = (IInboxElement)this.modelService.create(IInboxElement.class);
            element.setPatient(patient);
            element.setMandator(mandant);
            element.setObject(String.valueOf(InboxElementType.FILE.getPrefix()) + path);
            element.setState(IInboxElementService.State.NEW);
            this.modelService.save((Identifiable)element);
            this.fireUpdate(element);
        }
    }

    @Override
    public void deactivateProviders() {
        LoggerFactory.getLogger(this.getClass()).info("Deactivating all ElementProviders");
        ElementsProviderExtension.deactivateAll();
    }

    @Override
    public void activateProviders() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            LoggerFactory.getLogger(this.getClass()).info("Activating all ElementProviders");
            ElementsProviderExtension.activateAll();
        });
        executor.shutdown();
    }
}

