/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.inbox.ui.part;

import at.medevit.elexis.inbox.model.IInboxElement;
import at.medevit.elexis.inbox.model.IInboxElementService;
import at.medevit.elexis.inbox.model.IInboxUpdateListener;
import at.medevit.elexis.inbox.ui.InboxModelServiceHolder;
import at.medevit.elexis.inbox.ui.InboxServiceHolder;
import at.medevit.elexis.inbox.ui.part.action.InboxFilterAction;
import at.medevit.elexis.inbox.ui.part.model.GroupedInboxElements;
import at.medevit.elexis.inbox.ui.part.model.PatientInboxElements;
import at.medevit.elexis.inbox.ui.part.provider.IInboxElementUiProvider;
import at.medevit.elexis.inbox.ui.part.provider.InboxElementContentProvider;
import at.medevit.elexis.inbox.ui.part.provider.InboxElementUiExtension;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.views.controls.PagingComposite;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.commands.Command;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.slf4j.LoggerFactory;

public class InboxView
extends ViewPart {
    private PagingComposite pagingComposite;
    private Text filterText;
    private TableViewer viewer;
    private boolean reloadPending;
    private InboxElementContentProvider contentProvider;
    private boolean setAutoSelectPatient;
    private TableViewerColumn mandatorColumn;
    private InboxElementComparator comparator;
    private List<IMandator> selectedMandators;

    @Optional
    @Inject
    public void activeMandator(IMandator mandator) {
        Display.getDefault().asyncExec(() -> {
            if (this.selectedMandators == null || this.selectedMandators.isEmpty()) {
                this.reload();
            }
        });
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.pagingComposite = new PagingComposite(composite, 0){

            public void runPaging() {
                InboxView.this.viewer.refresh();
            }
        };
        Composite filterComposite = new Composite(composite, 0);
        GridData data = new GridData(768);
        filterComposite.setLayoutData((Object)data);
        filterComposite.setLayout((Layout)new GridLayout(2, false));
        this.filterText = new Text(filterComposite, 128);
        this.filterText.setMessage("Patienten Suche nach Nachname, Vorname, Geburtsdatum oder #PatientenNr");
        data = new GridData(768);
        this.filterText.setLayoutData((Object)data);
        WidgetProperties.text((int)24).observeDelayed(500, (Widget)this.filterText).addValueChangeListener((IValueChangeListener)new IValueChangeListener<String>(){

            public void handleValueChange(ValueChangeEvent<? extends String> event) {
                InboxView.this.contentProvider.setSearchText((String)event.diff.getNewValue());
                InboxView.this.viewer.refresh();
            }
        });
        ToolBarManager menuManager = new ToolBarManager(8388928);
        menuManager.createControl(filterComposite);
        this.viewer = new TableViewer(composite, 268503810);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        this.viewer.getControl().setLayoutData((Object)gd);
        this.contentProvider = new InboxElementContentProvider(this);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.getTable().setHeaderVisible(true);
        this.comparator = new InboxElementComparator();
        this.viewer.setComparator((ViewerComparator)this.comparator);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        TableViewerColumn column = new TableViewerColumn(this.viewer, 0);
        column.setLabelProvider((CellLabelProvider)new EmulatedCheckBoxLabelProvider(){

            @Override
            protected boolean isChecked(Object element) {
                if (element instanceof IInboxElement) {
                    return ((IInboxElement)element).getState() == IInboxElementService.State.SEEN;
                }
                return false;
            }
        });
        column.setEditingSupport((EditingSupport)new CheckBoxColumnEditingSupport(this.viewer));
        column.getColumn().setText("Visiert");
        column.getColumn().setWidth(50);
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setWidth(75);
        column.getColumn().setText("Kategorie");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            private InboxElementUiExtension extension = new InboxElementUiExtension();

            public Image getImage(Object element) {
                if (element instanceof IInboxElement) {
                    return this.extension.getImage((IInboxElement)element);
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                return null;
            }
        });
        this.mandatorColumn = new TableViewerColumn(this.viewer, 0);
        this.mandatorColumn.getColumn().setWidth(0);
        this.mandatorColumn.getColumn().setText("Mandant");
        this.mandatorColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IInboxElement) {
                    return ((IInboxElement)element).getMandator() != null ? ((IInboxElement)element).getMandator().getLabel() : "?";
                }
                return super.getText(element);
            }
        });
        this.mandatorColumn.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(this.mandatorColumn.getColumn(), 0));
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setWidth(250);
        column.getColumn().setText("Patient");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IInboxElement) {
                    return ((IInboxElement)element).getPatient() != null ? ((IInboxElement)element).getPatient().getLabel() : "?";
                }
                return super.getText(element);
            }
        });
        column.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(column.getColumn(), 1));
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setWidth(80);
        column.getColumn().setText("Datum");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            private InboxElementUiExtension extension = new InboxElementUiExtension();
            private DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("dd.MM.yyyy");

            public String getText(Object element) {
                if (element instanceof IInboxElement) {
                    LocalDate objectDate = this.extension.getObjectDate((IInboxElement)element);
                    if (objectDate != null) {
                        return this.dateFormat.format(objectDate);
                    }
                    return "?";
                }
                return super.getText(element);
            }
        });
        SelectionAdapter selectionAdapter = this.getSelectionAdapter(column.getColumn(), 2);
        selectionAdapter.widgetSelected(null);
        column.getColumn().addSelectionListener((SelectionListener)selectionAdapter);
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setWidth(250);
        column.getColumn().setText("Beschreibung");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            private InboxElementUiExtension extension = new InboxElementUiExtension();

            public String getText(Object element) {
                if (element instanceof IInboxElement) {
                    return this.extension.getText((IInboxElement)element);
                }
                return super.getText(element);
            }

            public String getToolTipText(Object element) {
                if (element instanceof IInboxElement) {
                    return this.extension.getTooltipText((IInboxElement)element);
                }
                return super.getText(element);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object selectedObj;
                StructuredSelection selection = (StructuredSelection)InboxView.this.viewer.getSelection();
                if (!selection.isEmpty() && (selectedObj = selection.getFirstElement()) instanceof IInboxElement) {
                    InboxElementUiExtension extension = new InboxElementUiExtension();
                    extension.fireDoubleClicked((IInboxElement)selectedObj);
                }
            }
        });
        this.viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                IStructuredSelection currentSelection;
                if (e.keyCode == 32 && (currentSelection = InboxView.this.viewer.getStructuredSelection()) != null && !currentSelection.isEmpty() && currentSelection.getFirstElement() instanceof IInboxElement) {
                    IInboxElement element;
                    InboxView.this.setInboxElementState(element, (element = (IInboxElement)currentSelection.getFirstElement()).getState() != IInboxElementService.State.SEEN);
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection && !selection.isEmpty()) {
                    if (InboxView.this.setAutoSelectPatient) {
                        Object selectedElement = ((StructuredSelection)selection).getFirstElement();
                        if (selectedElement instanceof IInboxElement) {
                            ContextServiceHolder.get().setActivePatient(((IInboxElement)selectedElement).getPatient());
                        } else if (selectedElement instanceof PatientInboxElements) {
                            ContextServiceHolder.get().setActivePatient(((PatientInboxElements)selectedElement).getPatient());
                        }
                    }
                    if (((StructuredSelection)selection).getFirstElement() instanceof IInboxElement) {
                        InboxElementUiExtension extension = new InboxElementUiExtension();
                        extension.fireSingleClicked((IInboxElement)((StructuredSelection)selection).getFirstElement());
                    }
                }
            }
        });
        final Transfer[] dropTransferTypes = new Transfer[]{FileTransfer.getInstance()};
        this.viewer.addDropSupport(1, dropTransferTypes, (DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 1;
            }

            public void drop(DropTargetEvent event) {
                if (dropTransferTypes[0].isSupportedType(event.currentDataType)) {
                    String[] files = (String[])event.data;
                    IPatient patient = null;
                    if (event.item != null) {
                        Object data = event.item.getData();
                        if (data instanceof IInboxElement) {
                            patient = ((IInboxElement)data).getPatient();
                        } else if (data instanceof PatientInboxElements) {
                            patient = ((PatientInboxElements)data).getPatient();
                        }
                    }
                    if (patient == null) {
                        patient = ContextServiceHolder.get().getActivePatient().orElse(null);
                    }
                    if (patient != null) {
                        if (files != null) {
                            String[] stringArray = files;
                            int n = files.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String file = stringArray[n2];
                                try {
                                    InboxServiceHolder.get().createInboxElement(patient, (IMandator)ContextServiceHolder.get().getActiveMandator().orElse(null), file, true);
                                }
                                catch (Exception e) {
                                    LoggerFactory.getLogger(InboxView.class).warn("drop error", (Throwable)e);
                                }
                                ++n2;
                            }
                        }
                        InboxView.this.viewer.refresh();
                    } else {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warnung", (String)"Bitte w\u00e4hlen Sie zuerst einen Patienten aus.");
                    }
                }
            }
        });
        this.addFilterActions(menuManager);
        InboxServiceHolder.get().addUpdateListener(new IInboxUpdateListener(){

            public void update(final IInboxElement element) {
                if (InboxView.this.viewer != null && !InboxView.this.viewer.getControl().isDisposed()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).InboxView.this.contentProvider.refreshElement(element);
                            (this).InboxView.this.viewer.refresh(false);
                        }
                    });
                }
            }
        });
        this.reload();
        MenuManager ctxtMenuManager = new MenuManager();
        Menu menu = ctxtMenuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(ctxtMenuManager, (ISelectionProvider)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.setAutoSelectPatientState(ConfigServiceHolder.getUser((String)"inbox/patient/autoselect", (boolean)false));
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InboxView.this.comparator.setColumn(index);
                InboxView.this.viewer.getTable().setSortDirection(InboxView.this.comparator.getDirection());
                InboxView.this.viewer.getTable().setSortColumn(column);
                InboxView.this.viewer.refresh();
            }
        };
        return selectionAdapter;
    }

    public void setAutoSelectPatientState(boolean value) {
        this.setAutoSelectPatient = value;
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand("at.medevit.elexis.inbox.ui.autoSelectPatient");
        command.getState("org.eclipse.ui.commands.toggleState").setValue((Object)value);
        ConfigServiceHolder.setUser((String)"inbox/patient/autoselect", (boolean)value);
    }

    private void addFilterActions(ToolBarManager menuManager) {
        InboxElementUiExtension extension = new InboxElementUiExtension();
        List<IInboxElementUiProvider> providers = extension.getProviders();
        for (IInboxElementUiProvider iInboxElementUiProvider : providers) {
            List<ViewerFilter> extensionFilters = iInboxElementUiProvider.getFilters();
            for (ViewerFilter extensionFilter : extensionFilters) {
                InboxFilterAction action = new InboxFilterAction((StructuredViewer)this.viewer, extensionFilter, iInboxElementUiProvider.getFilterImage(extensionFilter));
                menuManager.add((IAction)action);
            }
        }
        menuManager.update(true);
    }

    public void setFocus() {
        this.filterText.setFocus();
        if (this.reloadPending) {
            this.reload();
        }
    }

    public List<IInboxElement> getOpenInboxElements() {
        if (this.selectedMandators == null || this.selectedMandators.isEmpty()) {
            this.mandatorColumn.getColumn().setWidth(0);
            return InboxServiceHolder.get().getInboxElements((IMandator)ContextServiceHolder.get().getActiveMandator().orElse(null), null, IInboxElementService.State.NEW);
        }
        this.mandatorColumn.getColumn().setWidth(75);
        ArrayList<IInboxElement> mandatorsElements = new ArrayList<IInboxElement>();
        for (IMandator mandator : this.selectedMandators) {
            mandatorsElements.addAll(InboxServiceHolder.get().getInboxElements(mandator, null, IInboxElementService.State.NEW));
        }
        return mandatorsElements;
    }

    public PagingComposite getPagingComposite() {
        return this.pagingComposite;
    }

    public void reload() {
        List<IInboxElement> input = this.getOpenInboxElements();
        this.viewer.setInput(input);
        this.viewer.refresh();
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    private void setInboxElementState(IInboxElement element, Boolean value) {
        if (Boolean.TRUE.equals(value)) {
            element.setState(IInboxElementService.State.SEEN);
            if (!(element instanceof GroupedInboxElements)) {
                InboxModelServiceHolder.get().save((Identifiable)element);
            }
        } else {
            element.setState(IInboxElementService.State.NEW);
            if (!(element instanceof GroupedInboxElements)) {
                InboxModelServiceHolder.get().save((Identifiable)element);
            }
        }
        this.viewer.refresh();
        Display.getDefault().timerExec(50, () -> {
            if (this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
                this.contentProvider.refreshElement(element);
                this.viewer.refresh();
            }
        });
    }

    public void setSelectedMandators(List<IMandator> mandators) {
        this.selectedMandators = mandators;
        this.reload();
    }

    private class CheckBoxColumnEditingSupport
    extends EditingSupport {
        private final TableViewer tableViewer;

        public CheckBoxColumnEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.tableViewer = viewer;
        }

        protected CellEditor getCellEditor(Object o) {
            return new CheckboxCellEditor(null, 32);
        }

        protected boolean canEdit(Object o) {
            return true;
        }

        protected Object getValue(Object o) {
            IInboxElement element = (IInboxElement)o;
            if (element.getState() == IInboxElementService.State.SEEN) {
                return true;
            }
            return false;
        }

        protected void setValue(Object o, Object value) {
            InboxView.this.setInboxElementState((IInboxElement)o, (Boolean)value);
        }
    }

    private static abstract class EmulatedCheckBoxLabelProvider
    extends ColumnLabelProvider {
        private static Image CHECKED = AbstractUIPlugin.imageDescriptorFromPlugin((String)"at.medevit.elexis.inbox.ui", (String)"rsc/img/checked_checkbox.png").createImage();
        private static Image UNCHECKED = AbstractUIPlugin.imageDescriptorFromPlugin((String)"at.medevit.elexis.inbox.ui", (String)"rsc/img/unchecked_checkbox.png").createImage();

        private EmulatedCheckBoxLabelProvider() {
        }

        public String getText(Object element) {
            return null;
        }

        public Image getImage(Object element) {
            return this.isChecked(element) ? CHECKED : UNCHECKED;
        }

        protected abstract boolean isChecked(Object var1);
    }

    private class InboxElementComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int DESCENDING = 1;
        private int direction = 1;
        private InboxElementUiExtension extension = new InboxElementUiExtension();

        public int getDirection() {
            return this.direction == 1 ? 1024 : 128;
        }

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = 1 - this.direction;
            } else {
                this.propertyIndex = column;
                this.direction = 1;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            IInboxElement i1 = (IInboxElement)e1;
            IInboxElement i2 = (IInboxElement)e2;
            int rc = 0;
            switch (this.propertyIndex) {
                case 0: {
                    IMandator m1 = i1.getMandator();
                    IMandator m2 = i2.getMandator();
                    String mtxt1 = m1 != null ? m1.getLabel() : "";
                    String mtxt2 = m2 != null ? m2.getLabel() : "";
                    rc = mtxt1.toLowerCase().compareTo(mtxt2.toLowerCase());
                    break;
                }
                case 1: {
                    IPatient p1 = i1.getPatient();
                    IPatient p2 = i2.getPatient();
                    String ptxt1 = p1 != null ? p1.getLabel() : "";
                    String ptxt2 = p2 != null ? p2.getLabel() : "";
                    rc = ptxt1.toLowerCase().compareTo(ptxt2.toLowerCase());
                    break;
                }
                case 2: {
                    LocalDate t1 = this.extension.getObjectDate(i1);
                    LocalDate t2 = this.extension.getObjectDate(i2);
                    t1 = t1 == null ? LocalDate.EPOCH : t1;
                    t2 = t2 == null ? LocalDate.EPOCH : t2;
                    rc = t1.compareTo(t2);
                    break;
                }
                default: {
                    rc = 0;
                }
            }
            if (this.direction == 1) {
                rc = -rc;
            }
            return rc;
        }
    }
}

