/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.hin.auth.core.internal;

import at.medevit.elexis.hin.auth.core.IHinAuthService;
import at.medevit.elexis.hin.auth.core.IHinAuthUi;
import at.medevit.elexis.hin.auth.core.internal.GetAuthCodeWithStateSupplier;
import ch.elexis.core.services.IConfigService;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.LoggerFactory;

@Component
public class HinAuthService
implements IHinAuthService {
    @Reference
    private IConfigService configService;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    private IHinAuthUi authUi;
    private boolean useQueryParam = true;
    private String currentState;

    @Override
    public Optional<String> getToken(Map<String, Object> parameters) {
        String tokenGroup = (String)parameters.get("token_group");
        if (StringUtils.isNotBlank((CharSequence)tokenGroup)) {
            Optional<String> existingToken = this.validateToken(this.configService.getActiveMandator("hin/auth/token/" + tokenGroup, null), tokenGroup);
            if (existingToken.isEmpty() && this.authUi != null) {
                return this.getToken(tokenGroup, this.authUi);
            }
            if (existingToken.isPresent()) {
                return existingToken;
            }
        }
        return Optional.empty();
    }

    private Optional<String> getToken(String tokenGroup, IHinAuthUi iHinAuthUi) {
        Optional<String> authCode = this.getAuthCode(tokenGroup, iHinAuthUi);
        if (authCode.isPresent()) {
            return this.getAccessToken(tokenGroup, authCode.get(), this.getOauthRestUrl());
        }
        LoggerFactory.getLogger(this.getClass()).warn("No auth code for [" + tokenGroup + "]");
        return Optional.empty();
    }

    private String getOauthRestUrl() {
        return this.configService.get("hin/auth/rest/baseurl", "https://oauth2.hin.ch/REST/v1/OAuth/");
    }

    private Optional<String> getAccessTokenWithRefresh(String tokenGroup, String refreshToken, String oauthRestUrl) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("grant_type", "refresh_token");
        parameters.put("refresh_token", refreshToken);
        parameters.put("client_id", this.getClientId());
        parameters.put("client_secret", this.getClientSecret());
        String form = parameters.entrySet().stream().map(e -> String.valueOf((String)e.getKey()) + "=" + URLEncoder.encode((String)e.getValue(), StandardCharsets.UTF_8)).collect(Collectors.joining("&"));
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(String.valueOf(oauthRestUrl) + "GetAccessToken")).headers("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(form)).build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                Gson gson = new Gson();
                Map map = (Map)gson.fromJson(response.body().toString(), Map.class);
                String token = (String)map.get("access_token");
                this.configService.setActiveMandator("hin/auth/token/" + tokenGroup, token);
                String refreshtoken = (String)map.get("refresh_token");
                if (StringUtils.isNotBlank((CharSequence)refreshtoken)) {
                    this.configService.setActiveMandator("hin/auth/refreshtoken/" + tokenGroup, refreshtoken);
                }
                Double expiresInSeconds = (Double)map.get("expires_in");
                Long expires = Long.valueOf(System.currentTimeMillis()) + expiresInSeconds.longValue() * 1000L;
                this.configService.setActiveMandator("hin/auth/tokenexpires/" + tokenGroup, Long.toString(expires));
                LoggerFactory.getLogger(this.getClass()).info("Got refreshed access token for [" + tokenGroup + "] expires [" + Long.toString(expires) + "]");
                return Optional.of(token);
            }
            LoggerFactory.getLogger(this.getClass()).error("Getting refreshed access token failed [" + response.statusCode() + " " + response.body().toString() + "]");
        }
        catch (IOException | InterruptedException e2) {
            LoggerFactory.getLogger(this.getClass()).error("Error getting refreshed access token", (Throwable)e2);
        }
        return Optional.empty();
    }

    private Optional<String> getAccessToken(String tokenGroup, String authCode, String oauthRestUrl) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("grant_type", "authorization_code");
        parameters.put("code", authCode);
        parameters.put("redirect_uri", this.getRedirectUri());
        parameters.put("client_id", this.getClientId());
        parameters.put("client_secret", this.getClientSecret());
        String form = parameters.entrySet().stream().map(e -> String.valueOf((String)e.getKey()) + "=" + URLEncoder.encode((String)e.getValue(), StandardCharsets.UTF_8)).collect(Collectors.joining("&"));
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(String.valueOf(oauthRestUrl) + "GetAccessToken")).headers("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(form)).build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                Gson gson = new Gson();
                Map map = (Map)gson.fromJson(response.body().toString(), Map.class);
                String token = (String)map.get("access_token");
                this.configService.setActiveMandator("hin/auth/token/" + tokenGroup, token);
                String refreshtoken = (String)map.get("refresh_token");
                if (StringUtils.isNotBlank((CharSequence)refreshtoken)) {
                    this.configService.setActiveMandator("hin/auth/refreshtoken/" + tokenGroup, refreshtoken);
                }
                Double expiresInSeconds = (Double)map.get("expires_in");
                Long expires = Long.valueOf(System.currentTimeMillis()) + expiresInSeconds.longValue() * 1000L;
                this.configService.setActiveMandator("hin/auth/tokenexpires/" + tokenGroup, Long.toString(expires));
                LoggerFactory.getLogger(this.getClass()).info("Got access token for [" + tokenGroup + "] expires [" + Long.toString(expires) + "]");
                return Optional.of(token);
            }
            LoggerFactory.getLogger(this.getClass()).error("Getting access token failed [" + response.statusCode() + " " + response.body().toString() + "]");
        }
        catch (IOException | InterruptedException e2) {
            LoggerFactory.getLogger(this.getClass()).error("Error getting access token", (Throwable)e2);
        }
        return Optional.empty();
    }

    private Optional<String> getAuthCode(String tokenGroup, IHinAuthUi iHinAuthUi) {
        if (this.useQueryParam) {
            iHinAuthUi.openBrowser(this.getQueryParamUrl(tokenGroup));
            Object value = iHinAuthUi.getWithCancelableProgress("HIN Berechtigung im Browser best\u00e4tigen.", new GetAuthCodeWithStateSupplier(this.getCurrentState(false)));
            if (value instanceof String) {
                return Optional.of((String)value);
            }
            return Optional.empty();
        }
        iHinAuthUi.openBrowser(this.getWebappUrl(tokenGroup));
        return iHinAuthUi.openInputDialog("HIN oAuth Token", "Bitte geben Sie den oAuth Code von der HIN Webseite hier ein.");
    }

    private String getWebappUrl(String tokenGroup) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.configService.get("hin/auth/wabapp/baseurl", "http://apps.hin.ch/#app=HinCredMgrOAuth;"));
        sb.append("tokenGroup=");
        sb.append(URLEncoder.encode(tokenGroup, StandardCharsets.UTF_8));
        return sb.toString();
    }

    private String getQueryParamUrl(String tokenGroup) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.configService.get("hin/auth/rest/baseurl", "http://apps.hin.ch/REST/v1/OAuth/"));
        sb.append("GetAuthCode/");
        sb.append(URLEncoder.encode(tokenGroup, StandardCharsets.UTF_8));
        sb.append("?response_type=code");
        sb.append("&client_id=");
        sb.append(URLEncoder.encode(this.getClientId(), StandardCharsets.UTF_8));
        sb.append("&redirect_uri=");
        sb.append(URLEncoder.encode(this.getRedirectUri(), StandardCharsets.UTF_8));
        sb.append("&state=");
        sb.append(URLEncoder.encode(this.getCurrentState(true), StandardCharsets.UTF_8));
        return sb.toString();
    }

    private String getRedirectUri() {
        if (this.useQueryParam) {
            return "https://tools.medelexis.ch/hin/ac";
        }
        return "";
    }

    private String getCurrentState(boolean refresh) {
        if (refresh) {
            this.currentState = UUID.randomUUID().toString();
        }
        return this.currentState;
    }

    private String getClientId() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream properties = this.getClass().getResourceAsStream("/rsc/id.properties");){
                if (properties != null) {
                    Properties idProps = new Properties();
                    idProps.load(properties);
                    return idProps.getProperty("client_id");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Error loading id properties", (Throwable)e);
        }
        return "";
    }

    private String getClientSecret() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream properties = this.getClass().getResourceAsStream("/rsc/id.properties");){
                if (properties != null) {
                    Properties idProps = new Properties();
                    idProps.load(properties);
                    return idProps.getProperty("client_secret");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Error loading id properties", (Throwable)e);
        }
        return "";
    }

    private Optional<String> validateToken(String existingToken, String tokenGroup) {
        String tokenExpires;
        if (StringUtils.isNotBlank((CharSequence)existingToken) && StringUtils.isNotBlank((CharSequence)(tokenExpires = this.configService.getActiveMandator("hin/auth/tokenexpires/" + tokenGroup, null)))) {
            Long expires = Long.parseLong(tokenExpires);
            if (System.currentTimeMillis() > expires) {
                String refreshToken = this.configService.getActiveMandator("hin/auth/refreshtoken/" + tokenGroup, null);
                if (StringUtils.isNotBlank((CharSequence)refreshToken)) {
                    Optional<String> refreshedToken = this.getAccessTokenWithRefresh(tokenGroup, refreshToken, this.getOauthRestUrl());
                    if (refreshedToken.isPresent()) {
                        return refreshedToken;
                    }
                    this.configService.setActiveMandator("hin/auth/refreshtoken/" + tokenGroup, null);
                }
                this.configService.setActiveMandator("hin/auth/token/" + tokenGroup, null);
                this.configService.setActiveMandator("hin/auth/tokenexpires/" + tokenGroup, null);
            } else {
                return Optional.of(existingToken);
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> handleException(Exception ex, Map<String, Object> parameters) {
        if (ex.getMessage().contains("HTTP response code: 401")) {
            String tokenGroup = (String)parameters.get("token_group");
            LoggerFactory.getLogger(this.getClass()).info("Got HTTP 401 invalidating token for [" + tokenGroup + "]");
            this.configService.setActiveMandator("hin/auth/token/" + tokenGroup, null);
            this.configService.setActiveMandator("hin/auth/tokenexpires/" + tokenGroup, null);
            return Optional.of("HIN oAuth token f\u00fcr [" + tokenGroup + "] nicht mehr g\u00fcltig.");
        }
        return Optional.empty();
    }
}

