/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.gdt.ui.dialog.provider;

import java.util.ArrayList;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

public class Feld8402ContentProposalProvider
implements IContentProposalProvider {
    private String[] proposals;
    private String[] labels;
    private String[] detailDescription;
    private IContentProposal[] contentProposals;
    private boolean filterProposals = false;

    public Feld8402ContentProposalProvider(String[] proposals, String[] labels, String[] detailDescription) {
        this.proposals = proposals;
        this.labels = labels;
        this.detailDescription = detailDescription;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        if (this.filterProposals) {
            ArrayList<IContentProposal> list = new ArrayList<IContentProposal>();
            int i = 0;
            while (i < this.proposals.length) {
                if (this.proposals[i].length() >= contents.length() && this.proposals[i].substring(0, contents.length()).equalsIgnoreCase(contents)) {
                    list.add(this.makeContentProposal(this.proposals[i], this.labels[i], this.detailDescription[i]));
                }
                ++i;
            }
            return list.toArray(new IContentProposal[list.size()]);
        }
        if (this.contentProposals == null) {
            this.refreshProposals();
        }
        return this.contentProposals;
    }

    public void setProposals(String[] proposals, String[] labels, String[] detailDescription) {
        this.proposals = proposals;
        this.labels = labels;
        this.detailDescription = detailDescription;
        this.contentProposals = null;
        this.refreshProposals();
    }

    public void setFiltering(boolean filterProposals) {
        this.filterProposals = filterProposals;
        this.contentProposals = null;
    }

    private void refreshProposals() {
        this.contentProposals = new IContentProposal[this.proposals.length];
        int i = 0;
        while (i < this.proposals.length) {
            String detailDescriptionA = null;
            if (this.detailDescription != null && this.detailDescription[i] != null) {
                detailDescriptionA = this.detailDescription[i];
            }
            this.contentProposals[i] = this.makeContentProposal(this.proposals[i], this.labels[i], detailDescriptionA);
            ++i;
        }
    }

    private IContentProposal makeContentProposal(final String proposal, final String label, final String detailDescription) {
        return new IContentProposal(){

            public String getContent() {
                return proposal;
            }

            public String getDescription() {
                return detailDescription;
            }

            public String getLabel() {
                return String.valueOf(proposal) + " - " + label;
            }

            public int getCursorPosition() {
                return proposal.length();
            }
        };
    }
}

