/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.gdt.command;

import at.medevit.elexis.gdt.handler.GDTOutputHandler;
import at.medevit.elexis.gdt.interfaces.HandlerProgramType;
import at.medevit.elexis.gdt.interfaces.IGDTCommunicationPartner;
import at.medevit.elexis.gdt.messages.GDTSatzNachricht6302;
import at.medevit.elexis.gdt.tools.GDTSatzNachrichtHelper;
import at.medevit.elexis.gdt.ui.dialog.NeueUntersuchungAnfordernDialog;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.Identifiable;
import ch.elexis.data.Patient;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class NeueUntersuchungAnfordern
extends AbstractHandler {
    private static final String PARAM_TARGET_ID = "at.medevit.elexis.gdt.cmd.parameter.targetId";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection;
        Patient pat = null;
        IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (iWorkbenchWindow != null && (selection = iWorkbenchWindow.getActivePage().getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection strucSelection = (IStructuredSelection)selection;
            pat = this.getAsPatient(strucSelection);
        }
        String configuredGDTId = CoreHub.localCfg.get("GDT/Identity", "");
        if (pat == null) {
            pat = ElexisEventDispatcher.getSelectedPatient();
        }
        if (pat == null) {
            return null;
        }
        GDTSatzNachricht6302 gdt6302 = new GDTSatzNachricht6302(pat.get("PatientNr"), pat.getName(), pat.getVorname(), pat.getGeburtsdatum(), null, pat.get("Titel"), null, String.valueOf(pat.get("Plz")) + " " + pat.get("Ort"), pat.get("Strasse"), null, GDTSatzNachrichtHelper.bestimmeGeschlechtsWert(pat.get("Geschlecht")), null, null, null, null, null, null, configuredGDTId, "2", "02.10");
        NeueUntersuchungAnfordernDialog nuad = new NeueUntersuchungAnfordernDialog(Display.getCurrent().getActiveShell(), gdt6302);
        nuad.setTargetIdSelection(event.getParameter(PARAM_TARGET_ID));
        int retVal = nuad.open();
        if (retVal == 1) {
            return null;
        }
        IGDTCommunicationPartner cp = nuad.getGDTCommunicationPartner();
        GDTOutputHandler.handleOutput(gdt6302, cp, HandlerProgramType.DEFAULT);
        return null;
    }

    private Patient getAsPatient(IStructuredSelection strucSelection) {
        Patient ret = null;
        ret = strucSelection.getFirstElement() instanceof Identifiable ? Patient.load((String)((Identifiable)strucSelection.getFirstElement()).getId()) : (Patient)strucSelection.getFirstElement();
        return ret;
    }
}

