/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.emediplan.core.model.print;

import at.medevit.elexis.emediplan.core.model.print.ContactInfo;
import at.medevit.elexis.emediplan.core.model.print.Medicament;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.prescription.EntryType;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="medication")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Medication {
    @XmlElement(name="date")
    String date;
    @XmlElement(name="patient")
    ContactInfo patientInfo;
    @XmlElement(name="mandant")
    ContactInfo mandantInfo;
    @XmlElementWrapper(name="fix")
    @XmlElement(name="medicament")
    List<Medicament> fixMedication;
    @XmlElementWrapper(name="reserve")
    @XmlElement(name="medicament")
    List<Medicament> reserveMedication;
    @XmlElementWrapper(name="symptomatic")
    @XmlElement(name="medicament")
    List<Medicament> symptomaticMedication;

    public static Medication fromPrescriptions(@NonNull IMandator author, @NonNull IPatient patient, @NonNull List<IPrescription> prescriptions) {
        Medication ret = new Medication();
        ret.date = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm").format(LocalDateTime.now());
        ret.patientInfo = ContactInfo.fromPatient(patient);
        ret.mandantInfo = ContactInfo.fromKontakt((IContact)author);
        for (IPrescription prescription : prescriptions) {
            EntryType type = prescription.getEntryType();
            if (type == EntryType.FIXED_MEDICATION) {
                if (ret.fixMedication == null) {
                    ret.fixMedication = new ArrayList<Medicament>();
                }
                ret.fixMedication.add(Medicament.fromPrescription(prescription));
                continue;
            }
            if (type == EntryType.RESERVE_MEDICATION) {
                if (ret.reserveMedication == null) {
                    ret.reserveMedication = new ArrayList<Medicament>();
                }
                ret.reserveMedication.add(Medicament.fromPrescription(prescription));
                continue;
            }
            if (type != EntryType.SYMPTOMATIC_MEDICATION) continue;
            if (ret.symptomaticMedication == null) {
                ret.symptomaticMedication = new ArrayList<Medicament>();
            }
            ret.symptomaticMedication.add(Medicament.fromPrescription(prescription));
        }
        return ret;
    }
}

