/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.emediplan.core.model.print;

import ch.elexis.core.model.IPrescription;
import ch.elexis.core.services.holder.MedicationServiceHolder;
import ch.elexis.data.Anwender;
import java.time.format.DateTimeFormatter;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="medicament")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Medicament {
    public String name;
    public String dosageText;
    public String dosageMorning;
    public String dosageNoon;
    public String dosageEvening;
    public String dosageNight;
    public String unit;
    public String type;
    public String startDate;
    public String endDate;
    public String remarks;
    public String reason;
    public String prescriptor;

    public static Medicament fromPrescription(IPrescription prescription) {
        boolean isFreetext;
        Medicament ret = new Medicament();
        ret.name = prescription.getArticle().getLabel();
        String[] signature = MedicationServiceHolder.get().getSignatureAsStringArray(prescription.getDosageInstruction());
        boolean bl = isFreetext = !signature[0].isEmpty() && signature[1].isEmpty() && signature[2].isEmpty() && signature[3].isEmpty();
        if (isFreetext) {
            String raw = prescription.getDosageInstruction();
            if (raw == null) {
                raw = signature[0];
            }
            ret.dosageText = raw;
        } else {
            ret.dosageMorning = signature[0];
            ret.dosageNoon = signature[1];
            ret.dosageEvening = signature[2];
            ret.dosageNight = signature[3];
            ret.type = "t\u00e4glich";
        }
        ret.startDate = prescription.getDateFrom() != null ? DateTimeFormatter.ofPattern("dd.MM.yyyy").format(prescription.getDateFrom()) : "";
        ret.endDate = prescription.getDateTo() != null ? DateTimeFormatter.ofPattern("dd.MM.yyyy").format(prescription.getDateTo()) : "";
        ret.remarks = prescription.getRemark();
        ret.reason = prescription.getDisposalComment();
        String prescriptorId = prescription.getPrescriptor() != null ? prescription.getPrescriptor().getId() : "";
        ret.prescriptor = Medicament.getPrescriptorLabel(prescriptorId);
        return ret;
    }

    private static String getPrescriptorLabel(String prescriptorId) {
        Anwender prescriptor;
        if (prescriptorId != null && !prescriptorId.isEmpty() && (prescriptor = Anwender.load((String)prescriptorId)) != null && prescriptor.exists()) {
            String title = prescriptor.get("Titel");
            String firstname = prescriptor.get("Bezeichnung2");
            String lastname = prescriptor.get("Bezeichnung1");
            return String.valueOf(title != null && !title.isEmpty() ? String.valueOf(title) + " " : "") + (firstname != null && !firstname.isEmpty() ? String.valueOf(firstname) + " " : "") + (lastname != null && !lastname.isEmpty() ? String.valueOf(lastname) + " " : "");
        }
        return null;
    }
}

