/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.ehc.ui.views;

import at.medevit.elexis.ehc.ui.Messages;
import at.medevit.elexis.ehc.ui.util.CDALoader;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import com.equo.chromium.swt.Browser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wb.swt.ResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EHealthConnectorView
extends ViewPart {
    public static final String ID = "at.medevit.elexis.eHealthConnectorView";
    private static Logger log = LoggerFactory.getLogger(EHealthConnectorView.class);
    private static Image circle = ResourceManager.getPluginImage("at.medevit.elexis.ehc.ui", "icons/arrow-circle.png");
    private Text txtUrl;
    private Browser browser;
    private CDALoader cdaLoader = new CDALoader();
    private File displayedReport;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setLayout((Layout)new GridLayout(2, false));
        this.txtUrl = new Text(composite, 2048);
        this.txtUrl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtUrl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    EHealthConnectorView.this.displayReport(EHealthConnectorView.this.txtUrl.getText());
                }
            }
        });
        Button btnShow = new Button(composite, 8);
        btnShow.setImage(circle);
        btnShow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EHealthConnectorView.this.displayReport(EHealthConnectorView.this.txtUrl.getText());
            }
        });
        this.browser = new Browser(composite, 0);
        this.browser.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
    }

    public void displayReport(String path) {
        try {
            try {
                FileInputStream inputStream = new FileInputStream(path);
                this.displayReport(inputStream, path);
            }
            catch (FileNotFoundException fne) {
                InputStream inputStream = new URL(path).openStream();
                this.displayReport(inputStream, "");
            }
        }
        catch (IOException e) {
            log.warn("Could not resolve CDA report on path [" + path + "]", (Throwable)e);
            MessageDialog.openError((Shell)UiDesk.getTopShell(), (String)Messages.Dlg_ResolveError, (String)(String.valueOf(Messages.Dlg_ResolveErrorMsg) + "[" + path + "]"));
        }
    }

    public void displayReport(InputStream inputStream, String path) {
        if (path == null) {
            path = "";
        }
        this.displayedReport = this.cdaLoader.buildXmlDocument(inputStream, path);
        this.browser.setUrl(this.displayedReport.getAbsolutePath());
    }

    public InputStream getDisplayedReport() {
        if (this.displayedReport != null && this.displayedReport.exists()) {
            try {
                return new FileInputStream(this.displayedReport);
            }
            catch (FileNotFoundException e) {
                log.error("Could not open displayed report.", (Throwable)e);
            }
        }
        return null;
    }

    public void setFocus() {
        this.txtUrl.setFocus();
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }
}

