/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.corona123.handler;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.types.Gender;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class UrlBuilder {
    public static String getPatientParameters(IPatient patient) {
        String parameters = "";
        try {
            String insurance;
            parameters = String.valueOf(parameters) + "firstName=" + URLEncoder.encode(patient.getFirstName(), "UTF-8");
            parameters = String.valueOf(parameters) + "&lastName=" + URLEncoder.encode(patient.getLastName(), "UTF-8");
            if (patient.getDateOfBirth() != null) {
                parameters = String.valueOf(parameters) + "&dateOfBirth=" + URLEncoder.encode(DateTimeFormatter.ofPattern("yyyy-MM-dd").format(patient.getDateOfBirth()), "UTF-8");
            }
            parameters = String.valueOf(parameters) + "&gender=" + URLEncoder.encode(UrlBuilder.genderAsString(patient.getGender()), "UTF-8");
            if (patient.getCountry() != null) {
                parameters = String.valueOf(parameters) + "&nationality=" + URLEncoder.encode(patient.getCountry().toString(), "UTF-8");
            }
            if (StringUtils.isNotBlank((CharSequence)patient.getStreet())) {
                parameters = String.valueOf(parameters) + "&street=" + URLEncoder.encode(patient.getStreet(), "UTF-8");
            }
            if (StringUtils.isNotBlank((CharSequence)patient.getZip())) {
                parameters = String.valueOf(parameters) + "&postalCode=" + URLEncoder.encode(patient.getZip(), "UTF-8");
            }
            if (StringUtils.isNotBlank((CharSequence)patient.getCity())) {
                parameters = String.valueOf(parameters) + "&city=" + URLEncoder.encode(patient.getCity(), "UTF-8");
            }
            if (StringUtils.isNotBlank((CharSequence)patient.getPhone1())) {
                parameters = String.valueOf(parameters) + "&phone=" + URLEncoder.encode(patient.getPhone1(), "UTF-8");
            } else if (StringUtils.isNotBlank((CharSequence)patient.getPhone2())) {
                parameters = String.valueOf(parameters) + "&phone=" + URLEncoder.encode(patient.getPhone2(), "UTF-8");
            }
            if (StringUtils.isNotBlank((CharSequence)patient.getEmail())) {
                parameters = String.valueOf(parameters) + "&email=" + URLEncoder.encode(patient.getEmail(), "UTF-8");
            }
            if (patient.getFamilyDoctor() != null) {
                IContact familyDoctor = patient.getFamilyDoctor();
                parameters = String.valueOf(parameters) + "&generalPractitioner=" + URLEncoder.encode(UrlBuilder.getContactNameWithTitle(familyDoctor), "UTF-8");
            } else if (ContextServiceHolder.get().getActiveMandator().isPresent()) {
                parameters = String.valueOf(parameters) + "&generalPractitioner=" + URLEncoder.encode(UrlBuilder.getContactNameWithTitle((IContact)ContextServiceHolder.get().getActiveMandator().get()), "UTF-8");
            }
            String insuranceCardNumber = UrlBuilder.getInsuranceCardNumber(patient);
            if (StringUtils.isNotBlank((CharSequence)insuranceCardNumber)) {
                parameters = String.valueOf(parameters) + "&identityNumberInsurance=" + URLEncoder.encode(insuranceCardNumber, "UTF-8");
            }
            if (StringUtils.isNotBlank((CharSequence)(insurance = UrlBuilder.getInsurance(patient)))) {
                parameters = String.valueOf(parameters) + "&healthInsurance=" + URLEncoder.encode(insurance, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            LoggerFactory.getLogger(UrlBuilder.class).error("Error getting patient parameters", (Throwable)e);
        }
        return parameters;
    }

    public static String getVaccinationDefaultParameters() {
        String ret = "";
        try {
            ret = String.valueOf(ret) + "&takesAnticoagulants=" + URLEncoder.encode("false", "UTF-8");
            ret = String.valueOf(ret) + "&hasAllergies=" + URLEncoder.encode("false", "UTF-8");
            ret = String.valueOf(ret) + "&isPregnant=" + URLEncoder.encode("false", "UTF-8");
            ret = String.valueOf(ret) + "&isCurrentlyBreastfeeding=" + URLEncoder.encode("false", "UTF-8");
            ret = String.valueOf(ret) + "&worksAsMedicalStaff=" + URLEncoder.encode("false", "UTF-8");
            ret = String.valueOf(ret) + "&hasContactWithVulnerablePeople=" + URLEncoder.encode("false", "UTF-8");
            ret = String.valueOf(ret) + "&livesInACommunityFacility=" + URLEncoder.encode("false", "UTF-8");
            ret = String.valueOf(ret) + "&wantsVaccinationCertificate=" + URLEncoder.encode("false", "UTF-8");
            ret = String.valueOf(ret) + "&hadCovidInTheLast90Days=" + URLEncoder.encode("false", "UTF-8");
            ret = String.valueOf(ret) + "&hadCovidVaccination=" + URLEncoder.encode("false", "UTF-8");
            ret = String.valueOf(ret) + "&hasCurrentlyColdSymptoms=" + URLEncoder.encode("false", "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LoggerFactory.getLogger(UrlBuilder.class).error("Error getting patient parameters", (Throwable)e);
        }
        return ret;
    }

    private static String getInsurance(IPatient patient) {
        ICoverage coverage2;
        String ret = "";
        Optional activeCoverage = ContextServiceHolder.get().getActiveCoverage();
        if (activeCoverage.isPresent() && (coverage2 = (ICoverage)activeCoverage.get()).isOpen() && coverage2.getCostBearer() != null && coverage2.getCostBearer().isOrganization()) {
            IOrganization costBearer = (IOrganization)CoreModelServiceHolder.get().load(coverage2.getCostBearer().getId(), IOrganization.class).get();
            return String.valueOf(costBearer.getDescription1()) + " " + StringUtils.defaultString((String)costBearer.getDescription2());
        }
        for (ICoverage coverage2 : patient.getCoverages()) {
            if (!coverage2.isOpen() || coverage2.getCostBearer() == null || !coverage2.getCostBearer().isOrganization()) continue;
            IOrganization costBearer = (IOrganization)CoreModelServiceHolder.get().load(coverage2.getCostBearer().getId(), IOrganization.class).get();
            return String.valueOf(costBearer.getDescription1()) + " " + StringUtils.defaultString((String)costBearer.getDescription2());
        }
        return ret;
    }

    private static String getInsuranceCardNumber(IPatient patient) {
        ICoverage coverage2;
        String ret = "";
        Optional activeCoverage = ContextServiceHolder.get().getActiveCoverage();
        if (activeCoverage.isPresent() && (coverage2 = (ICoverage)activeCoverage.get()).isOpen()) {
            if (StringUtils.isNotBlank((CharSequence)((String)coverage2.getExtInfo((Object)"VEKANr")))) {
                return (String)coverage2.getExtInfo((Object)"VEKANr");
            }
            if (StringUtils.isNotBlank((CharSequence)((String)coverage2.getExtInfo((Object)"Versicherten-Nummer")))) {
                return (String)coverage2.getExtInfo((Object)"Versicherten-Nummer");
            }
            if (StringUtils.isNotBlank((CharSequence)((String)coverage2.getExtInfo((Object)"Versicherungsnummer")))) {
                return (String)coverage2.getExtInfo((Object)"Versicherungsnummer");
            }
        }
        for (ICoverage coverage2 : patient.getCoverages()) {
            if (!coverage2.isOpen()) continue;
            if (StringUtils.isNotBlank((CharSequence)((String)coverage2.getExtInfo((Object)"VEKANr")))) {
                return (String)coverage2.getExtInfo((Object)"VEKANr");
            }
            if (StringUtils.isNotBlank((CharSequence)((String)coverage2.getExtInfo((Object)"Versicherten-Nummer")))) {
                return (String)coverage2.getExtInfo((Object)"Versicherten-Nummer");
            }
            if (!StringUtils.isNotBlank((CharSequence)((String)coverage2.getExtInfo((Object)"Versicherungsnummer")))) continue;
            return (String)coverage2.getExtInfo((Object)"Versicherungsnummer");
        }
        return ret;
    }

    private static String getContactNameWithTitle(IContact contact) {
        if (contact.isPerson()) {
            IPerson person = (IPerson)CoreModelServiceHolder.get().load(contact.getId(), IPerson.class).get();
            return String.valueOf(StringUtils.defaultString((String)person.getTitel())) + " " + StringUtils.defaultString((String)person.getFirstName()) + " " + StringUtils.defaultString((String)person.getLastName()) + ", " + StringUtils.defaultString((String)person.getCity());
        }
        return contact.getDescription1();
    }

    private static String genderAsString(Gender gender) {
        switch (gender) {
            case FEMALE: {
                return "FEMALE";
            }
            case MALE: {
                return "MALE";
            }
        }
        return "OTHER";
    }

    public static String getVaccinationBaseUrl() {
        return "https://corona123.ch/corona-vaccine-form-prefill/" + UrlBuilder.getOrgId();
    }

    public static String getTestBaseUrl() {
        return "https://corona123.ch/corona-test-form-prefill/" + UrlBuilder.getOrgId();
    }

    private static String getOrgId() {
        return ConfigServiceHolder.get().get("corona123/orgid", "");
    }

    public static boolean isOrgId() {
        return StringUtils.isNotBlank((CharSequence)UrlBuilder.getOrgId());
    }
}

