/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.corona123.handler;

import at.medevit.elexis.corona123.handler.UrlBuilder;
import ch.elexis.core.model.IPatient;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.LoggerFactory;

public class OpenPatientTestHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof IPatient) {
            IPatient patient = (IPatient)selection.getFirstElement();
            this.openPatientTest(patient);
        }
        return null;
    }

    private void openPatientTest(IPatient patient) {
        if (UrlBuilder.isOrgId()) {
            String baseUrl = UrlBuilder.getTestBaseUrl();
            String patientParameters = UrlBuilder.getPatientParameters(patient);
            try {
                String testDateParameter = "testDate=" + URLEncoder.encode(DateTimeFormatter.ofPattern("yyyy-MM-dd").format(LocalDate.now()), "UTF-8");
                Program.launch((String)(String.valueOf(baseUrl) + "?" + testDateParameter + "&" + patientParameters));
            }
            catch (UnsupportedEncodingException e) {
                LoggerFactory.getLogger(UrlBuilder.class).error("Error getting testDate parameter", (Throwable)e);
            }
        } else {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Es ist keine corona123 Organisations ID konfiguriert.");
        }
    }
}

