/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.rcprap;

import com.equo.chromium.swt.Browser;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleSourceUtil {
    private static Logger log = LoggerFactory.getLogger(SingleSourceUtil.class);
    private static final boolean IS_RAP;
    private static final String HTML_BASE_URL;

    static {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.eclipse.rap.rwt.RWT");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        boolean bl = IS_RAP = clazz != null;
        if (IS_RAP) {
            String baseUrl = System.getenv("BASE_URL");
            if (baseUrl == null) {
                baseUrl = "";
            }
            HTML_BASE_URL = String.valueOf(baseUrl) + "/agenda/static/html/";
        } else {
            String _baseUrl = null;
            try {
                URL url = FileLocator.toFileURL((URL)FrameworkUtil.getBundle(SingleSourceUtil.class).getResource("/rsc/html/"));
                _baseUrl = url.toString();
            }
            catch (IOException e) {
                log.error("Initialization error", (Throwable)e);
            }
            HTML_BASE_URL = _baseUrl;
        }
    }

    public static boolean isRap() {
        return IS_RAP;
    }

    public static String resolve(String html) {
        return String.valueOf(HTML_BASE_URL) + html;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeScript(Browser browser, String script) {
        log.debug("script [{}]: {}", (Object)script.hashCode(), (Object)script);
        if (!browser.isDisposed()) {
            if (IS_RAP) {
                Class<BrowserLock> clazz = BrowserLock.class;
                synchronized (BrowserLock.class) {
                    try {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return browser.execute(script);
                    }
                    catch (IllegalStateException ise) {
                        log.warn("Catched IllegalStateException in script [{}]", (Object)script);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                    }
                }
            } else {
                return browser.execute(script);
            }
        }
        return false;
    }

    private class BrowserLock {
        private BrowserLock() {
        }
    }
}

