/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.menu;

import ch.elexis.core.model.IAppointment;
import ch.elexis.core.services.holder.AppointmentServiceHolder;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.slf4j.LoggerFactory;

public class SetStatusContributionItem {
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private ESelectionService eSelectionService;

    @AboutToShow
    public void fill(List<MMenuElement> items) {
        IStructuredSelection selection = (IStructuredSelection)this.eSelectionService.getSelection();
        IAppointment selectedAppointment = selection != null ? (IAppointment)selection.getFirstElement() : null;
        String state = selectedAppointment != null ? selectedAppointment.getState() : null;
        for (String t : AppointmentServiceHolder.get().getStates()) {
            MDirectMenuItem dynamicItem = MMenuFactory.INSTANCE.createDirectMenuItem();
            dynamicItem.setType(ItemType.CHECK);
            dynamicItem.setLabel(t);
            dynamicItem.setContributionURI("bundleclass://at.medevit.elexis.agenda.ui/" + this.getClass().getName());
            dynamicItem.setSelected(t.equalsIgnoreCase(state));
            items.add((MMenuElement)dynamicItem);
        }
    }

    @Execute
    private void setStatus(MDirectMenuItem menuItem) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("at.medevit.elexis.agenda.ui.command.parameter.statusId", menuItem.getLabel());
        ParameterizedCommand command = this.commandService.createCommand("at.medevit.elexis.agenda.ui.command.setStatus", parameters);
        if (command != null) {
            this.handlerService.executeHandler(command);
        } else {
            LoggerFactory.getLogger(this.getClass()).error("Command not found");
        }
    }
}

