/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.handler;

import at.medevit.elexis.agenda.ui.dialog.HistoryDialog;
import at.medevit.elexis.agenda.ui.rcprap.StateHistoryFormatterUtil;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IPeriod;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.ui.e4.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.e4.locks.ILockHandler;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.LoggerFactory;

public class ShowHistoryHandler {
    @Inject
    private ESelectionService selectionService;

    @Execute
    public Object execute() {
        Optional<IPeriod> period = this.getSelectedPeriod();
        period.ifPresent(p -> AcquireLockBlockingUi.aquireAndRun((Identifiable)p, (ILockHandler)new ILockHandler((IPeriod)p){
            private final /* synthetic */ IPeriod val$p;
            {
                this.val$p = iPeriod;
            }

            public void lockFailed() {
            }

            public void lockAcquired() {
                IAppointment appointment = (IAppointment)this.val$p;
                String stateHistory = appointment.getStateHistoryFormatted("dd.MM.yyyy HH:mm:ss").replaceAll("\n", "<br />");
                stateHistory = StateHistoryFormatterUtil.replaceIdsWithLabels(stateHistory);
                String formattedStateHistory = StateHistoryFormatterUtil.formatStateHistoryFull(stateHistory);
                String description = String.valueOf(appointment.getReason().replaceAll("\n", "<br />")) + "<br /><br />" + formattedStateHistory;
                HistoryDialog historyDialog = new HistoryDialog(new Shell(), description, appointment);
                historyDialog.open();
            }
        }));
        return null;
    }

    private Optional<IPeriod> getSelectedPeriod() {
        try {
            Object element;
            ISelection activeSelection = (ISelection)this.selectionService.getSelection();
            if (activeSelection instanceof StructuredSelection && !((StructuredSelection)activeSelection).isEmpty() && (element = ((StructuredSelection)activeSelection).getFirstElement()) instanceof IPeriod) {
                return Optional.of((IPeriod)element);
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Fehler beim Abrufen des ausgew\u00e4hlten Termins", (Throwable)e);
        }
        return Optional.empty();
    }
}

