/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.handler;

import at.medevit.elexis.agenda.ui.composite.SideBarComposite;
import at.medevit.elexis.agenda.ui.handler.CopyHandler;
import at.medevit.elexis.agenda.ui.view.AgendaView;
import ch.elexis.core.model.IPeriod;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.slf4j.LoggerFactory;

public class MoveHandler {
    @Inject
    private ESelectionService selectionService;

    @Execute
    public Object execute(MPart part) {
        Optional<IPeriod> period = this.getSelectedPeriod();
        period.ifPresent(p -> {
            SideBarComposite sideBar = null;
            if (part.getObject() instanceof AgendaView) {
                AgendaView view = (AgendaView)part.getObject();
                sideBar = view.getParallelSideBarComposite();
            }
            if (sideBar != null) {
                CopyHandler.clearCopiedAppointment();
                sideBar.addMovePeriod((IPeriod)p);
            }
        });
        return null;
    }

    private Optional<IPeriod> getSelectedPeriod() {
        try {
            Object element;
            ISelection activeSelection = (ISelection)this.selectionService.getSelection();
            if (activeSelection instanceof StructuredSelection && !((StructuredSelection)activeSelection).isEmpty() && (element = ((StructuredSelection)activeSelection).getFirstElement()) instanceof IPeriod) {
                return Optional.of((IPeriod)element);
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Error setting status", (Throwable)e);
        }
        return Optional.empty();
    }
}

