/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.handler;

import at.medevit.elexis.agenda.ui.composite.SideBarComposite;
import at.medevit.elexis.agenda.ui.view.AgendaView;
import ch.elexis.core.model.IAppointment;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.slf4j.LoggerFactory;

public class CopyHandler {
    @Inject
    private ESelectionService selectionService;
    private static Optional<IAppointment> copyAppontment = Optional.empty();

    @Execute
    public Object execute(MPart part) {
        Optional<IAppointment> appointment = this.getSelectedAppointment();
        appointment.ifPresent(appt -> {
            SideBarComposite sideBar = null;
            if (part.getObject() instanceof AgendaView) {
                AgendaView view = (AgendaView)part.getObject();
                sideBar = view.getParallelSideBarComposite();
            }
            if (sideBar != null) {
                sideBar.addcopyAppointment((IAppointment)appt);
            }
            copyAppontment = Optional.of(appt);
        });
        return null;
    }

    private Optional<IAppointment> getSelectedAppointment() {
        try {
            Object element;
            ISelection activeSelection = (ISelection)this.selectionService.getSelection();
            if (activeSelection instanceof StructuredSelection && !((StructuredSelection)activeSelection).isEmpty() && (element = ((StructuredSelection)activeSelection).getFirstElement()) instanceof IAppointment) {
                return Optional.of((IAppointment)element);
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Error copying appointment", (Throwable)e);
        }
        return Optional.empty();
    }

    public static Optional<IAppointment> getCopiedAppointment() {
        return copyAppontment;
    }

    public static void clearCopiedAppointment() {
        copyAppontment = Optional.empty();
    }
}

