/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.function;

import at.medevit.elexis.agenda.ui.function.Messages;
import com.equo.chromium.swt.Browser;
import com.equo.chromium.swt.BrowserFunction;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import javax.inject.Inject;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenshotFunction
extends BrowserFunction {
    private static final Logger logger = LoggerFactory.getLogger(ScreenshotFunction.class);

    @Inject
    public ScreenshotFunction(Browser browser, String name) {
        super(browser, name);
    }

    public Object function(Object[] arguments) {
        if (arguments.length > 0 && arguments[0] instanceof String) {
            String base64Image = (String)arguments[0];
            this.showPreviewAndPrint(base64Image);
        }
        return null;
    }

    private void showPreviewAndPrint(String base64Image) {
        Display.getDefault().asyncExec(() -> {
            try {
                String base64Data = base64Image.split(",")[1];
                byte[] imageBytes = Base64.getDecoder().decode(base64Data);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(imageBytes);
                ImageData imageData = new ImageData((InputStream)inputStream);
                Image image = new Image((Device)Display.getDefault(), imageData);
                Shell previewShell = new Shell(Display.getDefault());
                previewShell.setText(Messages.ScreenshotFunction_PreviewShell_Text);
                previewShell.setLayout((Layout)new GridLayout(1, false));
                Canvas canvas = new Canvas((Composite)previewShell, 2048);
                canvas.setLayoutData((Object)new GridData(4, 4, true, true));
                canvas.addPaintListener(e -> {
                    int canvasWidth = canvas.getSize().x;
                    int canvasHeight = canvas.getSize().y;
                    float aspectRatio = (float)imageData.width / (float)imageData.height;
                    int scaledWidth = canvasWidth;
                    int scaledHeight = (int)((float)canvasWidth / aspectRatio);
                    if (scaledHeight > canvasHeight) {
                        scaledHeight = canvasHeight;
                        scaledWidth = (int)((float)canvasHeight * aspectRatio);
                    }
                    int xOffset = (canvasWidth - scaledWidth) / 2;
                    int yOffset = (canvasHeight - scaledHeight) / 2;
                    e.gc.drawImage(image, 0, 0, imageData.width, imageData.height, xOffset, yOffset, scaledWidth, scaledHeight);
                });
                Button printButton = new Button((Composite)previewShell, 8);
                printButton.setText(Messages.PrintChartAction_printTitle);
                printButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
                printButton.addListener(13, event -> {
                    previewShell.close();
                    this.openPrintDialog(imageData, image);
                });
                previewShell.setSize(800, 600);
                previewShell.open();
                Display display = Display.getDefault();
                while (!previewShell.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                image.dispose();
            }
            catch (Exception e2) {
                logger.error("An error occurred while processing the screenshot:", (Throwable)e2);
            }
        });
    }

    private void openPrintDialog(ImageData imageData, Image image) {
        Shell shell = Display.getDefault().getActiveShell();
        PrintDialog printDialog = new PrintDialog(shell, 0);
        PrinterData printerData = printDialog.open();
        if (printerData != null) {
            Printer printer = new Printer(printerData);
            if (printer.startJob(Messages.ScreenshotFunction_PrintJob_Title)) {
                GC gc = new GC((Drawable)printer);
                printer.startPage();
                int pageWidth = printer.getClientArea().width;
                int pageHeight = printer.getClientArea().height;
                float aspectRatio = (float)imageData.width / (float)imageData.height;
                int scaledWidth = pageWidth;
                int scaledHeight = (int)((float)pageWidth / aspectRatio);
                if (scaledHeight > pageHeight) {
                    scaledHeight = pageHeight;
                    scaledWidth = (int)((float)pageHeight * aspectRatio);
                }
                int xOffset = (pageWidth - scaledWidth) / 2;
                int yOffset = (pageHeight - scaledHeight) / 2;
                gc.drawImage(image, 0, 0, imageData.width, imageData.height, xOffset, yOffset, scaledWidth, scaledHeight);
                gc.dispose();
                printer.endPage();
                printer.endJob();
            }
            printer.dispose();
        }
    }
}

