/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.function;

import at.medevit.elexis.agenda.ui.composite.ScriptingHelper;
import at.medevit.elexis.agenda.ui.function.AbstractBrowserFunction;
import at.medevit.elexis.agenda.ui.function.CheckForUpdatesTimerTask;
import at.medevit.elexis.agenda.ui.function.LoadEventTimeSpan;
import at.medevit.elexis.agenda.ui.model.Event;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPeriod;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.AppointmentServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import com.equo.chromium.swt.Browser;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.time.LocalDate;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadEventsFunction
extends AbstractBrowserFunction {
    private static Logger logger = LoggerFactory.getLogger(LoadEventsFunction.class);
    private Gson gson;
    private Set<String> resources = new LinkedHashSet<String>();
    protected ScriptingHelper scriptingHelper;
    private LoadingCache<TimeSpan, EventsJsonValue> cache;
    protected long knownLastUpdate = 0L;
    private TimeSpan currentTimeSpan;
    private Timer timer;

    public LoadEventsFunction(Browser browser, String name, ScriptingHelper scriptingHelper, UISynchronize uiSynchronize) {
        super(browser, name);
        this.gson = new GsonBuilder().create();
        this.scriptingHelper = scriptingHelper;
        this.cache = CacheBuilder.newBuilder().maximumSize(7L).build((CacheLoader)new TimeSpanLoader());
        this.timer = new Timer("Agenda check for updates", true);
        this.timer.schedule((TimerTask)new CheckForUpdatesTimerTask(this, uiSynchronize), 10000L, 10000L);
    }

    public Object function(Object[] arguments) {
        if (arguments.length == 3) {
            try {
                IContact userContact = ContextServiceHolder.get().getActiveUser().map(IUser::getAssignedContact).orElse(null);
                this.currentTimeSpan = new TimeSpan(this.getDateArg(arguments[0]), this.getDateArg(arguments[1]), userContact);
                ContextServiceHolder.get().postEvent("info/elexis/agenda/loadtimespan", (Object)new LoadEventTimeSpan(this.currentTimeSpan.startDate, this.currentTimeSpan.endDate));
                long currentLastUpdate = CoreModelServiceHolder.get().getHighestLastUpdate(IAppointment.class);
                if (this.knownLastUpdate == 0L) {
                    this.updateKnownLastUpdate(currentLastUpdate);
                } else if (this.knownLastUpdate < currentLastUpdate) {
                    List<IPeriod> changedPeriods = this.getChangedPeriods();
                    ConcurrentMap cacheAsMap = this.cache.asMap();
                    for (TimeSpan timeSpan : cacheAsMap.keySet()) {
                        EventsJsonValue eventsJson = (EventsJsonValue)this.cache.get((Object)timeSpan);
                        if (eventsJson.updateWith(changedPeriods, userContact)) {
                            logger.debug("Updated timespan " + timeSpan);
                            continue;
                        }
                        logger.debug("No updated to timespan " + timeSpan);
                    }
                    this.updateKnownLastUpdate(currentLastUpdate);
                }
                EventsJsonValue eventsJson = (EventsJsonValue)this.cache.get((Object)this.currentTimeSpan);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!LoadEventsFunction.this.isDisposed()) {
                            LoadEventsFunction.this.updateCalendarHeight();
                            LoadEventsFunction.this.scriptingHelper.scrollToNow();
                        }
                    }
                });
                return eventsJson.getJson();
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("Error loading events", e);
            }
        }
        throw new IllegalArgumentException("Unexpected arguments");
    }

    private void updateKnownLastUpdate(long currentLastUpdate) {
        if (currentLastUpdate - System.currentTimeMillis() > 10000L) {
            logger.warn("Appointment highest lastupdate is in future [" + (currentLastUpdate - System.currentTimeMillis()) + "]");
            this.knownLastUpdate = System.currentTimeMillis();
            this.cache.invalidate((Object)this.currentTimeSpan);
        } else {
            this.knownLastUpdate = currentLastUpdate;
        }
    }

    private List<IPeriod> getChangedPeriods() {
        IQuery query = CoreModelServiceHolder.get().getQuery(IAppointment.class, true, true);
        query.and("lastupdate", IQuery.COMPARATOR.GREATER, (Object)this.knownLastUpdate);
        if (!this.resources.isEmpty()) {
            String[] resourceArray = this.resources.toArray(new String[this.resources.size()]);
            query.startGroup();
            int i = 0;
            while (i < resourceArray.length) {
                query.or((EStructuralFeature)ModelPackage.Literals.IAPPOINTMENT__SCHEDULE, IQuery.COMPARATOR.EQUALS, (Object)resourceArray[i]);
                ++i;
            }
            query.andJoinGroups();
        }
        return query.execute();
    }

    public void addResource(String resource) {
        this.resources.add(resource);
    }

    public void removeResource(String resource) {
        this.resources.remove(resource);
    }

    public void setResources(List<String> resources) {
        this.resources.clear();
        this.resources.addAll(resources);
        this.cache.invalidateAll();
    }

    public List<IPeriod> getCurrentPeriods() {
        TimeSpanLoader loader = new TimeSpanLoader();
        return loader.getPeriods(this.currentTimeSpan);
    }

    public void invalidateCache() {
        this.cache.invalidateAll();
    }

    public void dispose() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        super.dispose();
    }

    public void dispose(boolean remove) {
        if (this.timer != null) {
            this.timer.cancel();
        }
        super.dispose(remove);
    }

    public Set<String> getResources() {
        return this.resources;
    }

    private class EventsJsonValue {
        private Map<String, Event> eventsMap;
        private String jsonString;
        private TimeSpan timespan;

        public EventsJsonValue(TimeSpan key, List<Event> events) {
            this.timespan = key;
            this.eventsMap = events.parallelStream().collect(Collectors.toMap(e -> e.getId(), e -> e));
            this.jsonString = LoadEventsFunction.this.gson.toJson(this.eventsMap.values());
        }

        public String getJson() {
            return this.jsonString;
        }

        public boolean updateWith(List<IPeriod> changedPeriods, IContact userContact) {
            boolean updated = false;
            for (IPeriod iPeriod : changedPeriods) {
                if (this.eventsMap.containsKey(iPeriod.getId())) {
                    boolean deleted = ((IAppointment)iPeriod).isDeleted();
                    if (deleted || !this.timespan.contains(iPeriod)) {
                        this.eventsMap.remove(iPeriod.getId());
                    } else {
                        Event event = Event.of(iPeriod, userContact);
                        this.eventsMap.put(event.getId(), event);
                    }
                    updated = true;
                    continue;
                }
                if (!this.timespan.contains(iPeriod)) continue;
                if (iPeriod.isDeleted()) {
                    this.eventsMap.remove(iPeriod.getId());
                } else {
                    Event event = Event.of(iPeriod, userContact);
                    this.eventsMap.put(event.getId(), event);
                }
                updated = true;
            }
            if (updated) {
                this.jsonString = LoadEventsFunction.this.gson.toJson(this.eventsMap.values());
            }
            return updated;
        }
    }

    private class TimeSpan {
        private LocalDate startDate;
        private LocalDate endDate;
        private IContact userContact;

        public TimeSpan(LocalDate startDate, LocalDate endDate, IContact userContact) {
            this.startDate = startDate;
            this.endDate = endDate;
            this.userContact = userContact;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + ((Object)((Object)this.getOuterType())).hashCode();
            result = 31 * result + (this.endDate == null ? 0 : this.endDate.hashCode());
            result = 31 * result + (this.startDate == null ? 0 : this.startDate.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TimeSpan other = (TimeSpan)obj;
            if (!((Object)((Object)this.getOuterType())).equals((Object)other.getOuterType())) {
                return false;
            }
            if (this.endDate == null ? other.endDate != null : !this.endDate.equals(other.endDate)) {
                return false;
            }
            return !(this.startDate == null ? other.startDate != null : !this.startDate.equals(other.startDate));
        }

        private LoadEventsFunction getOuterType() {
            return LoadEventsFunction.this;
        }

        public boolean contains(IPeriod iPeriod) {
            LocalDate periodStartDate = iPeriod.getStartTime().toLocalDate();
            return !(!periodStartDate.isEqual(this.startDate) && !periodStartDate.isAfter(this.startDate) || !periodStartDate.isEqual(this.endDate) && !periodStartDate.isBefore(this.endDate));
        }

        public String toString() {
            return "Timespan [" + this.startDate + " - " + this.endDate + "]";
        }

        static /* synthetic */ IContact access$0(TimeSpan timeSpan) {
            return timeSpan.userContact;
        }
    }

    private class TimeSpanLoader
    extends CacheLoader<TimeSpan, EventsJsonValue> {
        private TimeSpanLoader() {
        }

        public EventsJsonValue load(TimeSpan key) {
            try {
                List<IPeriod> periods = this.getPeriods(key);
                return new EventsJsonValue(key, periods.parallelStream().map(p -> Event.of(p, timeSpan.userContact)).collect(Collectors.toList()));
            }
            catch (Exception e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error loading json events", (Throwable)e);
                return new EventsJsonValue(key, Collections.emptyList());
            }
        }

        private List<IPeriod> getPeriods(TimeSpan timespan) throws IllegalStateException {
            logger.debug("Loading timespan " + timespan);
            LocalDate from = timespan.startDate;
            LocalDate to = timespan.endDate;
            for (String resource : LoadEventsFunction.this.resources) {
                LocalDate updateDate = LocalDate.from(from);
                do {
                    AppointmentServiceHolder.get().assertBlockTimes(updateDate, resource);
                } while ((updateDate = updateDate.plusDays(1L)).isBefore(to) || updateDate.isEqual(to));
            }
            IQuery query = CoreModelServiceHolder.get().getQuery(IAppointment.class);
            if (!LoadEventsFunction.this.resources.isEmpty()) {
                String[] resourceArray = LoadEventsFunction.this.resources.toArray(new String[LoadEventsFunction.this.resources.size()]);
                query.startGroup();
                int i = 0;
                while (i < resourceArray.length) {
                    query.or((EStructuralFeature)ModelPackage.Literals.IAPPOINTMENT__SCHEDULE, IQuery.COMPARATOR.EQUALS, (Object)resourceArray[i]);
                    ++i;
                }
                query.andJoinGroups();
                query.startGroup();
                if (from != null) {
                    query.and("tag", IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)from);
                }
                if (to != null) {
                    query.and("tag", IQuery.COMPARATOR.LESS, (Object)to);
                }
                query.andJoinGroups();
                return query.execute();
            }
            logger.debug("Loading timespan " + timespan + " finished");
            return Collections.emptyList();
        }
    }
}

