/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.composite;

import at.medevit.elexis.agenda.ui.composite.IAgendaComposite;
import at.medevit.elexis.agenda.ui.rcprap.SingleSourceUtil;
import com.equo.chromium.swt.Browser;
import java.time.LocalDate;

public class ScriptingHelper {
    private Browser browser;
    private volatile boolean doScroll;

    public ScriptingHelper(Browser browser) {
        this.browser = browser;
    }

    public void setSelectedSpanSize(IAgendaComposite.AgendaSpanSize size) {
        String slotDuration = "$('#calendar').fullCalendar('option', 'slotDuration', '%s');";
        String script = String.format(slotDuration, size.getCalendarString());
        SingleSourceUtil.executeScript(this.browser, script);
        this.scrollToNow();
    }

    private String parseTime(String time) {
        if (time.length() < 6 || time.lastIndexOf(":") != 5) {
            StringBuilder builder = new StringBuilder(6);
            time = time.replaceAll(":", "");
            int length = time.length();
            int i = 0;
            while (i < 6) {
                if (i > 0 && i % 2 == 0) {
                    builder.append(":");
                }
                if (i < length) {
                    char c = time.charAt(i);
                    builder.append(c);
                } else {
                    builder.append("0");
                }
                ++i;
            }
            return builder.toString();
        }
        return time;
    }

    public void setCalenderTime(String dayStartsAt, String dayEndsAt) {
        String endsAt = "$('#calendar').fullCalendar('option', 'maxTime', '%s');";
        String startAt = "$('#calendar').fullCalendar('option', 'minTime', '%s');";
        String script = String.valueOf(String.format(endsAt, this.parseTime(dayEndsAt))) + String.format(startAt, this.parseTime(dayStartsAt));
        SingleSourceUtil.executeScript(this.browser, script);
        this.scrollToNow();
    }

    public void setSelectedDate(LocalDate date) {
        String gotoDate = "$('#calendar').fullCalendar('gotoDate', '%s');";
        String script = String.format(gotoDate, date.toString());
        SingleSourceUtil.executeScript(this.browser, script);
    }

    public void setFontSize(int sizePx) {
        String bodyFontSize = "$('body').css('font-size', '%dpx');";
        String script = String.format(bodyFontSize, sizePx);
        SingleSourceUtil.executeScript(this.browser, script);
    }

    public void setFontFamily(String family) {
        String bodyFontFamily = "$('body').css('font-family', '%s');";
        String script = String.format(bodyFontFamily, family);
        SingleSourceUtil.executeScript(this.browser, script);
    }

    public void render() {
        String refetchEvents = "$('#calendar').fullCalendar('render');";
        SingleSourceUtil.executeScript(this.browser, refetchEvents);
    }

    public void refetchEvents() {
        String refetchEvents = "$('#calendar').fullCalendar('refetchEvents');";
        SingleSourceUtil.executeScript(this.browser, refetchEvents);
    }

    public void refetchResources() {
        String refetchResources = "$('#calendar').fullCalendar('refetchResources');";
        SingleSourceUtil.executeScript(this.browser, refetchResources);
    }

    public void scrollToNow() {
        if (this.doScroll) {
            String script = "var now = $('#calendar').fullCalendar('getNow'); if (now >= $('#calendar').fullCalendar('getView').intervalStart && now < $('#calendar').fullCalendar('getView').intervalEnd){ setTimeout( function(){$('.fc-scroller').scrollTop($('.fc-now-indicator').position().top - ($('#calendar').height() / 2) );}  , 500 );}";
            SingleSourceUtil.executeScript(this.browser, script);
        }
    }

    public void setScrollToNow(boolean value) {
        this.doScroll = value;
        this.scrollToNow();
    }

    public void setShowWeekends(boolean value) {
        String script = "$('#calendar').fullCalendar('option', 'weekends', %s)";
        script = String.format(script, value);
        SingleSourceUtil.executeScript(this.browser, script);
    }
}

