/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.composite;

import at.medevit.elexis.agenda.ui.composite.IAgendaComposite;
import at.medevit.elexis.agenda.ui.composite.ScriptingHelper;
import at.medevit.elexis.agenda.ui.function.ContextMenuFunction;
import at.medevit.elexis.agenda.ui.function.DayClickFunction;
import at.medevit.elexis.agenda.ui.function.DoubleClickFunction;
import at.medevit.elexis.agenda.ui.function.EventDropFunction;
import at.medevit.elexis.agenda.ui.function.EventResizeFunction;
import at.medevit.elexis.agenda.ui.function.LoadContactInfoFunction;
import at.medevit.elexis.agenda.ui.function.LoadEventsFunction;
import at.medevit.elexis.agenda.ui.function.LoadResourcesFunction;
import at.medevit.elexis.agenda.ui.function.PdfFunction;
import at.medevit.elexis.agenda.ui.function.ScreenshotFunction;
import at.medevit.elexis.agenda.ui.function.SingleClickFunction;
import at.medevit.elexis.agenda.ui.function.SwitchFunction;
import at.medevit.elexis.agenda.ui.rcprap.SingleSourceUtil;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import com.equo.chromium.swt.Browser;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelComposite
extends Composite
implements ISelectionProvider,
IAgendaComposite {
    private List<String> selectedResources = Collections.synchronizedList(new ArrayList());
    private static Logger logger = LoggerFactory.getLogger(ParallelComposite.class);
    private Browser browser;
    private LoadEventsFunction loadEventsFunction;
    private ScriptingHelper scriptingHelper;
    private ISelection currentSelection;
    private ListenerList<ISelectionChangedListener> listeners = new ListenerList();
    private IAgendaComposite.AgendaSpanSize currentSpanSize;
    private DayClickFunction dayClickFunction;
    private ESelectionService selectionService;

    @Inject
    void user(@Optional IUser user) {
        if (this.loadEventsFunction != null) {
            this.loadEventsFunction.invalidateCache();
        }
    }

    @Optional
    @Inject
    void invalidateCache(@EventTopic(value="info/elexis/model/invalidatecache") Class<?> clazz) {
        if (clazz == IAppointment.class && this.loadEventsFunction != null) {
            this.loadEventsFunction.invalidateCache();
        }
    }

    public ParallelComposite(MPart part, ESelectionService selectionService, EMenuService menuService, Composite parent, int style, UISynchronize uiSynchronize) {
        this(part, selectionService, menuService, parent, style, false, uiSynchronize);
    }

    public ParallelComposite(MPart part, ESelectionService selectionService, EMenuService menuService, Composite parent, int style, boolean enableSwitch, final UISynchronize uiSynchronize) {
        super(parent, style);
        this.selectionService = selectionService;
        this.setLayout((Layout)new FillLayout());
        this.browser = new Browser((Composite)this, 0);
        this.scriptingHelper = new ScriptingHelper(this.browser);
        this.loadEventsFunction = new LoadEventsFunction(this.browser, "loadEventsFunction", this.scriptingHelper, uiSynchronize);
        new LoadResourcesFunction(this.browser, "loadResourcesFunction", this);
        new LoadContactInfoFunction(this.browser, "loadContactInfoFunction");
        new SingleClickFunction(this.browser, "singleClickFunction").setSelectionProvider(this);
        new DoubleClickFunction(this.browser, "doubleClickFunction");
        new ContextMenuFunction(part, this.browser, "contextMenuFunction").setSelectionProvider(this);
        new EventDropFunction(this.browser, "eventDropFunction");
        new EventResizeFunction(this.browser, "eventResizeFunction");
        new PdfFunction(part, this.browser, "pdfFunction");
        new ScreenshotFunction(this.browser, "screenshotFunction");
        this.dayClickFunction = new DayClickFunction(this.browser, "dayClickFunction");
        if (enableSwitch) {
            new SwitchFunction(part, this.browser, "switchFunction");
            String targetUrl = SingleSourceUtil.resolve("switchParallel.html");
            logger.debug(String.format("Open url [%s]", targetUrl));
            this.browser.setUrl(targetUrl);
        } else {
            String targetUrl = SingleSourceUtil.resolve("defaultParallel.html");
            logger.debug(String.format("Open url [%s]", targetUrl));
            this.browser.setUrl(targetUrl);
        }
        this.browser.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ParallelComposite.this.loadEventsFunction.updateCalendarHeight();
            }
        });
        menuService.registerContextMenu((Object)this.browser, "at.medevit.elexis.agenda.ui.popupmenu.parallel");
        this.browser.addProgressListener((ProgressListener)new ProgressAdapter(){

            public void completed(ProgressEvent event) {
                String dayStartsAt = ConfigServiceHolder.get().get("agenda/beginnStundeTagesdarstellung", "0000", false);
                String dayEndsAt = ConfigServiceHolder.get().get("agenda/endStundeTagesdarstellung", "2359", false);
                ParallelComposite.this.loadEventsFunction.setResources(ParallelComposite.this.selectedResources);
                ParallelComposite.this.dayClickFunction.setSelectedResources(ParallelComposite.this.selectedResources);
                uiSynchronize.asyncExec(() -> {
                    ParallelComposite.this.scriptingHelper.setCalenderTime(dayStartsAt, dayEndsAt);
                    if (ParallelComposite.this.currentSpanSize != null) {
                        ParallelComposite.this.setSelectedSpanSize(ParallelComposite.this.currentSpanSize);
                    }
                    ParallelComposite.this.getConfiguredFontSize().ifPresent(size -> {
                        ParallelComposite.this.setFontSize((int)size);
                        ParallelComposite.this.getConfiguredFontFamily().ifPresent(family -> ParallelComposite.this.setFontFamily((String)family));
                    });
                });
            }
        });
    }

    @Override
    public void refetchEvents() {
        this.scriptingHelper.refetchEvents();
    }

    @Override
    public void setSelectedDate(LocalDate date) {
        this.scriptingHelper.setSelectedDate(date);
    }

    @Override
    public void setFontSize(int sizePx) {
        this.scriptingHelper.setFontSize(sizePx);
    }

    @Override
    public void setFontFamily(String family) {
        this.scriptingHelper.setFontFamily(family);
    }

    @Override
    public void setSelectedSpanSize(IAgendaComposite.AgendaSpanSize size) {
        this.currentSpanSize = size;
        this.scriptingHelper.setSelectedSpanSize(size);
    }

    @Override
    public void setSelectedResources(List<String> selectedResources) {
        this.selectedResources.clear();
        this.selectedResources.addAll(selectedResources);
        this.loadEventsFunction.setResources(selectedResources);
        this.dayClickFunction.setSelectedResources(selectedResources);
        this.scriptingHelper.refetchResources();
        this.scriptingHelper.refetchEvents();
    }

    @Override
    public Set<String> getSelectedResources() {
        return new LinkedHashSet<String>(this.selectedResources);
    }

    @Override
    public String getConfigId() {
        return "parallel";
    }

    public boolean setFocus() {
        return this.browser.setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add((Object)listener);
    }

    public ISelection getSelection() {
        if (this.currentSelection != null) {
            return this.currentSelection;
        }
        return StructuredSelection.EMPTY;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove((Object)listener);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void setSelection(ISelection selection) {
        Object listener;
        this.currentSelection = selection;
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            listener = objectArray[n2];
            ((ISelectionChangedListener)listener).selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
            ++n2;
        }
        this.selectionService.setSelection((Object)this.currentSelection);
        ISelection iSelection = selection;
        if (iSelection instanceof StructuredSelection) {
            void structured;
            listener = (StructuredSelection)iSelection;
            StructuredSelection cfr_ignored_0 = (StructuredSelection)iSelection;
            if (!structured.isEmpty()) {
                void appointment;
                Object element = structured.getFirstElement();
                Object object = element;
                if (!(object instanceof IAppointment)) return;
                IAppointment iAppointment = (IAppointment)object;
                IAppointment cfr_ignored_1 = (IAppointment)object;
                ContextServiceHolder.get().setTyped((Object)appointment);
                return;
            }
        }
        ContextServiceHolder.get().removeTyped(IAppointment.class);
    }

    @Override
    public void setScrollToNow(boolean value) {
        this.scriptingHelper.setScrollToNow(value);
    }

    @Override
    public void setShowWeekends(boolean value) {
        this.scriptingHelper.setShowWeekends(value);
    }

    public LoadEventsFunction getLoadEventsFunction() {
        return this.loadEventsFunction;
    }
}

