/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.ui.internal;

import at.medevit.ch.artikelstamm.IArtikelstammItem;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.IRecipe;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IContextService;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class GenericTypeOriginalRecipeValidator {
    @Reference
    private IContextService contextService;
    @Reference
    private IConfigService configService;

    @Activate
    public void activate() {
        this.contextService.getRootContext().setNamed("artikelstamm.selected.recipe.validate", (Object)new Supplier<Boolean>(){
            private Boolean ret;

            @Override
            public synchronized Boolean get() {
                Optional selectedRecipe;
                this.ret = Boolean.TRUE;
                if (GenericTypeOriginalRecipeValidator.this.configService.get("artikelstamm/showWarnOriginalArticlesMediRecipe", false) && (selectedRecipe = GenericTypeOriginalRecipeValidator.this.contextService.getTyped(IRecipe.class)).isPresent()) {
                    ArrayList<IArtikelstammItem> originals = new ArrayList<IArtikelstammItem>();
                    for (IPrescription prescription : ((IRecipe)selectedRecipe.get()).getPrescriptions()) {
                        if (!(prescription.getArticle() instanceof IArtikelstammItem) || !"O".equals(((IArtikelstammItem)prescription.getArticle()).getGenericType())) continue;
                        originals.add((IArtikelstammItem)prescription.getArticle());
                    }
                    if (!originals.isEmpty()) {
                        Display.getDefault().syncExec(() -> {
                            int answer = MessageDialog.open((int)4, (Shell)Display.getDefault().getActiveShell(), (String)"Originalpr\u00e4parat", (String)("Folgende Originalpr\u00e4parate sind auf dem Rezept\n\n" + originals.stream().map(a -> String.valueOf(a.getLabel()) + ", Selbstbehalt " + a.getDeductible() + "%").collect(Collectors.joining("\n")) + "\n\nSoll dieses Rezept gedruckt werden?"), (int)0, (String[])new String[]{"Ja", "Nein"});
                            if (answer == 1) {
                                this.ret = Boolean.FALSE;
                            }
                        });
                    }
                }
                return this.ret;
            }
        });
    }
}

