/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.ui;

import at.medevit.atc_codes.ATCCode;
import at.medevit.ch.artikelstamm.IArtikelstammItem;
import at.medevit.ch.artikelstamm.ui.internal.ATCCodeServiceConsumer;
import at.medevit.ch.artikelstamm.ui.internal.DatabindingTextResizeConverter;
import at.medevit.ch.artikelstamm.ui.internal.IntToStringConverterSelbstbehalt;
import at.medevit.ch.artikelstamm.ui.internal.ModelServiceHolder;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.databinding.SavingUpdateValueStrategy;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.controls.ArticleDefaultSignatureComposite;
import ch.rgw.tools.Money;
import java.text.ParseException;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class DetailComposite
extends ScrolledComposite {
    private DataBindingContext m_bindingContext;
    private WritableValue<IArtikelstammItem> item = new WritableValue(null, IArtikelstammItem.class);
    public static String prefAtcLanguage = null;
    private Label lblDSCR;
    private Text txtPHZNR;
    private Text txtGTIN;
    private Label lblHERSTELLER;
    private Label lblEXFACTORYPRICE;
    private Text txtPUBLICPRICE;
    private Tree treeATC;
    private Label lblAbgabekategorie;
    private Text txtABGABEKATEGORIE;
    private Label lblSelbstbehalt;
    private Text lblSELBSTBEHALT;
    private Button btnCheckIsNarcotic;
    private Button btnLPPVEntry;
    private Button btnK70Entry;
    private Button btnOriginalNoSubstitute;
    private Button btnlLimitation;
    private Label lblLimitationspunkte;
    private Text txtLIMITATIONPOINTS;
    private Label lblLimitationstext;
    private Text txtLIMITATIONTEXT;
    private Text txtProductNr;
    private ControlDecoration controlDecoIsCalculatedPPUB;
    private Button btnUserDefinedPrice;
    private Group grpDefaultSignature;
    private ArticleDefaultSignatureComposite adsc;
    private Composite mainComposite;

    public DetailComposite(Composite parent, int style, String atcCodeLanguage) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.setLayoutData(SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.mainComposite = new Composite((Composite)this, 0);
        this.mainComposite.setLayout((Layout)new GridLayout(1, false));
        prefAtcLanguage = atcCodeLanguage;
        Composite headerComposite = new Composite(this.mainComposite, 0);
        headerComposite.setLayout((Layout)new GridLayout(4, false));
        headerComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblDSCR = new Label(headerComposite, 0);
        this.lblDSCR.setForeground(SWTResourceManager.getColor(1));
        this.lblDSCR.setBackground(SWTResourceManager.getColor(17));
        this.lblDSCR.setFont(SWTResourceManager.getFont("Lucida Grande", 16, 1));
        GridData gd_lblDSCR = new GridData(4, 0x1000000, true, false, 4, 1);
        gd_lblDSCR.widthHint = 435;
        this.lblDSCR.setLayoutData((Object)gd_lblDSCR);
        Composite topComposite = new Composite(headerComposite, 0);
        topComposite.setLayout((Layout)new GridLayout(6, false));
        topComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        GridData gdd = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdd.widthHint = 70;
        GridData gdd2 = new GridData(4, 0x1000000, true, false, 1, 1);
        Label lblGtin = new Label(topComposite, 0);
        lblGtin.setLayoutData((Object)gdd);
        lblGtin.setToolTipText("European Article Number / Global Trade Index Number");
        lblGtin.setText("EAN/GTIN");
        this.txtGTIN = new Text(topComposite, 8);
        this.txtGTIN.setLayoutData((Object)gdd2);
        this.txtGTIN.setBackground(topComposite.getBackground());
        Label lblPhznr = new Label(topComposite, 0);
        lblPhznr.setToolTipText("Pharmacode");
        lblPhznr.setLayoutData((Object)gdd);
        lblPhznr.setText("Pharmacode");
        this.txtPHZNR = new Text(topComposite, 8);
        this.txtPHZNR.setLayoutData((Object)gdd2);
        this.txtPHZNR.setBackground(topComposite.getBackground());
        final Label lblProductNr = new Label(topComposite, 0);
        lblProductNr.setToolTipText("Produktnummer");
        lblProductNr.setLayoutData((Object)gdd);
        lblProductNr.setText("Produkt Nr");
        this.txtProductNr = new Text(topComposite, 8);
        this.txtProductNr.setLayoutData((Object)gdd2);
        this.txtProductNr.setBackground(topComposite.getBackground());
        this.txtProductNr.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                lblProductNr.setVisible(!DetailComposite.this.txtProductNr.getText().isEmpty());
            }
        });
        this.lblAbgabekategorie = new Label(headerComposite, 0);
        this.lblAbgabekategorie.setText("Abgabekategorie");
        this.txtABGABEKATEGORIE = new Text(headerComposite, 8);
        this.txtABGABEKATEGORIE.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.txtABGABEKATEGORIE.setBackground(topComposite.getBackground());
        new Label(headerComposite, 0);
        new Label(headerComposite, 0);
        Group grpPackungsgroessenPreise = new Group(this.mainComposite, 0);
        grpPackungsgroessenPreise.setText("Preis");
        grpPackungsgroessenPreise.setLayout((Layout)new GridLayout(7, false));
        grpPackungsgroessenPreise.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblExFactoryPreis = new Label((Composite)grpPackungsgroessenPreise, 0);
        lblExFactoryPreis.setText("Ex-Factory");
        this.lblEXFACTORYPRICE = new Label((Composite)grpPackungsgroessenPreise, 2048);
        this.lblEXFACTORYPRICE.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblPublicPrice = new Label((Composite)grpPackungsgroessenPreise, 0);
        lblPublicPrice.setText("Publikumspreis");
        this.txtPUBLICPRICE = new Text((Composite)grpPackungsgroessenPreise, 2048);
        this.txtPUBLICPRICE.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.controlDecoIsCalculatedPPUB = new ControlDecoration((Control)this.txtPUBLICPRICE, 16512);
        this.controlDecoIsCalculatedPPUB.setDescriptionText("Preis wurde mittels Marge kalkuliert!");
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
        this.controlDecoIsCalculatedPPUB.setImage(fieldDecoration.getImage());
        this.controlDecoIsCalculatedPPUB.hide();
        this.lblSelbstbehalt = new Label((Composite)grpPackungsgroessenPreise, 0);
        this.lblSelbstbehalt.setText("Selbstbehalt (%)");
        this.lblSELBSTBEHALT = new Text((Composite)grpPackungsgroessenPreise, 8);
        this.lblSELBSTBEHALT.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnUserDefinedPrice = new Button((Composite)grpPackungsgroessenPreise, 0x800020);
        this.btnUserDefinedPrice.setToolTipText("Benutzerdefinierter Preis");
        this.btnUserDefinedPrice.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.btnUserDefinedPrice.setImage(ResourceManager.getPluginImage("at.medevit.ch.artikelstamm.ui", "rsc/icons/money--pencil.png"));
        this.btnUserDefinedPrice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((IArtikelstammItem)DetailComposite.this.item.getValue()).setUserDefinedPrice(DetailComposite.this.btnUserDefinedPrice.getSelection());
                DetailComposite.this.m_bindingContext.updateTargets();
                DetailComposite.this.txtPUBLICPRICE.setFocus();
                CoreModelServiceHolder.get().save((Identifiable)DetailComposite.this.item.getValue());
            }
        });
        Group grepATCCode = new Group(this.mainComposite, 0);
        grepATCCode.setLayout((Layout)new GridLayout(1, false));
        grepATCCode.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grepATCCode.setText("ATC-Code");
        this.treeATC = new Tree((Composite)grepATCCode, 2048);
        GridData gd_treeATC = new GridData(4, 4, true, true, 1, 1);
        gd_treeATC.heightHint = 80;
        this.treeATC.setLayoutData((Object)gd_treeATC);
        this.treeATC.setBackground(parent.getBackground());
        Group grpMarker = new Group(this.mainComposite, 0);
        grpMarker.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        grpMarker.setText("Marker");
        grpMarker.setLayout((Layout)new GridLayout(4, false));
        this.btnCheckIsNarcotic = new Button((Composite)grpMarker, 32);
        this.btnCheckIsNarcotic.setText("Bet\u00e4ubungsmittel");
        this.btnLPPVEntry = new Button((Composite)grpMarker, 32);
        this.btnLPPVEntry.setToolTipText("Artikel wird in Liste pharmazeutischer Pr\u00e4parate mit spezieller Verwendung (LPPV) gef\u00fchrt");
        this.btnLPPVEntry.setText("LPPV Eintrag");
        this.btnK70Entry = new Button((Composite)grpMarker, 32);
        this.btnK70Entry.setToolTipText("Artikel wird in Kapitel 70 der Spezialit\u00e4tenliste gef\u00fchrt");
        this.btnK70Entry.setText("Kapitel 70 Eintrag");
        this.btnOriginalNoSubstitute = new Button((Composite)grpMarker, 32);
        this.btnOriginalNoSubstitute.setToolTipText("Substitution nicht m\u00f6glich automatisch setzen");
        this.btnOriginalNoSubstitute.setText("Substitution nicht m\u00f6glich automatisch setzen");
        GridData gd = new GridData();
        gd.exclude = true;
        this.btnOriginalNoSubstitute.setVisible(false);
        this.btnOriginalNoSubstitute.setLayoutData((Object)gd);
        this.btnOriginalNoSubstitute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DetailComposite.this.item.getValue() != null) {
                    IArtikelstammItem value = (IArtikelstammItem)DetailComposite.this.item.getValue();
                    if (DetailComposite.this.btnOriginalNoSubstitute.getSelection()) {
                        value.setExtInfo((Object)"originalnosubstitute", (Object)"true");
                        CoreModelServiceHolder.get().save((Identifiable)value);
                    } else {
                        value.setExtInfo((Object)"originalnosubstitute", (Object)"false");
                        CoreModelServiceHolder.get().save((Identifiable)value);
                    }
                }
            }
        });
        Group grpLimitations = new Group(this.mainComposite, 0);
        grpLimitations.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        grpLimitations.setText("Einschr\u00e4nkungen");
        grpLimitations.setLayout((Layout)new GridLayout(2, false));
        this.btnlLimitation = new Button((Composite)grpLimitations, 32);
        this.btnlLimitation.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.btnlLimitation.setText("Limitation");
        this.lblLimitationspunkte = new Label((Composite)grpLimitations, 0);
        this.lblLimitationspunkte.setText("Limitationspunkte");
        this.txtLIMITATIONPOINTS = new Text((Composite)grpLimitations, 8);
        this.txtLIMITATIONPOINTS.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtLIMITATIONPOINTS.setBackground(grpLimitations.getBackground());
        this.lblLimitationstext = new Label((Composite)grpLimitations, 0);
        this.lblLimitationstext.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.lblLimitationstext.setText("Limitationstext");
        gd = new GridData(4, 128, true, false, 1, 1);
        gd.widthHint = 450;
        gd.minimumWidth = 450;
        this.txtLIMITATIONTEXT = new Text((Composite)grpLimitations, 66);
        this.txtLIMITATIONTEXT.setLayoutData((Object)gd);
        this.txtLIMITATIONTEXT.setBackground(grpLimitations.getBackground());
        Group grpHersteller = new Group(this.mainComposite, 0);
        grpHersteller.setLayout((Layout)new GridLayout(1, false));
        grpHersteller.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpHersteller.setText("Hersteller");
        this.lblHERSTELLER = new Label((Composite)grpHersteller, 0);
        this.lblHERSTELLER.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.grpDefaultSignature = new Group(this.mainComposite, 0);
        this.grpDefaultSignature.setLayout((Layout)new GridLayout(1, false));
        this.grpDefaultSignature.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.grpDefaultSignature.setText("Standard Signatur");
        this.adsc = new ArticleDefaultSignatureComposite((Composite)this.grpDefaultSignature, 0);
        this.adsc.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.adsc.setOnLocationEnabled(false);
        this.m_bindingContext = this.initDataBindings();
        this.adsc.initDataBindings(this.m_bindingContext);
        this.adsc.setAutoSave(true);
        this.setContent((Control)this.mainComposite);
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
        this.setMinSize(this.mainComposite.computeSize(-1, -1));
        this.layout(true, true);
    }

    public Composite getMainComposite() {
        return this.mainComposite;
    }

    protected void checkSubclass() {
    }

    public void setItem(IArtikelstammItem obj) {
        if (this.isDisposed()) {
            return;
        }
        this.item.setValue((Object)obj);
        String atcCode = obj.getAtcCode();
        this.adsc.setArticleToBind((IArticle)obj);
        if (obj != null && "O".equals(obj.getGenericType())) {
            layoutData = (GridData)this.btnOriginalNoSubstitute.getLayoutData();
            layoutData.exclude = false;
            this.btnOriginalNoSubstitute.setVisible(true);
            String value = (String)obj.getExtInfo((Object)"originalnosubstitute");
            this.btnOriginalNoSubstitute.setSelection("true".equals(value));
        } else {
            layoutData = (GridData)this.btnOriginalNoSubstitute.getLayoutData();
            layoutData.exclude = true;
            this.btnOriginalNoSubstitute.setVisible(false);
            this.btnOriginalNoSubstitute.setSelection(false);
        }
        if (obj.isCalculatedPrice()) {
            this.controlDecoIsCalculatedPPUB.show();
        } else {
            this.controlDecoIsCalculatedPPUB.hide();
        }
        this.treeATC.removeAll();
        if (ATCCodeServiceConsumer.getATCCodeService() != null) {
            List atcHierarchy = ATCCodeServiceConsumer.getATCCodeService().getHierarchyForATCCode(atcCode);
            if (atcHierarchy != null && atcHierarchy.size() > 0) {
                ATCCode rootCode = (ATCCode)atcHierarchy.get(atcHierarchy.size() - 1);
                TreeItem root = new TreeItem(this.treeATC, 0);
                if (prefAtcLanguage.equals("ger")) {
                    root.setText(String.valueOf(rootCode.atcCode) + " " + rootCode.name_german);
                } else {
                    root.setText(String.valueOf(rootCode.atcCode) + " " + rootCode.name);
                }
                TreeItem parent = root;
                int i = atcHierarchy.size() - 2;
                while (i >= 0) {
                    ATCCode code = (ATCCode)atcHierarchy.get(i);
                    TreeItem newItem = new TreeItem(parent, 0);
                    if (prefAtcLanguage.equals("ger")) {
                        newItem.setText(String.valueOf(code.atcCode) + " " + code.name_german);
                    } else {
                        newItem.setText(String.valueOf(code.atcCode) + " " + code.name);
                    }
                    parent = newItem;
                    if (i == 0) {
                        this.treeATC.setSelection(newItem);
                    }
                    --i;
                }
            }
        } else {
            TreeItem root = new TreeItem(this.treeATC, 0);
            root.setText(obj.getAtcCode());
        }
        this.setMinSize(this.mainComposite.computeSize(-1, -1));
        this.layout(true, true);
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue observeTextLblDSCRObserveWidget = WidgetProperties.text().observe((Widget)this.lblDSCR);
        IObservableValue itemDSCRObserveDetailValue = PojoProperties.value(IArtikelstammItem.class, (String)"label", String.class).observeDetail(this.item);
        bindingContext.bindValue((IObservableValue)observeTextLblDSCRObserveWidget, itemDSCRObserveDetailValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        ISWTObservableValue observeTextLblGTINObserveWidget = WidgetProperties.text().observe((Widget)this.txtGTIN);
        IObservableValue itemGTINObserveDetailValue = PojoProperties.value(IArtikelstammItem.class, (String)"gtin", String.class).observeDetail(this.item);
        bindingContext.bindValue((IObservableValue)observeTextLblGTINObserveWidget, itemGTINObserveDetailValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        ISWTObservableValue observeTextLblPHZNRObserveWidget = WidgetProperties.text().observe((Widget)this.txtPHZNR);
        IObservableValue itemPHARObserveDetailValue = PojoProperties.value(IArtikelstammItem.class, (String)"PHAR", String.class).observeDetail(this.item);
        bindingContext.bindValue((IObservableValue)observeTextLblPHZNRObserveWidget, itemPHARObserveDetailValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        ISWTObservableValue observeTextProductNrObserveWidget = WidgetProperties.text().observe((Widget)this.txtProductNr);
        IObservableValue itemProductNrObserveDetailValue = PojoProperties.value(IArtikelstammItem.class, (String)"productId", String.class).observeDetail(this.item);
        bindingContext.bindValue((IObservableValue)observeTextProductNrObserveWidget, itemProductNrObserveDetailValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        ISWTObservableValue observeTextLblHERSTELLERObserveWidget = WidgetProperties.text().observe((Widget)this.lblHERSTELLER);
        IObservableValue itemManufacturerLabelObserveDetailValue = PojoProperties.value(IArtikelstammItem.class, (String)"manufacturerLabel", String.class).observeDetail(this.item);
        bindingContext.bindValue((IObservableValue)observeTextLblHERSTELLERObserveWidget, itemManufacturerLabelObserveDetailValue, null, null);
        ISWTObservableValue observeTextLblEXFACTORYPRICEObserveWidget = WidgetProperties.text().observe((Widget)this.lblEXFACTORYPRICE);
        IObservableValue itemExFactoryPriceObserveDetailValue = PojoProperties.value(IArtikelstammItem.class, (String)"purchasePrice", Double.class).observeDetail(this.item);
        bindingContext.bindValue((IObservableValue)observeTextLblEXFACTORYPRICEObserveWidget, itemExFactoryPriceObserveDetailValue, null, null);
        ISWTObservableValue observeTextLblPUBLICPRICEObserveWidget = WidgetProperties.text((int[])new int[]{24, 16}).observeDelayed(100, (Widget)this.txtPUBLICPRICE);
        IObservableValue itemPublicPriceObserveDetailValue = PojoProperties.value(IArtikelstammItem.class, (String)"sellingPrice", Money.class).observeDetail(this.item);
        SavingUpdateValueStrategy strategy_2 = new SavingUpdateValueStrategy(ModelServiceHolder.get(), this.item);
        strategy_2.setConverter((IConverter)new IConverter<String, Money>(){

            public Money convert(String fromObject) {
                if (fromObject instanceof String) {
                    try {
                        return new Money(fromObject);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                return null;
            }

            public Object getFromType() {
                return String.class;
            }

            public Object getToType() {
                return Money.class;
            }
        });
        bindingContext.bindValue((IObservableValue)observeTextLblPUBLICPRICEObserveWidget, itemPublicPriceObserveDetailValue, (UpdateValueStrategy)strategy_2, null);
        ISWTObservableValue observeTextLblABGABEKATEGORIEObserveWidget = WidgetProperties.text().observe((Widget)this.txtABGABEKATEGORIE);
        IObservableValue itemSwissmedicCategoryObserveDetailValue = PojoProperties.value(IArtikelstammItem.class, (String)"swissmedicCategory", String.class).observeDetail(this.item);
        bindingContext.bindValue((IObservableValue)observeTextLblABGABEKATEGORIEObserveWidget, itemSwissmedicCategoryObserveDetailValue, null, null);
        ISWTObservableValue observeTextLblSELBSTBEHALTObserveWidget = WidgetProperties.text().observe((Widget)this.lblSELBSTBEHALT);
        IObservableValue itemDeductibleObserveDetailValue = PojoProperties.value(IArtikelstammItem.class, (String)"deductible", Integer.class).observeDetail(this.item);
        UpdateValueStrategy strategy_1 = new UpdateValueStrategy();
        strategy_1.setConverter((IConverter)new IntToStringConverterSelbstbehalt());
        bindingContext.bindValue((IObservableValue)observeTextLblSELBSTBEHALTObserveWidget, itemDeductibleObserveDetailValue, null, strategy_1);
        ISWTObservableValue observeSelectionBtnCheckIsNarcoticObserveWidget = WidgetProperties.buttonSelection().observe((Widget)this.btnCheckIsNarcotic);
        IObservableValue itemNarcoticObserveDetailValue = PojoProperties.value(IArtikelstammItem.class, (String)"narcotic", Boolean.class).observeDetail(this.item);
        bindingContext.bindValue((IObservableValue)observeSelectionBtnCheckIsNarcoticObserveWidget, itemNarcoticObserveDetailValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        ISWTObservableValue observeTextLblLIMITATIONTEXTObserveWidget = WidgetProperties.text().observe((Widget)this.txtLIMITATIONTEXT);
        IObservableValue itemLimitationTextObserveDetailValue = PojoProperties.value(IArtikelstammItem.class, (String)"limitationText", String.class).observeDetail(this.item);
        bindingContext.bindValue((IObservableValue)observeTextLblLIMITATIONTEXTObserveWidget, itemLimitationTextObserveDetailValue, null, null);
        ISWTObservableValue observeTextLblLIMITATIONPOINTSObserveWidget = WidgetProperties.text().observe((Widget)this.txtLIMITATIONPOINTS);
        IObservableValue itemLimitationPointsObserveDetailValue = PojoProperties.value(IArtikelstammItem.class, (String)"limitationPoints", String.class).observeDetail(this.item);
        bindingContext.bindValue((IObservableValue)observeTextLblLIMITATIONPOINTSObserveWidget, itemLimitationPointsObserveDetailValue, null, null);
        ISWTObservableValue observeSelectionBtnLPPVEntryObserveWidget = WidgetProperties.buttonSelection().observe((Widget)this.btnLPPVEntry);
        IObservableValue itemInLPPVObserveDetailValue = PojoProperties.value(IArtikelstammItem.class, (String)"inLPPV", Boolean.class).observeDetail(this.item);
        bindingContext.bindValue((IObservableValue)observeSelectionBtnLPPVEntryObserveWidget, itemInLPPVObserveDetailValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        ISWTObservableValue observeSelectionBtnK70EntryObserveWidget = WidgetProperties.buttonSelection().observe((Widget)this.btnK70Entry);
        IObservableValue itemInK70ObserveDetailValue = PojoProperties.value(IArtikelstammItem.class, (String)"inK70", Boolean.class).observeDetail(this.item);
        bindingContext.bindValue((IObservableValue)observeSelectionBtnK70EntryObserveWidget, itemInK70ObserveDetailValue, (UpdateValueStrategy)new SavingUpdateValueStrategy(ModelServiceHolder.get(), this.item), null);
        ISWTObservableValue observeSelectionBtnlLimitationObserveWidget = WidgetProperties.buttonSelection().observe((Widget)this.btnlLimitation);
        IObservableValue itemLimitedObserveDetailValue = PojoProperties.value(IArtikelstammItem.class, (String)"limited", Boolean.class).observeDetail(this.item);
        bindingContext.bindValue((IObservableValue)observeSelectionBtnlLimitationObserveWidget, itemLimitedObserveDetailValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        ISWTObservableValue observeSizeLblLIMITATIONTEXTObserveWidget = WidgetProperties.size().observe((Widget)this.txtLIMITATIONTEXT);
        ISWTObservableValue observeTextLblLIMITATIONTEXTObserveWidget_1 = WidgetProperties.text((int)24).observe((Widget)this.txtLIMITATIONTEXT);
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setConverter((IConverter)new DatabindingTextResizeConverter(this.txtLIMITATIONTEXT));
        bindingContext.bindValue((IObservableValue)observeSizeLblLIMITATIONTEXTObserveWidget, (IObservableValue)observeTextLblLIMITATIONTEXTObserveWidget_1, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), strategy);
        ISWTObservableValue observeSelectionBtnUserDefinedPriceObserveWidget = WidgetProperties.buttonSelection().observe((Widget)this.btnUserDefinedPrice);
        IObservableValue itemCalculatedPriceObserveDetailValue = PojoProperties.value(IArtikelstammItem.class, (String)"userDefinedPrice", Boolean.class).observeDetail(this.item);
        bindingContext.bindValue((IObservableValue)observeSelectionBtnUserDefinedPriceObserveWidget, itemCalculatedPriceObserveDetailValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        ISWTObservableValue observeEditableTxtPUBLICPRICEObserveWidget = WidgetProperties.editable().observe((Widget)this.txtPUBLICPRICE);
        IObservableValue itemUserDefinedPriceObserveDetailValue = PojoProperties.value(IArtikelstammItem.class, (String)"userDefinedPrice", Boolean.class).observeDetail(this.item);
        bindingContext.bindValue((IObservableValue)observeEditableTxtPUBLICPRICEObserveWidget, itemUserDefinedPriceObserveDetailValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        return bindingContext;
    }

    public static void setPrefAtcLanguage(String prefAtcLanguage) {
        DetailComposite.prefAtcLanguage = prefAtcLanguage;
    }
}

