/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.ui;

import at.medevit.ch.artikelstamm.ArtikelstammConstants;
import at.medevit.ch.artikelstamm.IArtikelstammItem;
import ch.elexis.core.ui.UiDesk;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.swt.ResourceManager;

public class ArtikelstammLabelProvider
extends LabelProvider
implements IColorProvider {
    private static Image emptyTransparent = ResourceManager.getPluginImage("at.medevit.ch.artikelstamm.ui", "rsc/icons/emptyTransparent.png");
    private static Image pharmaMain = ResourceManager.getPluginImage("at.medevit.ch.artikelstamm.ui", "rsc/icons/pharma.png");
    private static Image nonPharmaMain = ResourceManager.getPluginImage("at.medevit.ch.artikelstamm.ui", "rsc/icons/nonPharma.png");
    private static Image slMain = ResourceManager.getPluginImage("at.medevit.ch.artikelstamm.ui", "rsc/icons/sl.png");

    public String getText(Object element) {
        IArtikelstammItem item = (IArtikelstammItem)element;
        StringBuilder sb = new StringBuilder();
        if (item.getDeductible() > 0) {
            sb.append("[" + item.getDeductible() + "%] ");
        }
        sb.append(item.getLabel());
        return sb.toString();
    }

    public Image getImage(Object element) {
        IArtikelstammItem item = (IArtikelstammItem)element;
        ArtikelstammConstants.TYPE itemType = item.getType();
        if (itemType == null) {
            return emptyTransparent;
        }
        switch (itemType) {
            case N: {
                return nonPharmaMain;
            }
            case P: {
                return item.isInSLList() ? slMain : pharmaMain;
            }
            case X: {
                return pharmaMain;
            }
        }
        return emptyTransparent;
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        IArtikelstammItem item = (IArtikelstammItem)element;
        ArtikelstammConstants.TYPE itemType = item.getType();
        if (itemType == null) {
            return null;
        }
        if (itemType == ArtikelstammConstants.TYPE.X) {
            return UiDesk.getColor((String)"himmelblau");
        }
        return null;
    }
}

