/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.model.service;

import at.medevit.ch.artikelstamm.ArtikelstammConstants;
import at.medevit.ch.artikelstamm.IArtikelstammItem;
import at.medevit.ch.artikelstamm.model.service.ArtikelstammModelAdapterFactory;
import at.medevit.ch.artikelstamm.model.service.ArtikelstammQuery;
import ch.elexis.core.common.ElexisEvent;
import ch.elexis.core.jpa.entities.ArtikelstammItem;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.AbstractIdModelAdapter;
import ch.elexis.core.jpa.model.adapter.AbstractModelService;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICodeElementServiceContribution;
import ch.elexis.core.services.IElexisEntityManager;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IStoreToStringContribution;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;
import org.slf4j.LoggerFactory;

@Component(property={"service.model.name=at.medevit.ch.artikelstamm.model"})
public class ArtikelstammModelService
extends AbstractModelService
implements IModelService,
IStoreToStringContribution,
ICodeElementServiceContribution {
    @Reference(target="(id=default)")
    private IElexisEntityManager entityManager;
    @Reference
    private EventAdmin eventAdmin;

    @Activate
    public void activate() {
        this.adapterFactory = ArtikelstammModelAdapterFactory.getInstance();
    }

    public Optional<String> storeToString(Identifiable identifiable) {
        if (identifiable instanceof IArtikelstammItem) {
            return Optional.of("ch.artikelstamm.elexis.common.ArtikelstammItem::" + identifiable.getId());
        }
        return Optional.empty();
    }

    public Optional<Identifiable> loadFromString(String storeToString) {
        if (storeToString == null) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("StoreToString is null");
            return Optional.empty();
        }
        if (storeToString.startsWith("ch.artikelstamm.elexis.common.ArtikelstammItem::")) {
            String[] split = this.splitIntoTypeAndId(storeToString);
            String id = split[1];
            EntityManager em = (EntityManager)this.entityManager.getEntityManager();
            EntityWithId dbObject = (EntityWithId)em.find(ArtikelstammItem.class, (Object)id);
            return Optional.ofNullable(this.adapterFactory.getModelAdapter(dbObject, null, false).orElse(null));
        }
        return Optional.empty();
    }

    public List<Identifiable> loadFromStringWithIdPart(String partialStoreToString) {
        if (partialStoreToString == null) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("StoreToString is null");
            return Collections.emptyList();
        }
        if (partialStoreToString.startsWith("ch.artikelstamm.elexis.common.ArtikelstammItem::")) {
            String[] split = this.splitIntoTypeAndId(partialStoreToString);
            String id = split[1];
            Class<ArtikelstammItem> clazz = ArtikelstammItem.class;
            if (clazz != null) {
                EntityManager em = (EntityManager)this.entityManager.getEntityManager();
                TypedQuery query = em.createQuery("SELECT entity FROM " + clazz.getSimpleName() + " entity WHERE entity.id LIKE :idpart", clazz);
                query.setParameter("idpart", (Object)(String.valueOf(id) + "%"));
                List found = query.getResultList();
                if (!found.isEmpty()) {
                    return found.parallelStream().map(e -> this.adapterFactory.getModelAdapter(e, null, false).orElse(null)).collect(Collectors.toList());
                }
            }
        }
        return Collections.emptyList();
    }

    public <T> IQuery<T> getQuery(Class<T> clazz, boolean refreshCache, boolean includeDeleted) {
        return new ArtikelstammQuery<T>(clazz, refreshCache, (EntityManager)this.entityManager.getEntityManager(), includeDeleted);
    }

    protected EntityManager getEntityManager(boolean managed) {
        return (EntityManager)this.entityManager.getEntityManager(managed);
    }

    protected void closeEntityManager(EntityManager entityManager) {
        this.entityManager.closeEntityManager((Object)entityManager);
    }

    protected EventAdmin getEventAdmin() {
        return this.eventAdmin;
    }

    protected ElexisEvent getCreateEvent(Identifiable identifiable) {
        if (identifiable instanceof AbstractIdModelAdapter) {
            return ElexisEvent.of((String)"info/elexis/po/create", (String)identifiable.getId(), (String)"ch.artikelstamm.elexis.common.ArtikelstammItem");
        }
        return null;
    }

    public String getSystem() {
        return "Artikelstamm";
    }

    public ICodeElementService.CodeElementTyp getTyp() {
        return ICodeElementService.CodeElementTyp.ARTICLE;
    }

    public Optional<ICodeElement> loadFromCode(String code, Map<Object, Object> context) {
        boolean includeBlackBoxed = this.getIncludeBlackBoxed(context);
        INamedQuery query = this.getNamedQuery(IArtikelstammItem.class, new String[]{"gtin"});
        List found = query.executeWithParameters(query.getParameterMap(new Object[]{"gtin", code}));
        if (!includeBlackBoxed) {
            found = found.stream().filter(ai -> !ai.isBlackBoxed()).collect(Collectors.toList());
        }
        if (found.size() > 0) {
            if (found.size() > 1) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Found more than 1 code element for gtin [" + code + "]");
            }
            return Optional.of((ICodeElement)found.get(0));
        }
        IQuery pharmaQuery = this.getQuery(IArtikelstammItem.class);
        pharmaQuery.and("phar", IQuery.COMPARATOR.EQUALS, (Object)code);
        found = pharmaQuery.execute();
        if (found.size() > 0) {
            if (found.size() > 1) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Found more than 1 code element for phar [" + code + "]");
            }
            return Optional.of((ICodeElement)found.get(0));
        }
        if (context.containsKey("CONSIDER_PRODNO")) {
            IQuery prodnoQuery = this.getQuery(IArtikelstammItem.class);
            prodnoQuery.and("id", IQuery.COMPARATOR.EQUALS, (Object)code);
            found = prodnoQuery.execute();
            if (found.size() > 0) {
                if (found.size() > 1) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Found more than 1 code element for prodno [" + code + "]");
                }
                return Optional.of((ICodeElement)found.get(0));
            }
        }
        return Optional.empty();
    }

    private boolean getIncludeBlackBoxed(Map<Object, Object> context) {
        if (context != null) {
            return context != null && context.get(ArtikelstammConstants.ContextKeys.INCLUDE_BB) != null && context.get(ArtikelstammConstants.ContextKeys.INCLUDE_BB) == Boolean.TRUE;
        }
        return false;
    }

    public List<ICodeElement> getElements(Map<Object, Object> context) {
        return null;
    }

    public void clearCache() {
        this.entityManager.clearCache();
    }

    public Class<?> getEntityForType(String type) {
        if ("ch.artikelstamm.elexis.common.ArtikelstammItem".equals(type)) {
            return ArtikelstammItem.class;
        }
        return null;
    }

    public String getTypeForEntity(Object entityInstance) {
        if (entityInstance instanceof ArtikelstammItem) {
            return "ch.artikelstamm.elexis.common.ArtikelstammItem";
        }
        return null;
    }

    public String getTypeForModel(Class<?> interfaze) {
        Class entityClass = this.adapterFactory.getEntityClass(interfaze);
        if (entityClass != null) {
            try {
                return this.getTypeForEntity(entityClass.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error getting type for model [" + interfaze + "]", (Throwable)e);
            }
        }
        return null;
    }

    protected IModelService getCoreModelService() {
        return null;
    }
}

