/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.elexis.common.ui.provider;

import at.medevit.atc_codes.ATCCode;
import at.medevit.ch.artikelstamm.IArtikelstammItem;
import at.medevit.ch.artikelstamm.elexis.common.service.ATCCodeCacheServiceHolder;
import at.medevit.ch.artikelstamm.elexis.common.ui.cv.ATCFilterInfoListElement;
import at.medevit.ch.artikelstamm.ui.ATCLabelProvider;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.types.VatInfo;
import ch.rgw.tools.Money;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class ATCArtikelstammDecoratingLabelProvider
extends DecoratingLabelProvider {
    private ATCLabelProvider atcLabelProvider;
    private String atcLang;

    public ATCArtikelstammDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator, String atcLang) {
        super(provider, decorator);
        this.atcLabelProvider = new ATCLabelProvider(atcLang);
    }

    public String getText(Object element) {
        if (element instanceof IArtikelstammItem) {
            Money publicPrice;
            String ret = super.getText(element);
            IArtikelstammItem ai = (IArtikelstammItem)element;
            if (ai.isOverrideVatInfo()) {
                ret = String.valueOf(ret) + " (MWSt: " + this.resolveVatInfoLabel(ai.getVatInfo()) + ")";
            }
            if (ConfigServiceHolder.get().get("artikelstamm/showPriceInOverview", true) && (publicPrice = ai.getSellingPrice()) != null && publicPrice.getAmount() > 0.0) {
                ret = String.valueOf(ret) + " <" + ai.getSellingPrice().getAmount() + "> ";
            }
            return ret;
        }
        if (element instanceof ATCCode) {
            String atcLabel = this.atcLabelProvider.getText(element);
            String atcLabelWAvailability = String.valueOf(atcLabel) + " [" + this.determineNumberOfAvailableArticlesForAtcCode((ATCCode)element) + " Artikel]";
            return atcLabelWAvailability;
        }
        if (element instanceof ATCFilterInfoListElement) {
            ATCFilterInfoListElement afile = (ATCFilterInfoListElement)element;
            return afile.getDescription();
        }
        return null;
    }

    private String determineNumberOfAvailableArticlesForAtcCode(ATCCode element) {
        return String.valueOf(ATCCodeCacheServiceHolder.getAvailableArticlesByATCCode(element));
    }

    private String resolveVatInfoLabel(VatInfo vatinfo) {
        switch (vatinfo) {
            case VAT_CH_ISMEDICAMENT: {
                return "Reduziert";
            }
            case VAT_NONE: {
                return "Keine";
            }
        }
        return "Normal";
    }

    public Image getImage(Object element) {
        if (element instanceof IArtikelstammItem) {
            return super.getImage(element);
        }
        if (element instanceof ATCCode) {
            return this.atcLabelProvider.getImage(element);
        }
        if (element instanceof ATCFilterInfoListElement) {
            return this.atcLabelProvider.getImage(element);
        }
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof IArtikelstammItem) {
            return super.getForeground(element);
        }
        if (element instanceof ATCCode) {
            return this.atcLabelProvider.getForeground(element);
        }
        if (element instanceof ATCFilterInfoListElement) {
            return null;
        }
        return null;
    }

    public Color getBackground(Object element) {
        if (element instanceof IArtikelstammItem) {
            return super.getBackground(element);
        }
        if (element instanceof ATCCode) {
            return this.atcLabelProvider.getBackground(element);
        }
        if (element instanceof ATCFilterInfoListElement) {
            return this.atcLabelProvider.getBackground(element);
        }
        return null;
    }
}

