/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.elexis.common.ui.cv;

import at.medevit.atc_codes.ATCCode;
import at.medevit.atc_codes.ATCCodeService;
import at.medevit.ch.artikelstamm.IArtikelstammItem;
import at.medevit.ch.artikelstamm.elexis.common.service.ATCCodeCacheServiceHolder;
import at.medevit.ch.artikelstamm.elexis.common.service.ATCCodeServiceHolder;
import at.medevit.ch.artikelstamm.elexis.common.service.ModelServiceHolder;
import at.medevit.ch.artikelstamm.elexis.common.ui.cv.ATCFilterInfoListElement;
import at.medevit.ch.artikelstamm.elexis.common.ui.cv.AtcQueryFilter;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.LazyCommonViewerContentProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import java.util.HashMap;
import java.util.List;

public class ArtikelstammCommonViewerContentProvider
extends LazyCommonViewerContentProvider {
    private static final int QUERY_LIMIT = 500;
    private ViewerConfigurer.ControlFieldProvider controlFieldProvider;
    private boolean addAtcElements;

    public ArtikelstammCommonViewerContentProvider(CommonViewer commonViewer, ViewerConfigurer.ControlFieldProvider controlFieldProvider) {
        super(commonViewer);
        this.controlFieldProvider = controlFieldProvider;
    }

    public Object[] getElements(Object arg0) {
        IQuery<?> query = this.getBaseQuery();
        query.startGroup();
        this.controlFieldProvider.setQuery(query);
        if (this.controlFieldProvider.getValues() != null && this.controlFieldProvider.getValues().length > 0) {
            query.or("gtin", IQuery.COMPARATOR.LIKE, (Object)(String.valueOf(this.controlFieldProvider.getValues()[0]) + "%"));
        }
        query.startGroup();
        this.applyQueryFilters(query);
        query.andJoinGroups();
        query.orderBy("ldscr", IQuery.ORDER.ASC);
        List elements = query.execute();
        this.commonViewer.setLimitReached(elements.size() == 500, 500);
        if (this.addAtcElements && !this.isQueryFilterByType(AtcQueryFilter.class)) {
            this.insertATCCodeValues(elements);
        }
        if (this.isQueryFilterByType(AtcQueryFilter.class)) {
            this.getQueryFilterByType(AtcQueryFilter.class).ifPresent(qf -> this.addFilterInformation((AtcQueryFilter)qf, elements));
        }
        return elements.toArray(new Object[elements.size()]);
    }

    protected String getJobName() {
        return "Artikelstamm load";
    }

    protected IQuery<?> getBaseQuery() {
        IQuery ret = ModelServiceHolder.get().getQuery(IArtikelstammItem.class);
        if (!this.ignoreLimit) {
            ret.limit(500);
        }
        return ret;
    }

    public void changed(HashMap<String, String> values) {
        super.setIgnoreLimit(false);
        super.changed(values);
    }

    protected void setIgnoreLimit(boolean value) {
        super.setIgnoreLimit(value);
        this.asyncReload();
    }

    public void setAddAtcElements(boolean checked) {
        this.addAtcElements = checked;
        this.commonViewer.notify(CommonViewer.Message.update);
    }

    private void addFilterInformation(AtcQueryFilter atcQueryFilter, List<Object> elements) {
        String atcFilterValue = atcQueryFilter.getFilterValue();
        String atcInfo = ATCCodeServiceHolder.get().get().getForATCCode((String)atcFilterValue).name_german;
        String label = "ATC Filter " + atcFilterValue + " (" + atcInfo + ")";
        ATCFilterInfoListElement aficle = new ATCFilterInfoListElement(label);
        elements.add(0, aficle);
    }

    private void insertATCCodeValues(List<Object> elements) {
        if (this.fieldFilterValues != null) {
            String name = (String)this.fieldFilterValues.get("ldscr");
            if (name == null || name.length() < 1) {
                return;
            }
            ATCCodeService atcCodeService = ATCCodeServiceHolder.get().get();
            if (atcCodeService == null) {
                return;
            }
            List results = atcCodeService.getATCCodesMatchingName(name, 1, 1);
            boolean showEmptyGroups = ConfigServiceHolder.get().get("artikelstamm/showAtcGropsWoArticles", true);
            if (!showEmptyGroups) {
                for (ATCCode atcCode : results) {
                    if (ATCCodeCacheServiceHolder.getAvailableArticlesByATCCode(atcCode) <= 0) continue;
                    elements.add(atcCode);
                }
            } else {
                elements.addAll(0, results);
            }
        }
    }
}

