/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.elexis.common.ui;

import at.medevit.ch.artikelstamm.ArtikelstammHelper;
import at.medevit.ch.artikelstamm.DATASOURCEType;
import at.medevit.ch.artikelstamm.IArtikelstammItem;
import at.medevit.ch.artikelstamm.elexis.common.service.ModelServiceHolder;
import at.medevit.ch.artikelstamm.elexis.common.service.VersionUtil;
import at.medevit.ch.artikelstamm.ui.DetailComposite;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.databinding.SavingUpdateValueStrategy;
import ch.elexis.core.ui.util.ZeroDefaultIntegerStringConverter;
import ch.elexis.core.ui.util.ZeroDefaultStringIntegerConverter;
import ch.elexis.core.ui.views.IDetailDisplay;
import ch.elexis.core.ui.views.controls.StockDetailComposite;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;

public class DetailDisplay
implements IDetailDisplay {
    protected WritableValue<IArtikelstammItem> item = new WritableValue(null, IArtikelstammItem.class);
    private DetailComposite dc = null;
    private StockDetailComposite sdc;
    private Text txtStkProPack;
    private Text txtStkProAbgabe;

    public Class<?> getElementClass() {
        return IArtikelstammItem.class;
    }

    @Inject
    public void selection(@Optional @Named(value="at.medevit.ch.artikelstamm.elexis.common.ui.selection") @Named(value="at.medevit.ch.artikelstamm.elexis.common.ui.selection") IArtikelstammItem item) {
        if (item != null && this.dc != null && !this.dc.isDisposed()) {
            this.display(item);
        }
    }

    public void display(Object obj) {
        IArtikelstammItem ai = (IArtikelstammItem)obj;
        if (ai != null) {
            ModelServiceHolder.get().refresh((Identifiable)ai, true);
        }
        this.item.setValue((Object)ai);
        if (this.dc != null) {
            this.dc.setItem(ai);
        }
        if (this.sdc != null && !this.sdc.isDisposed()) {
            this.sdc.setArticle((IArticle)ai);
        }
        if (ai != null) {
            if (!this.txtStkProAbgabe.isDisposed()) {
                this.txtStkProAbgabe.setEnabled(!ai.isProduct());
            }
            if (!this.txtStkProPack.isDisposed()) {
                this.txtStkProPack.setEnabled(!ai.isProduct());
            }
        }
    }

    public String getTitle() {
        return "Artikelstamm";
    }

    public Composite createDisplay(Composite parent, IViewSite site) {
        if (this.dc == null) {
            String atcLang = ConfigServiceHolder.get().get("artikelstamm/atcCodeLanguage", "ger");
            this.dc = new DetailComposite(parent, 768, atcLang);
            this.addLagerhaltungGroupToComposite(this.dc);
            this.addAdditionalInformation(this.dc);
            this.addDataSetStateLabelToComposite(this.dc);
        }
        return this.dc;
    }

    public void addAdditionalInformation(DetailComposite dc) {
    }

    private void addDataSetStateLabelToComposite(DetailComposite dc) {
        Date creationDate;
        Composite ret = new Composite(dc.getMainComposite(), 0);
        ret.setLayout((Layout)new GridLayout(2, false));
        ret.setLayoutData((Object)new GridData(4, 512, true, false));
        Label label = new Label(ret, 0);
        label.setLayoutData((Object)new GridData(4, 16384, true, false, 1, 1));
        StringBuilder sb = new StringBuilder();
        int version = VersionUtil.getCurrentVersion();
        if (version != 99999) {
            sb.append(" v" + version);
        }
        if ((creationDate = VersionUtil.getImportSetCreationDate()) != null) {
            sb.append(" / " + ArtikelstammHelper.monthAndYearWritten.format(creationDate));
        }
        DATASOURCEType datasourceType = DATASOURCEType.ODDB_2_XML;
        try {
            datasourceType = VersionUtil.getDatasourceType();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        sb.append(" / " + datasourceType.value());
        label.setText("Datensatz-Basis: " + sb.toString());
        this.addUpdateLabelToBottom(ret);
    }

    public void addUpdateLabelToBottom(Composite dc) {
    }

    private void addLagerhaltungGroupToComposite(DetailComposite dc) {
        DataBindingContext bindingContext = new DataBindingContext();
        Group grpLagerhaltung = new Group(dc.getMainComposite(), 0);
        grpLagerhaltung.setText("Lagerhaltung");
        grpLagerhaltung.setLayout((Layout)new GridLayout(4, false));
        grpLagerhaltung.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.sdc = new StockDetailComposite((Composite)grpLagerhaltung, 0);
        GridData gridData = new GridData(4, 4, false, true, 4, 1);
        gridData.heightHint = 100;
        this.sdc.setLayoutData((Object)gridData);
        Label lblStkProPack = new Label((Composite)grpLagerhaltung, 0);
        lblStkProPack.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblStkProPack.setText("Stk. pro Pckg.");
        this.txtStkProPack = new Text((Composite)grpLagerhaltung, 2048);
        this.txtStkProPack.setTextLimit(4);
        GridData gd_txtStkProPack = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtStkProPack.widthHint = 40;
        this.txtStkProPack.setLayoutData((Object)gd_txtStkProPack);
        this.txtStkProPack.addVerifyListener(e -> {
            if (!this.checkInput(e.text)) {
                e.doit = false;
            }
        });
        IObservableValue propertyStkProPack = PojoProperties.value(IArtikelstammItem.class, (String)"packageSize", Integer.class).observeDetail(this.item);
        ISWTObservableValue targetStkProPack = WidgetProperties.text((int)24).observe((Widget)this.txtStkProPack);
        bindingContext.bindValue((IObservableValue)targetStkProPack, propertyStkProPack, new SavingUpdateValueStrategy(CoreModelServiceHolder.get(), this.item).setAutoSave(true).setConverter((IConverter)new ZeroDefaultIntegerStringConverter()), new UpdateValueStrategy().setConverter((IConverter)new ZeroDefaultStringIntegerConverter()));
        Label lblStkProAbgabe = new Label((Composite)grpLagerhaltung, 0);
        lblStkProAbgabe.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblStkProAbgabe.setText("Stk. pro Abgabe");
        String tooltip = "F\u00fcr Komplettpackung bitte 0 Stk. angeben.";
        lblStkProAbgabe.setToolTipText("F\u00fcr Komplettpackung bitte 0 Stk. angeben.");
        this.txtStkProAbgabe = new Text((Composite)grpLagerhaltung, 2048);
        this.txtStkProAbgabe.setTextLimit(4);
        GridData gd_txtStkProAbgabe = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtStkProAbgabe.widthHint = 40;
        this.txtStkProAbgabe.setLayoutData((Object)gd_txtStkProAbgabe);
        this.txtStkProAbgabe.setToolTipText("F\u00fcr Komplettpackung bitte 0 Stk. angeben.");
        this.txtStkProAbgabe.addVerifyListener(e -> {
            if (!this.checkInput(e.text)) {
                e.doit = false;
            }
        });
        IObservableValue propertyStkProAbgabe = PojoProperties.value(IArtikelstammItem.class, (String)"sellingSize", Integer.class).observeDetail(this.item);
        ISWTObservableValue targetStkProAbgabe = WidgetProperties.text((int)24).observe((Widget)this.txtStkProAbgabe);
        bindingContext.bindValue((IObservableValue)targetStkProAbgabe, propertyStkProAbgabe, new SavingUpdateValueStrategy(CoreModelServiceHolder.get(), this.item).setAutoSave(true).setConverter((IConverter)new ZeroDefaultIntegerStringConverter()), new UpdateValueStrategy().setConverter((IConverter)new ZeroDefaultStringIntegerConverter()));
    }

    private boolean checkInput(String inInput) {
        int inputLength = inInput.length();
        int i = 0;
        while (i < inputLength) {
            char key = inInput.charAt(i);
            if (!Character.isDigit(key) && !Character.isISOControl(key)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

