/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities;

import ch.elexis.core.jpa.entities.AbstractEntityWithId;
import ch.elexis.core.jpa.entities.Behandlung;
import ch.elexis.core.jpa.entities.EntityWithDeleted;
import ch.elexis.core.jpa.entities.EntityWithExtInfo;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Invoice;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.entities.converter.BooleanCharacterConverterSafe;
import ch.elexis.core.jpa.entities.converter.IntegerStringConverter;
import ch.elexis.core.jpa.entities.listener.EntityWithIdListener;
import ch.elexis.core.model.util.ElexisIdGenerator;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.beans.Transient;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="VERRECHNETCOPY")
@EntityListeners(value={EntityWithIdListener.class})
@NamedQuery(name="VerrechnetCopy.encounter", query="SELECT ve FROM VerrechnetCopy ve WHERE ve.deleted = false AND ve.behandlung = :encounter")
public class VerrechnetCopy
extends AbstractEntityWithId
implements EntityWithId,
EntityWithDeleted,
EntityWithExtInfo,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    protected Long lastupdate;
    @Id
    @GeneratedValue(generator="system-uuid")
    @Column(unique=true, nullable=false, length=25)
    private String id;
    @Column
    @Convert(converter=BooleanCharacterConverterSafe.class)
    protected boolean deleted;
    @Column(length=80)
    private String klasse;
    @Column(length=25, name="leistg_code")
    private String leistungenCode;
    @Column(length=255, name="leistg_txt")
    private String leistungenText;
    @OneToOne
    @JoinColumn(name="rechnungid")
    private Invoice invoice;
    @OneToOne
    @JoinColumn(name="behandlungid")
    private Behandlung behandlung;
    @Convert(converter=IntegerStringConverter.class)
    private int zahl;
    @Convert(converter=IntegerStringConverter.class)
    private int ek_kosten;
    @Convert(converter=IntegerStringConverter.class)
    private int vk_tp;
    @Column(length=8)
    private String vk_scale;
    @Convert(converter=IntegerStringConverter.class)
    private int vk_preis;
    @Convert(converter=IntegerStringConverter.class)
    private int scale;
    @Convert(converter=IntegerStringConverter.class)
    private int scale2;
    @OneToOne
    @JoinColumn(name="userID")
    private Kontakt user;
    @Lob
    private byte[] detail;
    static final long serialVersionUID = 1661292041572609879L;

    public VerrechnetCopy() {
        this.id = ElexisIdGenerator.generateId();
        this.deleted = false;
    }

    @Transient
    public double getPrimaryScaleFactor() {
        if (this.getScale() == 0) {
            return 1.0;
        }
        return (double)this.getScale() / 100.0;
    }

    @Transient
    public void setPrimaryScaleFactor(double scale) {
        int sca = (int)Math.round(scale * 100.0);
        this.setScale(sca);
    }

    @Transient
    public double getSecondaryScaleFactor() {
        if (this.getScale2() == 0) {
            return 1.0;
        }
        return (double)this.getScale2() / 100.0;
    }

    @Transient
    public void setSecondaryScaleFactor(double scale) {
        int sca = (int)Math.round(scale * 100.0);
        this.setScale2(sca);
    }

    @Transient
    public String getText() {
        return this.getLeistungenText();
    }

    @Transient
    public float getScaledCount() {
        return (float)this.getZahl() * ((float)this.getScale2() / 100.0f);
    }

    public byte[] getDetail() {
        return this._persistence_get_detail();
    }

    public void setDetail(byte[] detail) {
        this._persistence_set_detail(detail);
    }

    public String getLeistungenText() {
        return this._persistence_get_leistungenText();
    }

    public void setLeistungenText(String leistungenText) {
        this._persistence_set_leistungenText(leistungenText);
    }

    public Behandlung getBehandlung() {
        return this._persistence_get_behandlung();
    }

    public void setBehandlung(Behandlung behandlung) {
        this._persistence_set_behandlung(behandlung);
    }

    public Invoice getInvoice() {
        return this._persistence_get_invoice();
    }

    public void setInvoice(Invoice invoice) {
        this._persistence_set_invoice(invoice);
    }

    public int getZahl() {
        return this._persistence_get_zahl();
    }

    public void setZahl(int zahl) {
        this._persistence_set_zahl(zahl);
    }

    public int getEk_kosten() {
        return this._persistence_get_ek_kosten();
    }

    public void setEk_kosten(int ek_kosten) {
        this._persistence_set_ek_kosten(ek_kosten);
    }

    public int getVk_tp() {
        return this._persistence_get_vk_tp();
    }

    public void setVk_tp(int vk_tp) {
        this._persistence_set_vk_tp(vk_tp);
    }

    public String getVk_scale() {
        return this._persistence_get_vk_scale();
    }

    public void setVk_scale(String vk_scale) {
        this._persistence_set_vk_scale(vk_scale);
    }

    public int getVk_preis() {
        return this._persistence_get_vk_preis();
    }

    public void setVk_preis(int vk_preis) {
        this._persistence_set_vk_preis(vk_preis);
    }

    public int getScale() {
        return this._persistence_get_scale();
    }

    public void setScale(int scale) {
        this._persistence_set_scale(scale);
    }

    public int getScale2() {
        return this._persistence_get_scale2();
    }

    public void setScale2(int scale2) {
        this._persistence_set_scale2(scale2);
    }

    public String getKlasse() {
        return this._persistence_get_klasse();
    }

    public void setKlasse(String klasse) {
        this._persistence_set_klasse(klasse);
    }

    public String getLeistungenCode() {
        return this._persistence_get_leistungenCode();
    }

    public void setLeistungenCode(String leistungenCode) {
        this._persistence_set_leistungenCode(leistungenCode);
    }

    public Kontakt getUser() {
        return this._persistence_get_user();
    }

    public void setUser(Kontakt user) {
        this._persistence_set_user(user);
    }

    @Override
    public boolean isDeleted() {
        return this._persistence_get_deleted();
    }

    @Override
    public void setDeleted(boolean deleted) {
        this._persistence_set_deleted(deleted);
    }

    @Override
    public String getId() {
        return this._persistence_get_id();
    }

    @Override
    public void setId(String id) {
        this._persistence_set_id(id);
    }

    @Override
    public Long getLastupdate() {
        return this._persistence_get_lastupdate();
    }

    @Override
    public void setLastupdate(Long lastupdate) {
        this._persistence_set_lastupdate(lastupdate);
    }

    @Override
    public byte[] getExtInfo() {
        return this._persistence_get_detail();
    }

    @Override
    public void setExtInfo(byte[] extInfo) {
        this._persistence_set_detail(extInfo);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new VerrechnetCopy(persistenceObject);
    }

    public VerrechnetCopy(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "vk_preis") {
            return this.vk_preis;
        }
        if (string == "vk_scale") {
            return this.vk_scale;
        }
        if (string == "leistungenCode") {
            return this.leistungenCode;
        }
        if (string == "behandlung") {
            return this.behandlung;
        }
        if (string == "scale") {
            return this.scale;
        }
        if (string == "leistungenText") {
            return this.leistungenText;
        }
        if (string == "ek_kosten") {
            return this.ek_kosten;
        }
        if (string == "deleted") {
            return this.deleted;
        }
        if (string == "klasse") {
            return this.klasse;
        }
        if (string == "zahl") {
            return this.zahl;
        }
        if (string == "vk_tp") {
            return this.vk_tp;
        }
        if (string == "scale2") {
            return this.scale2;
        }
        if (string == "lastupdate") {
            return this.lastupdate;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "detail") {
            return this.detail;
        }
        if (string == "invoice") {
            return this.invoice;
        }
        if (string == "user") {
            return this.user;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "vk_preis") {
            this.vk_preis = (Integer)object;
            return;
        }
        if (string == "vk_scale") {
            this.vk_scale = (String)object;
            return;
        }
        if (string == "leistungenCode") {
            this.leistungenCode = (String)object;
            return;
        }
        if (string == "behandlung") {
            this.behandlung = (Behandlung)object;
            return;
        }
        if (string == "scale") {
            this.scale = (Integer)object;
            return;
        }
        if (string == "leistungenText") {
            this.leistungenText = (String)object;
            return;
        }
        if (string == "ek_kosten") {
            this.ek_kosten = (Integer)object;
            return;
        }
        if (string == "deleted") {
            this.deleted = (Boolean)object;
            return;
        }
        if (string == "klasse") {
            this.klasse = (String)object;
            return;
        }
        if (string == "zahl") {
            this.zahl = (Integer)object;
            return;
        }
        if (string == "vk_tp") {
            this.vk_tp = (Integer)object;
            return;
        }
        if (string == "scale2") {
            this.scale2 = (Integer)object;
            return;
        }
        if (string == "lastupdate") {
            this.lastupdate = (Long)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "detail") {
            this.detail = (byte[])object;
            return;
        }
        if (string == "invoice") {
            this.invoice = (Invoice)object;
            return;
        }
        if (string == "user") {
            this.user = (Kontakt)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public int _persistence_get_vk_preis() {
        this._persistence_checkFetched("vk_preis");
        return this.vk_preis;
    }

    public void _persistence_set_vk_preis(int n) {
        this._persistence_checkFetchedForSet("vk_preis");
        this._persistence_propertyChange("vk_preis", new Integer(this.vk_preis), new Integer(n));
        this.vk_preis = n;
    }

    public String _persistence_get_vk_scale() {
        this._persistence_checkFetched("vk_scale");
        return this.vk_scale;
    }

    public void _persistence_set_vk_scale(String string) {
        this._persistence_checkFetchedForSet("vk_scale");
        this._persistence_propertyChange("vk_scale", this.vk_scale, string);
        this.vk_scale = string;
    }

    public String _persistence_get_leistungenCode() {
        this._persistence_checkFetched("leistungenCode");
        return this.leistungenCode;
    }

    public void _persistence_set_leistungenCode(String string) {
        this._persistence_checkFetchedForSet("leistungenCode");
        this._persistence_propertyChange("leistungenCode", this.leistungenCode, string);
        this.leistungenCode = string;
    }

    public Behandlung _persistence_get_behandlung() {
        this._persistence_checkFetched("behandlung");
        return this.behandlung;
    }

    public void _persistence_set_behandlung(Behandlung behandlung) {
        this._persistence_checkFetchedForSet("behandlung");
        this._persistence_propertyChange("behandlung", this.behandlung, behandlung);
        this.behandlung = behandlung;
    }

    public int _persistence_get_scale() {
        this._persistence_checkFetched("scale");
        return this.scale;
    }

    public void _persistence_set_scale(int n) {
        this._persistence_checkFetchedForSet("scale");
        this._persistence_propertyChange("scale", new Integer(this.scale), new Integer(n));
        this.scale = n;
    }

    public String _persistence_get_leistungenText() {
        this._persistence_checkFetched("leistungenText");
        return this.leistungenText;
    }

    public void _persistence_set_leistungenText(String string) {
        this._persistence_checkFetchedForSet("leistungenText");
        this._persistence_propertyChange("leistungenText", this.leistungenText, string);
        this.leistungenText = string;
    }

    public int _persistence_get_ek_kosten() {
        this._persistence_checkFetched("ek_kosten");
        return this.ek_kosten;
    }

    public void _persistence_set_ek_kosten(int n) {
        this._persistence_checkFetchedForSet("ek_kosten");
        this._persistence_propertyChange("ek_kosten", new Integer(this.ek_kosten), new Integer(n));
        this.ek_kosten = n;
    }

    public boolean _persistence_get_deleted() {
        this._persistence_checkFetched("deleted");
        return this.deleted;
    }

    public void _persistence_set_deleted(boolean bl) {
        this._persistence_checkFetchedForSet("deleted");
        this._persistence_propertyChange("deleted", new Boolean(this.deleted), new Boolean(bl));
        this.deleted = bl;
    }

    public String _persistence_get_klasse() {
        this._persistence_checkFetched("klasse");
        return this.klasse;
    }

    public void _persistence_set_klasse(String string) {
        this._persistence_checkFetchedForSet("klasse");
        this._persistence_propertyChange("klasse", this.klasse, string);
        this.klasse = string;
    }

    public int _persistence_get_zahl() {
        this._persistence_checkFetched("zahl");
        return this.zahl;
    }

    public void _persistence_set_zahl(int n) {
        this._persistence_checkFetchedForSet("zahl");
        this._persistence_propertyChange("zahl", new Integer(this.zahl), new Integer(n));
        this.zahl = n;
    }

    public int _persistence_get_vk_tp() {
        this._persistence_checkFetched("vk_tp");
        return this.vk_tp;
    }

    public void _persistence_set_vk_tp(int n) {
        this._persistence_checkFetchedForSet("vk_tp");
        this._persistence_propertyChange("vk_tp", new Integer(this.vk_tp), new Integer(n));
        this.vk_tp = n;
    }

    public int _persistence_get_scale2() {
        this._persistence_checkFetched("scale2");
        return this.scale2;
    }

    public void _persistence_set_scale2(int n) {
        this._persistence_checkFetchedForSet("scale2");
        this._persistence_propertyChange("scale2", new Integer(this.scale2), new Integer(n));
        this.scale2 = n;
    }

    public Long _persistence_get_lastupdate() {
        this._persistence_checkFetched("lastupdate");
        return this.lastupdate;
    }

    public void _persistence_set_lastupdate(Long l) {
        this._persistence_checkFetchedForSet("lastupdate");
        this._persistence_propertyChange("lastupdate", this.lastupdate, l);
        this.lastupdate = l;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public byte[] _persistence_get_detail() {
        this._persistence_checkFetched("detail");
        return this.detail;
    }

    public void _persistence_set_detail(byte[] byArray) {
        this._persistence_checkFetchedForSet("detail");
        this._persistence_propertyChange("detail", this.detail, byArray);
        this.detail = byArray;
    }

    public Invoice _persistence_get_invoice() {
        this._persistence_checkFetched("invoice");
        return this.invoice;
    }

    public void _persistence_set_invoice(Invoice invoice) {
        this._persistence_checkFetchedForSet("invoice");
        this._persistence_propertyChange("invoice", this.invoice, invoice);
        this.invoice = invoice;
    }

    public Kontakt _persistence_get_user() {
        this._persistence_checkFetched("user");
        return this.user;
    }

    public void _persistence_set_user(Kontakt kontakt) {
        this._persistence_checkFetchedForSet("user");
        this._persistence_propertyChange("user", this.user, kontakt);
        this.user = kontakt;
    }
}

