/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities;

import ch.elexis.core.jpa.entities.AbstractEntityWithId;
import ch.elexis.core.jpa.entities.EntityWithDeleted;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.converter.BooleanCharacterConverterSafe;
import ch.elexis.core.jpa.entities.listener.EntityWithIdListener;
import ch.elexis.core.model.util.ElexisIdGenerator;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import java.time.LocalDate;
import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="OUTPUT_LOG")
@EntityListeners(value={EntityWithIdListener.class})
@Cache(expiry=15000, alwaysRefresh=false, refreshOnlyIfNewer=true)
public class OutputLogEntity
extends AbstractEntityWithId
implements EntityWithId,
EntityWithDeleted,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Id
    @GeneratedValue(generator="system-uuid")
    @Column(unique=true, nullable=false, length=25)
    private String id;
    @Column
    @Convert(converter=BooleanCharacterConverterSafe.class)
    protected boolean deleted;
    @Column(name="OBJECTTYPE")
    private String objectType;
    @Column(name="OBJECTID")
    private String objectId;
    @Column(name="CREATORID", length=80)
    private String creatorId;
    @Column(name="OUTPUTTER")
    private String outputter;
    @Column(length=8)
    private LocalDate datum;
    @Lob
    @Column(name="EXTINFO")
    protected byte[] extInfo;
    @Lob
    @Column(name="OUTPUTTERSTATUS")
    private String outputterStatus;
    protected Long lastupdate;
    static final long serialVersionUID = 408901935755493792L;

    public OutputLogEntity() {
        this.id = ElexisIdGenerator.generateId();
        this.deleted = false;
    }

    @Override
    public String getId() {
        return this._persistence_get_id();
    }

    @Override
    public void setId(String id) {
        this._persistence_set_id(id);
    }

    @Override
    public boolean isDeleted() {
        return this._persistence_get_deleted();
    }

    @Override
    public void setDeleted(boolean deleted) {
        this._persistence_set_deleted(deleted);
    }

    public String getObjectType() {
        return this._persistence_get_objectType();
    }

    public void setObjectType(String objectType) {
        this._persistence_set_objectType(objectType);
    }

    public String getObjectId() {
        return this._persistence_get_objectId();
    }

    public void setObjectId(String objectId) {
        this._persistence_set_objectId(objectId);
    }

    public String getCreatorId() {
        return this._persistence_get_creatorId();
    }

    public void setCreatorId(String creatorId) {
        this._persistence_set_creatorId(creatorId);
    }

    public String getOutputter() {
        return this._persistence_get_outputter();
    }

    public void setOutputter(String outputter) {
        this._persistence_set_outputter(outputter);
    }

    public LocalDate getDate() {
        return this._persistence_get_datum();
    }

    public void setDate(LocalDate datum) {
        this._persistence_set_datum(datum);
    }

    public byte[] getExtInfo() {
        return this._persistence_get_extInfo();
    }

    public void setExtInfo(byte[] extInfo) {
        this._persistence_set_extInfo(extInfo);
    }

    public String getOutputterStatus() {
        return this._persistence_get_outputterStatus();
    }

    public void setOutputterStatus(String outputterStatus) {
        if (this._persistence_get_outputterStatus() == null || this._persistence_get_outputterStatus().isEmpty()) {
            this._persistence_set_outputterStatus(outputterStatus);
        } else {
            OutputLogEntity outputLogEntity = this;
            outputLogEntity._persistence_set_outputterStatus(String.valueOf(outputLogEntity._persistence_get_outputterStatus()) + "; " + outputterStatus);
        }
    }

    @Override
    public Long getLastupdate() {
        return this._persistence_get_lastupdate();
    }

    @Override
    public void setLastupdate(Long lastupdate) {
        this._persistence_set_lastupdate(lastupdate);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new OutputLogEntity(persistenceObject);
    }

    public OutputLogEntity(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "datum") {
            return this.datum;
        }
        if (string == "deleted") {
            return this.deleted;
        }
        if (string == "outputterStatus") {
            return this.outputterStatus;
        }
        if (string == "creatorId") {
            return this.creatorId;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "lastupdate") {
            return this.lastupdate;
        }
        if (string == "objectId") {
            return this.objectId;
        }
        if (string == "outputter") {
            return this.outputter;
        }
        if (string == "objectType") {
            return this.objectType;
        }
        if (string == "extInfo") {
            return this.extInfo;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "datum") {
            this.datum = (LocalDate)object;
            return;
        }
        if (string == "deleted") {
            this.deleted = (Boolean)object;
            return;
        }
        if (string == "outputterStatus") {
            this.outputterStatus = (String)object;
            return;
        }
        if (string == "creatorId") {
            this.creatorId = (String)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "lastupdate") {
            this.lastupdate = (Long)object;
            return;
        }
        if (string == "objectId") {
            this.objectId = (String)object;
            return;
        }
        if (string == "outputter") {
            this.outputter = (String)object;
            return;
        }
        if (string == "objectType") {
            this.objectType = (String)object;
            return;
        }
        if (string == "extInfo") {
            this.extInfo = (byte[])object;
            return;
        }
        super._persistence_set(string, object);
    }

    public LocalDate _persistence_get_datum() {
        this._persistence_checkFetched("datum");
        return this.datum;
    }

    public void _persistence_set_datum(LocalDate localDate) {
        this._persistence_checkFetchedForSet("datum");
        this._persistence_propertyChange("datum", this.datum, localDate);
        this.datum = localDate;
    }

    public boolean _persistence_get_deleted() {
        this._persistence_checkFetched("deleted");
        return this.deleted;
    }

    public void _persistence_set_deleted(boolean bl) {
        this._persistence_checkFetchedForSet("deleted");
        this._persistence_propertyChange("deleted", new Boolean(this.deleted), new Boolean(bl));
        this.deleted = bl;
    }

    public String _persistence_get_outputterStatus() {
        this._persistence_checkFetched("outputterStatus");
        return this.outputterStatus;
    }

    public void _persistence_set_outputterStatus(String string) {
        this._persistence_checkFetchedForSet("outputterStatus");
        this._persistence_propertyChange("outputterStatus", this.outputterStatus, string);
        this.outputterStatus = string;
    }

    public String _persistence_get_creatorId() {
        this._persistence_checkFetched("creatorId");
        return this.creatorId;
    }

    public void _persistence_set_creatorId(String string) {
        this._persistence_checkFetchedForSet("creatorId");
        this._persistence_propertyChange("creatorId", this.creatorId, string);
        this.creatorId = string;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public Long _persistence_get_lastupdate() {
        this._persistence_checkFetched("lastupdate");
        return this.lastupdate;
    }

    public void _persistence_set_lastupdate(Long l) {
        this._persistence_checkFetchedForSet("lastupdate");
        this._persistence_propertyChange("lastupdate", this.lastupdate, l);
        this.lastupdate = l;
    }

    public String _persistence_get_objectId() {
        this._persistence_checkFetched("objectId");
        return this.objectId;
    }

    public void _persistence_set_objectId(String string) {
        this._persistence_checkFetchedForSet("objectId");
        this._persistence_propertyChange("objectId", this.objectId, string);
        this.objectId = string;
    }

    public String _persistence_get_outputter() {
        this._persistence_checkFetched("outputter");
        return this.outputter;
    }

    public void _persistence_set_outputter(String string) {
        this._persistence_checkFetchedForSet("outputter");
        this._persistence_propertyChange("outputter", this.outputter, string);
        this.outputter = string;
    }

    public String _persistence_get_objectType() {
        this._persistence_checkFetched("objectType");
        return this.objectType;
    }

    public void _persistence_set_objectType(String string) {
        this._persistence_checkFetchedForSet("objectType");
        this._persistence_propertyChange("objectType", this.objectType, string);
        this.objectType = string;
    }

    public byte[] _persistence_get_extInfo() {
        this._persistence_checkFetched("extInfo");
        return this.extInfo;
    }

    public void _persistence_set_extInfo(byte[] byArray) {
        this._persistence_checkFetchedForSet("extInfo");
        this._persistence_propertyChange("extInfo", this.extInfo, byArray);
        this.extInfo = byArray;
    }
}

