/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities;

import ch.elexis.core.ac.AoboEntity;
import ch.elexis.core.ac.AoboEntityColumn;
import ch.elexis.core.jpa.entities.AbstractEntityWithId;
import ch.elexis.core.jpa.entities.AccountTransaction;
import ch.elexis.core.jpa.entities.Behandlung;
import ch.elexis.core.jpa.entities.EntityWithDeleted;
import ch.elexis.core.jpa.entities.EntityWithExtInfo;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Fall;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.entities.VerrechnetCopy;
import ch.elexis.core.jpa.entities.Zahlung;
import ch.elexis.core.jpa.entities.converter.BooleanCharacterConverterSafe;
import ch.elexis.core.jpa.entities.converter.InvoiceStateConverter;
import ch.elexis.core.jpa.entities.listener.EntityWithIdListener;
import ch.elexis.core.jpa.entities.listener.InvoiceEntityListener;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.model.util.ElexisIdGenerator;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.time.LocalDate;
import java.util.List;
import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@AoboEntity
@Table(name="RECHNUNGEN")
@EntityListeners(value={InvoiceEntityListener.class, EntityWithIdListener.class})
@Cache(expiry=15000)
@NamedQueries(value={@NamedQuery(name="Invoice.number", query="SELECT i FROM Invoice i WHERE i.deleted = false AND i.number = :number"), @NamedQuery(name="Invoice.from.to.paid.notempty", query="SELECT i FROM Invoice i WHERE i.deleted = false AND i.invoiceDate >= :from AND i.invoiceDate <= :to AND NOT (i.state = ch.elexis.core.model.InvoiceState.PAID AND i.amount = '0')"), @NamedQuery(name="Invoice.from.to.mandator.paid.notempty", query="SELECT i FROM Invoice i WHERE i.deleted = false AND i.mandator = :mandator AND i.invoiceDate >= :from AND i.invoiceDate <= :to AND NOT (i.state = ch.elexis.core.model.InvoiceState.PAID AND i.amount = '0')")})
public class Invoice
extends AbstractEntityWithId
implements EntityWithId,
EntityWithDeleted,
EntityWithExtInfo,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    public static final String REMARK = "Bemerkung";
    public static final String ATTACHMENTS = "Attachments";
    protected Long lastupdate;
    @Id
    @GeneratedValue(generator="system-uuid")
    @Column(unique=true, nullable=false, length=25)
    private String id = ElexisIdGenerator.generateId();
    @Column
    @Convert(converter=BooleanCharacterConverterSafe.class)
    protected boolean deleted = false;
    @Lob
    protected byte[] extInfo;
    @Column(length=8, name="RnNummer")
    protected String number;
    @OneToOne
    @JoinColumn(name="FallID")
    protected Fall fall;
    @AoboEntityColumn
    @OneToOne
    @JoinColumn(name="MandantID")
    protected Kontakt mandator;
    @Column(name="RnDatum", length=8)
    protected LocalDate invoiceDate;
    @Column(name="RnDatumVon", length=8)
    protected LocalDate invoiceDateFrom;
    @Column(name="RnDatumBis", length=8)
    protected LocalDate invoiceDateTo;
    @Column(length=20, name="RnStatus")
    @Convert(converter=InvoiceStateConverter.class)
    protected InvoiceState state;
    @Column(name="StatusDatum", length=8)
    protected LocalDate statusDate;
    @Column(length=8, name="Betrag")
    protected String amount;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="invoice", cascade={CascadeType.REFRESH})
    private List<VerrechnetCopy> invoiceBilled;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="invoice", cascade={CascadeType.REFRESH})
    private List<Behandlung> encounters;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="invoice", cascade={CascadeType.REFRESH})
    private List<Zahlung> payments;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="invoice", cascade={CascadeType.REFRESH})
    private List<AccountTransaction> transactions;
    static final long serialVersionUID = 9012307074741936706L;

    public String getNumber() {
        return this._persistence_get_number();
    }

    public void setNumber(String number) {
        this._persistence_set_number(number);
    }

    public Fall getFall() {
        return this._persistence_get_fall();
    }

    public void setFall(Fall fall) {
        this._persistence_set_fall(fall);
    }

    public Kontakt getMandator() {
        return this._persistence_get_mandator();
    }

    public void setMandator(Kontakt mandator) {
        this._persistence_set_mandator(mandator);
    }

    public LocalDate getInvoiceDate() {
        return this._persistence_get_invoiceDate();
    }

    public void setInvoiceDate(LocalDate invoiceDate) {
        this._persistence_set_invoiceDate(invoiceDate);
    }

    public LocalDate getInvoiceDateFrom() {
        return this._persistence_get_invoiceDateFrom();
    }

    public void setInvoiceDateFrom(LocalDate invoiceDateFrom) {
        this._persistence_set_invoiceDateFrom(invoiceDateFrom);
    }

    public LocalDate getInvoiceDateTo() {
        return this._persistence_get_invoiceDateTo();
    }

    public void setInvoiceDateTo(LocalDate invoiceDateTo) {
        this._persistence_set_invoiceDateTo(invoiceDateTo);
    }

    public InvoiceState getState() {
        return this._persistence_get_state();
    }

    public void setState(InvoiceState state) {
        this._persistence_set_state(state);
    }

    public LocalDate getStatusDate() {
        return this._persistence_get_statusDate();
    }

    public void setStatusDate(LocalDate statusDate) {
        this._persistence_set_statusDate(statusDate);
    }

    public String getAmount() {
        return this._persistence_get_amount();
    }

    public void setAmount(String amount) {
        this._persistence_set_amount(amount);
    }

    @Override
    public byte[] getExtInfo() {
        return this._persistence_get_extInfo();
    }

    @Override
    public void setExtInfo(byte[] extInfo) {
        this._persistence_set_extInfo(extInfo);
    }

    @Override
    public boolean isDeleted() {
        return this._persistence_get_deleted();
    }

    @Override
    public void setDeleted(boolean deleted) {
        this._persistence_set_deleted(deleted);
    }

    @Override
    public String getId() {
        return this._persistence_get_id();
    }

    @Override
    public void setId(String id) {
        this._persistence_set_id(id);
    }

    @Override
    public Long getLastupdate() {
        return this._persistence_get_lastupdate();
    }

    @Override
    public void setLastupdate(Long lastupdate) {
        this._persistence_set_lastupdate(lastupdate);
    }

    public List<VerrechnetCopy> getInvoiceBilled() {
        return this._persistence_get_invoiceBilled();
    }

    public List<Behandlung> getEncounters() {
        return this._persistence_get_encounters();
    }

    public List<Zahlung> getPayments() {
        return this._persistence_get_payments();
    }

    public List<AccountTransaction> getTransactions() {
        return this._persistence_get_transactions();
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Invoice();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "statusDate") {
            return this.statusDate;
        }
        if (string == "mandator") {
            return this.mandator;
        }
        if (string == "amount") {
            return this.amount;
        }
        if (string == "payments") {
            return this.payments;
        }
        if (string == "invoiceDate") {
            return this.invoiceDate;
        }
        if (string == "transactions") {
            return this.transactions;
        }
        if (string == "extInfo") {
            return this.extInfo;
        }
        if (string == "number") {
            return this.number;
        }
        if (string == "invoiceDateTo") {
            return this.invoiceDateTo;
        }
        if (string == "deleted") {
            return this.deleted;
        }
        if (string == "fall") {
            return this.fall;
        }
        if (string == "encounters") {
            return this.encounters;
        }
        if (string == "invoiceBilled") {
            return this.invoiceBilled;
        }
        if (string == "lastupdate") {
            return this.lastupdate;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "state") {
            return this.state;
        }
        if (string == "invoiceDateFrom") {
            return this.invoiceDateFrom;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "statusDate") {
            this.statusDate = (LocalDate)object;
            return;
        }
        if (string == "mandator") {
            this.mandator = (Kontakt)object;
            return;
        }
        if (string == "amount") {
            this.amount = (String)object;
            return;
        }
        if (string == "payments") {
            this.payments = (List)object;
            return;
        }
        if (string == "invoiceDate") {
            this.invoiceDate = (LocalDate)object;
            return;
        }
        if (string == "transactions") {
            this.transactions = (List)object;
            return;
        }
        if (string == "extInfo") {
            this.extInfo = (byte[])object;
            return;
        }
        if (string == "number") {
            this.number = (String)object;
            return;
        }
        if (string == "invoiceDateTo") {
            this.invoiceDateTo = (LocalDate)object;
            return;
        }
        if (string == "deleted") {
            this.deleted = (Boolean)object;
            return;
        }
        if (string == "fall") {
            this.fall = (Fall)object;
            return;
        }
        if (string == "encounters") {
            this.encounters = (List)object;
            return;
        }
        if (string == "invoiceBilled") {
            this.invoiceBilled = (List)object;
            return;
        }
        if (string == "lastupdate") {
            this.lastupdate = (Long)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "state") {
            this.state = (InvoiceState)object;
            return;
        }
        if (string == "invoiceDateFrom") {
            this.invoiceDateFrom = (LocalDate)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public LocalDate _persistence_get_statusDate() {
        this._persistence_checkFetched("statusDate");
        return this.statusDate;
    }

    public void _persistence_set_statusDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("statusDate");
        this._persistence_propertyChange("statusDate", this.statusDate, localDate);
        this.statusDate = localDate;
    }

    public Kontakt _persistence_get_mandator() {
        this._persistence_checkFetched("mandator");
        return this.mandator;
    }

    public void _persistence_set_mandator(Kontakt kontakt) {
        this._persistence_checkFetchedForSet("mandator");
        this._persistence_propertyChange("mandator", this.mandator, kontakt);
        this.mandator = kontakt;
    }

    public String _persistence_get_amount() {
        this._persistence_checkFetched("amount");
        return this.amount;
    }

    public void _persistence_set_amount(String string) {
        this._persistence_checkFetchedForSet("amount");
        this._persistence_propertyChange("amount", this.amount, string);
        this.amount = string;
    }

    public List _persistence_get_payments() {
        this._persistence_checkFetched("payments");
        return this.payments;
    }

    public void _persistence_set_payments(List list) {
        this._persistence_checkFetchedForSet("payments");
        this._persistence_propertyChange("payments", this.payments, list);
        this.payments = list;
    }

    public LocalDate _persistence_get_invoiceDate() {
        this._persistence_checkFetched("invoiceDate");
        return this.invoiceDate;
    }

    public void _persistence_set_invoiceDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("invoiceDate");
        this._persistence_propertyChange("invoiceDate", this.invoiceDate, localDate);
        this.invoiceDate = localDate;
    }

    public List _persistence_get_transactions() {
        this._persistence_checkFetched("transactions");
        return this.transactions;
    }

    public void _persistence_set_transactions(List list) {
        this._persistence_checkFetchedForSet("transactions");
        this._persistence_propertyChange("transactions", this.transactions, list);
        this.transactions = list;
    }

    public byte[] _persistence_get_extInfo() {
        this._persistence_checkFetched("extInfo");
        return this.extInfo;
    }

    public void _persistence_set_extInfo(byte[] byArray) {
        this._persistence_checkFetchedForSet("extInfo");
        this._persistence_propertyChange("extInfo", this.extInfo, byArray);
        this.extInfo = byArray;
    }

    public String _persistence_get_number() {
        this._persistence_checkFetched("number");
        return this.number;
    }

    public void _persistence_set_number(String string) {
        this._persistence_checkFetchedForSet("number");
        this._persistence_propertyChange("number", this.number, string);
        this.number = string;
    }

    public LocalDate _persistence_get_invoiceDateTo() {
        this._persistence_checkFetched("invoiceDateTo");
        return this.invoiceDateTo;
    }

    public void _persistence_set_invoiceDateTo(LocalDate localDate) {
        this._persistence_checkFetchedForSet("invoiceDateTo");
        this._persistence_propertyChange("invoiceDateTo", this.invoiceDateTo, localDate);
        this.invoiceDateTo = localDate;
    }

    public boolean _persistence_get_deleted() {
        this._persistence_checkFetched("deleted");
        return this.deleted;
    }

    public void _persistence_set_deleted(boolean bl) {
        this._persistence_checkFetchedForSet("deleted");
        this._persistence_propertyChange("deleted", new Boolean(this.deleted), new Boolean(bl));
        this.deleted = bl;
    }

    public Fall _persistence_get_fall() {
        this._persistence_checkFetched("fall");
        return this.fall;
    }

    public void _persistence_set_fall(Fall fall) {
        this._persistence_checkFetchedForSet("fall");
        this._persistence_propertyChange("fall", this.fall, fall);
        this.fall = fall;
    }

    public List _persistence_get_encounters() {
        this._persistence_checkFetched("encounters");
        return this.encounters;
    }

    public void _persistence_set_encounters(List list) {
        this._persistence_checkFetchedForSet("encounters");
        this._persistence_propertyChange("encounters", this.encounters, list);
        this.encounters = list;
    }

    public List _persistence_get_invoiceBilled() {
        this._persistence_checkFetched("invoiceBilled");
        return this.invoiceBilled;
    }

    public void _persistence_set_invoiceBilled(List list) {
        this._persistence_checkFetchedForSet("invoiceBilled");
        this._persistence_propertyChange("invoiceBilled", this.invoiceBilled, list);
        this.invoiceBilled = list;
    }

    public Long _persistence_get_lastupdate() {
        this._persistence_checkFetched("lastupdate");
        return this.lastupdate;
    }

    public void _persistence_set_lastupdate(Long l) {
        this._persistence_checkFetchedForSet("lastupdate");
        this._persistence_propertyChange("lastupdate", this.lastupdate, l);
        this.lastupdate = l;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public InvoiceState _persistence_get_state() {
        this._persistence_checkFetched("state");
        return this.state;
    }

    public void _persistence_set_state(InvoiceState invoiceState) {
        this._persistence_checkFetchedForSet("state");
        this._persistence_propertyChange("state", this.state, invoiceState);
        this.state = invoiceState;
    }

    public LocalDate _persistence_get_invoiceDateFrom() {
        this._persistence_checkFetched("invoiceDateFrom");
        return this.invoiceDateFrom;
    }

    public void _persistence_set_invoiceDateFrom(LocalDate localDate) {
        this._persistence_checkFetchedForSet("invoiceDateFrom");
        this._persistence_propertyChange("invoiceDateFrom", this.invoiceDateFrom, localDate);
        this.invoiceDateFrom = localDate;
    }
}

