/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities;

import ch.elexis.core.ac.AoboEntity;
import ch.elexis.core.ac.AoboEntityColumn;
import ch.elexis.core.jpa.entities.AbstractEntityWithId;
import ch.elexis.core.jpa.entities.Diagnosis;
import ch.elexis.core.jpa.entities.EntityWithDeleted;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Fall;
import ch.elexis.core.jpa.entities.Invoice;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.entities.Verrechnet;
import ch.elexis.core.jpa.entities.converter.BooleanCharacterConverterSafe;
import ch.elexis.core.jpa.entities.converter.VersionedResourceConverter;
import ch.elexis.core.jpa.entities.listener.EntityWithIdListener;
import ch.elexis.core.model.util.ElexisIdGenerator;
import ch.rgw.tools.VersionedResource;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.annotations.Mutable;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@AoboEntity
@Table(name="behandlungen")
@EntityListeners(value={EntityWithIdListener.class})
@Cache(expiry=15000)
@NamedQueries(value={@NamedQuery(name="Behandlung.fall", query="SELECT b FROM Behandlung b WHERE b.deleted = false AND b.fall = :fall"), @NamedQuery(name="Behandlung.fall.aobo", query="SELECT b FROM Behandlung b WHERE b.deleted = false AND b.fall = :fall AND (b.mandant IN :aoboids OR b.mandant is null)"), @NamedQuery(name="Behandlung.patient", query="SELECT b FROM Behandlung b WHERE b.deleted = false AND b.fall.patientKontakt = :patient ORDER BY b.datum desc"), @NamedQuery(name="Behandlung.patient.aobo", query="SELECT b FROM Behandlung b WHERE b.deleted = false AND b.fall.patientKontakt = :patient AND (b.mandant IN :aoboids OR b.mandant is null) ORDER BY b.datum desc, b.time desc"), @NamedQuery(name="Behandlung.patient.last", query="SELECT b FROM Behandlung b WHERE b.deleted = false AND b.fall.patientKontakt = :patient ORDER BY b.datum desc, b.time desc"), @NamedQuery(name="Behandlung.patient.last.aobo", query="SELECT b FROM Behandlung b WHERE b.deleted = false AND b.fall.patientKontakt = :patient AND (b.mandant IN :aoboids OR b.mandant is null) ORDER BY b.datum desc, b.time desc")})
public class Behandlung
extends AbstractEntityWithId
implements EntityWithId,
EntityWithDeleted,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups {
    protected Long lastupdate;
    @Id
    @GeneratedValue(generator="system-uuid")
    @Column(unique=true, nullable=false, length=25)
    private String id;
    @Column
    @Convert(converter=BooleanCharacterConverterSafe.class)
    protected boolean deleted;
    @Column
    @Convert(converter=BooleanCharacterConverterSafe.class)
    private boolean billable;
    @ManyToOne
    @JoinColumn(name="FallID")
    private Fall fall;
    @AoboEntityColumn
    @OneToOne
    @JoinColumn(name="mandantId")
    private Kontakt mandant;
    @ManyToOne
    @JoinColumn(name="rechnungsid")
    private Invoice invoice;
    @Column(length=8)
    private LocalDate datum;
    @Column(length=6, name="Zeit")
    private String time;
    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="behdl_dg_joint", joinColumns={@JoinColumn(name="BehandlungsID")}, inverseJoinColumns={@JoinColumn(name="DiagnoseID")})
    private List<Diagnosis> diagnoses;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="behandlung", cascade={CascadeType.REFRESH})
    @OrderBy(value="klasse ASC, leistungenCode ASC")
    private List<Verrechnet> billed;
    @Mutable
    @Convert(converter=VersionedResourceConverter.class)
    private VersionedResource eintrag;
    static final long serialVersionUID = 909913184526884031L;

    public Behandlung() {
        this.id = ElexisIdGenerator.generateId();
        this.deleted = false;
        this.billable = true;
    }

    public Fall getFall() {
        return this._persistence_get_fall();
    }

    public void setFall(Fall fall) {
        this._persistence_set_fall(fall);
    }

    public Kontakt getMandant() {
        return this._persistence_get_mandant();
    }

    public void setMandant(Kontakt mandant) {
        this._persistence_set_mandant(mandant);
    }

    public Invoice getInvoice() {
        return this._persistence_get_invoice();
    }

    public void setInvoice(Invoice invoice) {
        this._persistence_set_invoice(invoice);
    }

    public LocalDate getDatum() {
        return this._persistence_get_datum();
    }

    public void setDatum(LocalDate datum) {
        this._persistence_set_datum(datum);
    }

    public List<Diagnosis> getDiagnoses() {
        if (this._persistence_get_diagnoses() == null) {
            this._persistence_set_diagnoses(new ArrayList());
        }
        return this._persistence_get_diagnoses();
    }

    public List<Verrechnet> getBilled() {
        if (this._persistence_get_billed() == null) {
            this._persistence_set_billed(new ArrayList());
        }
        return this._persistence_get_billed();
    }

    public VersionedResource getEintrag() {
        if (this._persistence_get_eintrag() == null) {
            this._persistence_set_eintrag(VersionedResource.load(null));
        }
        return this._persistence_get_eintrag();
    }

    public void setEintrag(VersionedResource eintrag) {
        this._persistence_set_eintrag(eintrag);
    }

    @Override
    public boolean isDeleted() {
        return this._persistence_get_deleted();
    }

    @Override
    public void setDeleted(boolean deleted) {
        this._persistence_set_deleted(deleted);
    }

    @Override
    public String getId() {
        return this._persistence_get_id();
    }

    @Override
    public void setId(String id) {
        this._persistence_set_id(id);
    }

    @Override
    public Long getLastupdate() {
        return this._persistence_get_lastupdate();
    }

    @Override
    public void setLastupdate(Long lastupdate) {
        this._persistence_set_lastupdate(lastupdate);
    }

    public boolean getBillable() {
        return this._persistence_get_billable();
    }

    public void setBillable(boolean value) {
        this._persistence_set_billable(value);
    }

    public String getTime() {
        return this._persistence_get_time();
    }

    public void setTime(String time) {
        this._persistence_set_time(time);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Behandlung(persistenceObject);
    }

    public Behandlung(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "datum") {
            return this.datum;
        }
        if (string == "deleted") {
            return this.deleted;
        }
        if (string == "billed") {
            return this.billed;
        }
        if (string == "fall") {
            return this.fall;
        }
        if (string == "mandant") {
            return this.mandant;
        }
        if (string == "eintrag") {
            return this.eintrag;
        }
        if (string == "lastupdate") {
            return this.lastupdate;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "time") {
            return this.time;
        }
        if (string == "invoice") {
            return this.invoice;
        }
        if (string == "billable") {
            return this.billable;
        }
        if (string == "diagnoses") {
            return this.diagnoses;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "datum") {
            this.datum = (LocalDate)object;
            return;
        }
        if (string == "deleted") {
            this.deleted = (Boolean)object;
            return;
        }
        if (string == "billed") {
            this.billed = (List)object;
            return;
        }
        if (string == "fall") {
            this.fall = (Fall)object;
            return;
        }
        if (string == "mandant") {
            this.mandant = (Kontakt)object;
            return;
        }
        if (string == "eintrag") {
            this.eintrag = (VersionedResource)object;
            return;
        }
        if (string == "lastupdate") {
            this.lastupdate = (Long)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "time") {
            this.time = (String)object;
            return;
        }
        if (string == "invoice") {
            this.invoice = (Invoice)object;
            return;
        }
        if (string == "billable") {
            this.billable = (Boolean)object;
            return;
        }
        if (string == "diagnoses") {
            this.diagnoses = (List)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public LocalDate _persistence_get_datum() {
        this._persistence_checkFetched("datum");
        return this.datum;
    }

    public void _persistence_set_datum(LocalDate localDate) {
        this._persistence_checkFetchedForSet("datum");
        this.datum = localDate;
    }

    public boolean _persistence_get_deleted() {
        this._persistence_checkFetched("deleted");
        return this.deleted;
    }

    public void _persistence_set_deleted(boolean bl) {
        this._persistence_checkFetchedForSet("deleted");
        this.deleted = bl;
    }

    public List _persistence_get_billed() {
        this._persistence_checkFetched("billed");
        return this.billed;
    }

    public void _persistence_set_billed(List list) {
        this._persistence_checkFetchedForSet("billed");
        this.billed = list;
    }

    public Fall _persistence_get_fall() {
        this._persistence_checkFetched("fall");
        return this.fall;
    }

    public void _persistence_set_fall(Fall fall) {
        this._persistence_checkFetchedForSet("fall");
        this.fall = fall;
    }

    public Kontakt _persistence_get_mandant() {
        this._persistence_checkFetched("mandant");
        return this.mandant;
    }

    public void _persistence_set_mandant(Kontakt kontakt) {
        this._persistence_checkFetchedForSet("mandant");
        this.mandant = kontakt;
    }

    public VersionedResource _persistence_get_eintrag() {
        this._persistence_checkFetched("eintrag");
        return this.eintrag;
    }

    public void _persistence_set_eintrag(VersionedResource versionedResource) {
        this._persistence_checkFetchedForSet("eintrag");
        this.eintrag = versionedResource;
    }

    public Long _persistence_get_lastupdate() {
        this._persistence_checkFetched("lastupdate");
        return this.lastupdate;
    }

    public void _persistence_set_lastupdate(Long l) {
        this._persistence_checkFetchedForSet("lastupdate");
        this.lastupdate = l;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this.id = string;
    }

    public String _persistence_get_time() {
        this._persistence_checkFetched("time");
        return this.time;
    }

    public void _persistence_set_time(String string) {
        this._persistence_checkFetchedForSet("time");
        this.time = string;
    }

    public Invoice _persistence_get_invoice() {
        this._persistence_checkFetched("invoice");
        return this.invoice;
    }

    public void _persistence_set_invoice(Invoice invoice) {
        this._persistence_checkFetchedForSet("invoice");
        this.invoice = invoice;
    }

    public boolean _persistence_get_billable() {
        this._persistence_checkFetched("billable");
        return this.billable;
    }

    public void _persistence_set_billable(boolean bl) {
        this._persistence_checkFetchedForSet("billable");
        this.billable = bl;
    }

    public List _persistence_get_diagnoses() {
        this._persistence_checkFetched("diagnoses");
        return this.diagnoses;
    }

    public void _persistence_set_diagnoses(List list) {
        this._persistence_checkFetchedForSet("diagnoses");
        this.diagnoses = list;
    }
}

