/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities;

import ch.elexis.core.jpa.entities.AbstractEntityWithId;
import ch.elexis.core.jpa.entities.Brief;
import ch.elexis.core.jpa.entities.EntityWithDeleted;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Fall;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.entities.converter.BooleanCharacterConverterSafe;
import ch.elexis.core.jpa.entities.converter.IntegerStringConverter;
import ch.elexis.core.jpa.entities.listener.EntityWithIdListener;
import ch.elexis.core.model.util.ElexisIdGenerator;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.time.LocalDate;
import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="AUF")
@Cache(expiry=15000)
@EntityListeners(value={EntityWithIdListener.class})
@NamedQuery(name="AUF.patient", query="SELECT a FROM AUF a WHERE a.deleted = false AND a.patient = :patient ORDER BY a.dateFrom DESC, a.dateUntil DESC")
public class AUF
extends AbstractEntityWithId
implements EntityWithId,
EntityWithDeleted,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    protected Long lastupdate;
    @Id
    @GeneratedValue(generator="system-uuid")
    @Column(unique=true, nullable=false, length=25)
    private String id;
    @Column
    @Convert(converter=BooleanCharacterConverterSafe.class)
    protected boolean deleted;
    @ManyToOne
    @JoinColumn(name="PatientID")
    protected Kontakt patient;
    @ManyToOne
    @JoinColumn(name="FallID")
    protected Fall fall;
    @OneToOne
    @JoinColumn(name="BriefID")
    protected Brief brief;
    @Convert(converter=IntegerStringConverter.class)
    protected int prozent;
    @Column(name="DatumAUZ")
    protected LocalDate date;
    @Column(name="DatumVon")
    protected LocalDate dateFrom;
    @Column(name="DatumBis")
    protected LocalDate dateUntil;
    @Column(name="Grund", length=50)
    protected String reason;
    @Column(name="AUFZusatz", length=254)
    protected String note;
    static final long serialVersionUID = -7481546258594658550L;

    public AUF() {
        this.id = ElexisIdGenerator.generateId();
        this.deleted = false;
    }

    @Override
    public String getId() {
        return this._persistence_get_id();
    }

    @Override
    public void setId(String id) {
        this._persistence_set_id(id);
    }

    @Override
    public Long getLastupdate() {
        return this._persistence_get_lastupdate();
    }

    @Override
    public void setLastupdate(Long lastupdate) {
        this._persistence_set_lastupdate(lastupdate);
    }

    @Override
    public boolean isDeleted() {
        return this._persistence_get_deleted();
    }

    @Override
    public void setDeleted(boolean deleted) {
        this._persistence_set_deleted(deleted);
    }

    public Kontakt getPatient() {
        return this._persistence_get_patient();
    }

    public void setPatient(Kontakt patient) {
        this._persistence_set_patient(patient);
    }

    public Fall getFall() {
        return this._persistence_get_fall();
    }

    public void setFall(Fall fall) {
        this._persistence_set_fall(fall);
    }

    public Brief getBrief() {
        return this._persistence_get_brief();
    }

    public void setBrief(Brief brief) {
        this._persistence_set_brief(brief);
    }

    public int getProzent() {
        return this._persistence_get_prozent();
    }

    public void setProzent(int prozent) {
        this._persistence_set_prozent(prozent);
    }

    public LocalDate getDate() {
        return this._persistence_get_date();
    }

    public void setDate(LocalDate date) {
        this._persistence_set_date(date);
    }

    public LocalDate getDateFrom() {
        return this._persistence_get_dateFrom();
    }

    public void setDateFrom(LocalDate dateFrom) {
        this._persistence_set_dateFrom(dateFrom);
    }

    public LocalDate getDateUntil() {
        return this._persistence_get_dateUntil();
    }

    public void setDateUntil(LocalDate dateUntil) {
        this._persistence_set_dateUntil(dateUntil);
    }

    public String getReason() {
        return this._persistence_get_reason();
    }

    public void setReason(String reason) {
        this._persistence_set_reason(reason);
    }

    public String getNote() {
        return this._persistence_get_note();
    }

    public void setNote(String note) {
        this._persistence_set_note(note);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new AUF(persistenceObject);
    }

    public AUF(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "date") {
            return this.date;
        }
        if (string == "brief") {
            return this.brief;
        }
        if (string == "reason") {
            return this.reason;
        }
        if (string == "note") {
            return this.note;
        }
        if (string == "deleted") {
            return this.deleted;
        }
        if (string == "fall") {
            return this.fall;
        }
        if (string == "patient") {
            return this.patient;
        }
        if (string == "prozent") {
            return this.prozent;
        }
        if (string == "lastupdate") {
            return this.lastupdate;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "dateUntil") {
            return this.dateUntil;
        }
        if (string == "dateFrom") {
            return this.dateFrom;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "date") {
            this.date = (LocalDate)object;
            return;
        }
        if (string == "brief") {
            this.brief = (Brief)object;
            return;
        }
        if (string == "reason") {
            this.reason = (String)object;
            return;
        }
        if (string == "note") {
            this.note = (String)object;
            return;
        }
        if (string == "deleted") {
            this.deleted = (Boolean)object;
            return;
        }
        if (string == "fall") {
            this.fall = (Fall)object;
            return;
        }
        if (string == "patient") {
            this.patient = (Kontakt)object;
            return;
        }
        if (string == "prozent") {
            this.prozent = (Integer)object;
            return;
        }
        if (string == "lastupdate") {
            this.lastupdate = (Long)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "dateUntil") {
            this.dateUntil = (LocalDate)object;
            return;
        }
        if (string == "dateFrom") {
            this.dateFrom = (LocalDate)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public LocalDate _persistence_get_date() {
        this._persistence_checkFetched("date");
        return this.date;
    }

    public void _persistence_set_date(LocalDate localDate) {
        this._persistence_checkFetchedForSet("date");
        this._persistence_propertyChange("date", this.date, localDate);
        this.date = localDate;
    }

    public Brief _persistence_get_brief() {
        this._persistence_checkFetched("brief");
        return this.brief;
    }

    public void _persistence_set_brief(Brief brief) {
        this._persistence_checkFetchedForSet("brief");
        this._persistence_propertyChange("brief", this.brief, brief);
        this.brief = brief;
    }

    public String _persistence_get_reason() {
        this._persistence_checkFetched("reason");
        return this.reason;
    }

    public void _persistence_set_reason(String string) {
        this._persistence_checkFetchedForSet("reason");
        this._persistence_propertyChange("reason", this.reason, string);
        this.reason = string;
    }

    public String _persistence_get_note() {
        this._persistence_checkFetched("note");
        return this.note;
    }

    public void _persistence_set_note(String string) {
        this._persistence_checkFetchedForSet("note");
        this._persistence_propertyChange("note", this.note, string);
        this.note = string;
    }

    public boolean _persistence_get_deleted() {
        this._persistence_checkFetched("deleted");
        return this.deleted;
    }

    public void _persistence_set_deleted(boolean bl) {
        this._persistence_checkFetchedForSet("deleted");
        this._persistence_propertyChange("deleted", new Boolean(this.deleted), new Boolean(bl));
        this.deleted = bl;
    }

    public Fall _persistence_get_fall() {
        this._persistence_checkFetched("fall");
        return this.fall;
    }

    public void _persistence_set_fall(Fall fall) {
        this._persistence_checkFetchedForSet("fall");
        this._persistence_propertyChange("fall", this.fall, fall);
        this.fall = fall;
    }

    public Kontakt _persistence_get_patient() {
        this._persistence_checkFetched("patient");
        return this.patient;
    }

    public void _persistence_set_patient(Kontakt kontakt) {
        this._persistence_checkFetchedForSet("patient");
        this._persistence_propertyChange("patient", this.patient, kontakt);
        this.patient = kontakt;
    }

    public int _persistence_get_prozent() {
        this._persistence_checkFetched("prozent");
        return this.prozent;
    }

    public void _persistence_set_prozent(int n) {
        this._persistence_checkFetchedForSet("prozent");
        this._persistence_propertyChange("prozent", new Integer(this.prozent), new Integer(n));
        this.prozent = n;
    }

    public Long _persistence_get_lastupdate() {
        this._persistence_checkFetched("lastupdate");
        return this.lastupdate;
    }

    public void _persistence_set_lastupdate(Long l) {
        this._persistence_checkFetchedForSet("lastupdate");
        this._persistence_propertyChange("lastupdate", this.lastupdate, l);
        this.lastupdate = l;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public LocalDate _persistence_get_dateUntil() {
        this._persistence_checkFetched("dateUntil");
        return this.dateUntil;
    }

    public void _persistence_set_dateUntil(LocalDate localDate) {
        this._persistence_checkFetchedForSet("dateUntil");
        this._persistence_propertyChange("dateUntil", this.dateUntil, localDate);
        this.dateUntil = localDate;
    }

    public LocalDate _persistence_get_dateFrom() {
        this._persistence_checkFetched("dateFrom");
        return this.dateFrom;
    }

    public void _persistence_set_dateFrom(LocalDate localDate) {
        this._persistence_checkFetchedForSet("dateFrom");
        this._persistence_propertyChange("dateFrom", this.dateFrom, localDate);
        this.dateFrom = localDate;
    }
}

