/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.reminder.part.nattable;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IReminder;
import ch.elexis.core.model.IReminderResponsibleLink;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.IUserGroup;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.issue.ProcessStatus;
import ch.elexis.core.model.issue.Visibility;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.ISubQuery;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.data.UiMandant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.graphics.Color;

public class ReminderColumn {
    private String name;
    private String color;
    private Type type;
    private IContact contact;
    private IUserGroup group;
    private String search;

    public static List<ReminderColumn> getAllAvailable() {
        ArrayList<ReminderColumn> available = new ArrayList<ReminderColumn>();
        available.add(new ReminderColumn("Alle", "cecece", Type.ALL));
        available.add(new ReminderColumn("Meine", "acbfad", Type.USER));
        available.add(new ReminderColumn("Patient", "bfacac", Type.PATIENT));
        available.add(new ReminderColumn("Popup", "67fccd", Type.POPUP));
        CoreModelServiceHolder.get().getQuery(IUserGroup.class).execute().forEach(ug -> {
            boolean bl = available.add(new ReminderColumn((IUserGroup)ug, "84d6ed", Type.GROUP));
        });
        CoreModelServiceHolder.get().getQuery(IUser.class).and((EStructuralFeature)ModelPackage.Literals.IUSER__ACTIVE, IQuery.COMPARATOR.EQUALS, (Object)Boolean.TRUE).and((EStructuralFeature)ModelPackage.Literals.IUSER__ASSIGNED_CONTACT, IQuery.COMPARATOR.NOT_EQUALS, null).execute().forEach(u -> {
            boolean bl = available.add(new ReminderColumn((IUser)u, "e9ed84", Type.USER));
        });
        return available;
    }

    public ReminderColumn(String name, String color, Type type) {
        this.name = name;
        this.color = color;
        this.type = type;
    }

    public ReminderColumn(IUserGroup userGroup, String color, Type type) {
        this.name = userGroup.getId();
        this.group = userGroup;
        this.color = color;
        this.type = type;
    }

    public ReminderColumn(IUser user, String color, Type type) {
        this.name = user.getId();
        this.contact = user.getAssignedContact();
        if (this.contact.isMandator()) {
            Color mandatorColor = UiMandant.getColorForIMandator((IMandator)((IMandator)CoreModelServiceHolder.get().load(this.contact.getId(), IMandator.class).get()));
            this.color = Integer.toHexString(mandatorColor.getRed()) + Integer.toHexString(mandatorColor.getGreen()) + Integer.toHexString(mandatorColor.getBlue());
        } else {
            this.color = color;
        }
        this.type = type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<IReminder> loadReminders() {
        if (this.type == Type.USER) {
            if (this.contact != null) return this.loadContact(this.contact);
            Optional user = ContextServiceHolder.get().getActiveUser();
            if (!user.isPresent() || ((IUser)user.get()).getAssignedContact() == null) return Collections.emptyList();
            return this.loadContact(((IUser)user.get()).getAssignedContact());
        }
        if (this.type == Type.PATIENT) {
            Optional patient = ContextServiceHolder.get().getActivePatient();
            if (!patient.isPresent()) return Collections.emptyList();
            return this.loadPatient((IPatient)patient.get());
        }
        if (this.type == Type.ALL) {
            return this.loadAll();
        }
        if (this.type == Type.POPUP) {
            return this.loadPopup();
        }
        if (this.type != Type.GROUP) return Collections.emptyList();
        return this.loadGroup();
    }

    private List<IReminder> loadPopup() {
        IQuery query = CoreModelServiceHolder.get().getQuery(IReminder.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__STATUS, IQuery.COMPARATOR.NOT_EQUALS, (Object)ProcessStatus.CLOSED);
        query.startGroup();
        query.and("visibility", IQuery.COMPARATOR.EQUALS, (Object)Visibility.POPUP_ON_PATIENT_SELECTION);
        query.or("visibility", IQuery.COMPARATOR.EQUALS, (Object)Visibility.POPUP_ON_LOGIN);
        query.andJoinGroups();
        if (this.hasSearch()) {
            this.addSearchToQuery((IQuery<IReminder>)query);
        }
        query.orderBy((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.ORDER.DESC);
        query.limit(500);
        return query.execute();
    }

    private List<IReminder> loadAll() {
        IQuery query = CoreModelServiceHolder.get().getQuery(IReminder.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__STATUS, IQuery.COMPARATOR.NOT_EQUALS, (Object)ProcessStatus.CLOSED);
        query.and("responsibleValue", IQuery.COMPARATOR.EQUALS, (Object)"ALL");
        query.and("visibility", IQuery.COMPARATOR.NOT_EQUALS, (Object)Visibility.POPUP_ON_PATIENT_SELECTION);
        query.and("visibility", IQuery.COMPARATOR.NOT_EQUALS, (Object)Visibility.POPUP_ON_LOGIN);
        if (this.hasSearch()) {
            this.addSearchToQuery((IQuery<IReminder>)query);
        }
        query.orderBy((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.ORDER.DESC);
        query.limit(500);
        return query.execute();
    }

    private List<IReminder> loadGroup() {
        IQuery query = CoreModelServiceHolder.get().getQuery(IReminder.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__STATUS, IQuery.COMPARATOR.NOT_EQUALS, (Object)ProcessStatus.CLOSED);
        query.and("userGroup", IQuery.COMPARATOR.EQUALS, (Object)this.group);
        if (this.hasSearch()) {
            this.addSearchToQuery((IQuery<IReminder>)query);
        }
        query.orderBy((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.ORDER.DESC);
        query.limit(500);
        return query.execute();
    }

    private List<IReminder> loadContact(IContact contact) {
        IQuery query = CoreModelServiceHolder.get().getQuery(IReminder.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__STATUS, IQuery.COMPARATOR.NOT_EQUALS, (Object)ProcessStatus.CLOSED);
        ISubQuery subQuery = query.createSubQuery(IReminderResponsibleLink.class, CoreModelServiceHolder.get());
        subQuery.andParentCompare("id", IQuery.COMPARATOR.EQUALS, "reminderid");
        subQuery.and("responsible", IQuery.COMPARATOR.EQUALS, (Object)contact);
        query.exists(subQuery);
        if (this.hasSearch()) {
            this.addSearchToQuery((IQuery<IReminder>)query);
        }
        query.orderBy((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.ORDER.DESC);
        query.limit(500);
        return query.execute();
    }

    private List<IReminder> loadPatient(IPatient patient) {
        IQuery query = CoreModelServiceHolder.get().getQuery(IReminder.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__CONTACT, IQuery.COMPARATOR.EQUALS, (Object)patient);
        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__STATUS, IQuery.COMPARATOR.NOT_EQUALS, (Object)ProcessStatus.CLOSED);
        if (this.hasSearch()) {
            this.addSearchToQuery((IQuery<IReminder>)query);
        }
        query.orderBy((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.ORDER.DESC);
        query.limit(500);
        return query.execute();
    }

    public String getName() {
        return this.name;
    }

    public String getColor() {
        return this.color;
    }

    public Type getType() {
        return this.type;
    }

    public IContact getResponsible() {
        Optional user;
        if (this.contact == null && (user = ContextServiceHolder.get().getActiveUser()).isPresent() && ((IUser)user.get()).getAssignedContact() != null) {
            return ((IUser)user.get()).getAssignedContact();
        }
        return this.contact;
    }

    public IContact getPatient() {
        Optional patient;
        if (this.type == Type.PATIENT && (patient = ContextServiceHolder.get().getActivePatient()).isPresent()) {
            return (IContact)patient.get();
        }
        return null;
    }

    public IUserGroup getGroup() {
        return this.group;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReminderColumn other = (ReminderColumn)obj;
        return Objects.equals(this.name, other.name) && this.type == other.type;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public boolean hasSearch() {
        return StringUtils.isNotBlank((CharSequence)this.search);
    }

    private void addSearchToQuery(IQuery<IReminder> query) {
        String likeSearch = "%" + this.search + "%";
        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__SUBJECT, IQuery.COMPARATOR.LIKE, (Object)likeSearch, true);
    }

    public static enum Type {
        USER,
        PATIENT,
        ALL,
        POPUP,
        GROUP;

    }
}

