/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.reminder.part;

import ch.elexis.core.model.IReminder;
import ch.elexis.core.ui.reminder.part.nattable.ReminderColumn;
import ch.elexis.core.ui.reminder.part.nattable.ReminderSpanningBodyDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;

public class ReminderTablesConfigLabelsAccumulator
implements IConfigLabelAccumulator {
    private ReminderSpanningBodyDataProvider dataProvider;
    private ViewportLayer viewportLayer;

    public ReminderTablesConfigLabelsAccumulator(ReminderSpanningBodyDataProvider dataProvider, ViewportLayer viewportLayer) {
        this.dataProvider = dataProvider;
        this.viewportLayer = viewportLayer;
    }

    public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
        rowPosition = this.viewportLayer.getRowIndexByPosition(rowPosition);
        columnPosition = this.viewportLayer.getColumnPositionByIndex(columnPosition);
        if (this.dataProvider.getColumns() != null && !this.dataProvider.getColumns().isEmpty()) {
            ReminderColumn column = this.dataProvider.getColumns().get(columnPosition);
            if (this.dataProvider.getData(columnPosition, rowPosition) == null) {
                configLabels.addLabel("BG_" + column.getName());
            }
            if (this.dataProvider.getData(columnPosition, rowPosition) instanceof IReminder || rowPosition == 0) {
                configLabels.addLabel("BG_" + column.getName());
            }
            if (this.dataProvider.getData(columnPosition, rowPosition) instanceof IReminder) {
                configLabels.addLabel("REMINDER");
            }
        }
    }
}

