/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.reminder.part;

import ch.elexis.core.model.IReminder;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.issue.Visibility;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import ch.elexis.core.ui.reminder.part.nattable.ReminderColumn;
import ch.elexis.core.ui.reminder.part.nattable.ReminderSpanningBodyDataProvider;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public class DragAndDropSupport
implements DragSourceListener,
DropTargetListener {
    private final NatTable natTable;
    private final SelectionLayer selectionLayer;
    private final ReminderSpanningBodyDataProvider dataProvider;
    private IReminder draggedReminder;

    public DragAndDropSupport(NatTable natTable, SelectionLayer selectionLayer, ReminderSpanningBodyDataProvider dataProvider) {
        this.natTable = natTable;
        this.selectionLayer = selectionLayer;
        this.dataProvider = dataProvider;
    }

    public void dragStart(DragSourceEvent event) {
        if (this.selectionLayer.getSelectedRowCount() == 0) {
            event.doit = false;
        } else if (!this.natTable.getRegionLabelsByXY(event.x, event.y).hasLabel("BODY")) {
            event.doit = false;
        }
    }

    public void dragSetData(DragSourceEvent event) {
        Optional selection = ContextServiceHolder.get().getTyped(IReminder.class);
        if (selection.isPresent()) {
            this.draggedReminder = (IReminder)selection.get();
            event.data = StoreToStringServiceHolder.get().storeToString((Identifiable)this.draggedReminder).get();
        }
    }

    public void dragFinished(DragSourceEvent event) {
        this.draggedReminder = null;
        this.selectionLayer.clear();
        this.natTable.refresh();
    }

    public void dragEnter(DropTargetEvent event) {
        event.detail = 1;
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        Optional loaded;
        if (StringUtils.isNotBlank((CharSequence)((String)event.data)) && (loaded = StoreToStringServiceHolder.get().loadFromString((String)event.data)).isPresent() && loaded.get() instanceof IReminder) {
            IReminder reminder = (IReminder)loaded.get();
            ReminderColumn dropColumn = this.dataProvider.getColumns().get(this.getColumnPosition(event));
            if (dropColumn.getType() == ReminderColumn.Type.ALL) {
                reminder.setGroup(null);
                reminder.getResponsible().forEach(c -> reminder.removeResponsible(c));
                reminder.setResponsibleAll(true);
            } else if (dropColumn.getType() == ReminderColumn.Type.USER) {
                reminder.setGroup(null);
                reminder.getResponsible().forEach(c -> reminder.removeResponsible(c));
                reminder.setResponsibleAll(false);
                reminder.addResponsible(dropColumn.getResponsible());
            } else if (dropColumn.getType() == ReminderColumn.Type.PATIENT && dropColumn.getPatient() != null) {
                reminder.setContact(dropColumn.getPatient());
            } else if (dropColumn.getType() == ReminderColumn.Type.GROUP) {
                reminder.setResponsibleAll(false);
                reminder.getResponsible().forEach(c -> reminder.removeResponsible(c));
                reminder.setGroup(dropColumn.getGroup());
            } else if (dropColumn.getType() == ReminderColumn.Type.POPUP && reminder.getContact().isPatient()) {
                reminder.setVisibility(Visibility.POPUP_ON_PATIENT_SELECTION);
            }
            CoreModelServiceHolder.get().save((Identifiable)reminder);
            ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)reminder);
        }
    }

    public void dropAccept(DropTargetEvent event) {
    }

    private int getColumnPosition(DropTargetEvent event) {
        Point pt = event.display.map(null, (Control)this.natTable, event.x, event.y);
        int position = this.natTable.getColumnPositionByX(pt.x);
        return position;
    }
}

