/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.reminder.dialogs;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IReminder;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.reminder.composites.ReminderComposite;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ReminderDetailDialog
extends TitleAreaDialog {
    private IReminder reminder;
    private ReminderComposite reminderComposite;

    public ReminderDetailDialog(IReminder reminder, Shell parentShell) {
        super(parentShell);
        this.reminder = reminder;
        this.setShellStyle(2160);
    }

    public void create() {
        super.create();
        Object shelltitle = Messages.EditReminderDialog_reminderShellTitle;
        this.setTitle(Messages.EditReminderDialog_editReminder);
        IContact o = this.reminder.getCreator();
        shelltitle = o == null ? (String)shelltitle + Messages.EditReminderDialog_unknown : (String)shelltitle + " (" + o.getLabel() + ")";
        this.getShell().setText((String)shelltitle);
        this.setMessage(Messages.EditReminderDialog_enterDataForReminder);
        this.setTitleImage(Images.lookupImage((String)"tick_banner.png", (ImageSize)ImageSize._75x66_TitleDialogIconSize));
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)new GridData(1808));
        ret.setLayout((Layout)new FillLayout());
        this.reminderComposite = new ReminderComposite(ret, 0);
        this.reminderComposite.setReminder(this.reminder);
        return ret;
    }

    protected void okPressed() {
        this.reminder = this.reminderComposite.getReminder();
        CoreModelServiceHolder.get().save((Identifiable)this.reminder);
        ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)this.reminder);
        super.okPressed();
    }
}

