/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.reminder.commands;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IReminder;
import ch.elexis.core.model.builder.IReminderBuilder;
import ch.elexis.core.model.issue.ProcessStatus;
import ch.elexis.core.model.issue.Type;
import ch.elexis.core.model.issue.Visibility;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.reminder.dialogs.ReminderDetailDialog;
import jakarta.inject.Named;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.widgets.Shell;

public class CreateReminder {
    @Execute
    public void execute(@Named(value="activeShell") Shell shell) {
        IReminder reminder = (IReminder)new IReminderBuilder(CoreModelServiceHolder.get(), ContextServiceHolder.get(), Visibility.ALWAYS, ProcessStatus.OPEN, "").build();
        reminder.setType(Type.COMMON);
        ContextServiceHolder.get().getActiveUserContact().ifPresent(c -> reminder.addResponsible(c));
        ContextServiceHolder.get().getActivePatient().ifPresent(p -> reminder.setContact((IContact)p));
        ReminderDetailDialog dialog = new ReminderDetailDialog(reminder, shell);
        dialog.open();
    }
}

