/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.mapper;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.helper.FhirUtil;
import ch.elexis.core.findings.util.fhir.transformer.helper.IAppointmentHelper;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IdentifiableDomainResourceAttributeMapper;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IAppointmentService;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Appointment;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Slot;
import org.hl7.fhir.r4.model.StringType;
import org.slf4j.LoggerFactory;

public class IAppointmentAppointmentAttributeMapper
implements IdentifiableDomainResourceAttributeMapper<IAppointment, Appointment> {
    private IAppointmentHelper appointmentHelper;
    private IAppointmentService appointmentService;
    private IConfigService configService;
    private IModelService coreModelService;

    public IAppointmentAppointmentAttributeMapper(IAppointmentService appointmentService, IModelService coreModelService, IConfigService configService) {
        this.appointmentService = appointmentService;
        this.coreModelService = coreModelService;
        this.configService = configService;
        this.appointmentHelper = new IAppointmentHelper();
    }

    @Override
    public void elexisToFhir(IAppointment localObject, Appointment appointment, SummaryEnum summaryEnum, Set<Include> includes) {
        String stateHistoryFormatted;
        IContact contact;
        FhirUtil.setVersionedIdPartLastUpdatedMeta(Appointment.class, (DomainResource)appointment, (Identifiable)localObject);
        this.appointmentHelper.setNarrative((DomainResource)appointment, localObject.getSubjectOrPatient());
        appointment.setStatus(Appointment.AppointmentStatus.BOOKED);
        this.appointmentHelper.mapApplyAppointmentStateAndType(appointment, localObject, this.configService);
        appointment.setDescription(this.appointmentHelper.getDescription(localObject));
        this.appointmentHelper.mapApplyStartEndMinutes(appointment, localObject);
        Reference slotReference = new Reference((IIdType)new IdType(Slot.class.getSimpleName(), localObject.getId()));
        if (includes.contains(new Include("Appointment:slot"))) {
            Optional _slotTransformer = OsgiServiceUtil.getService(IFhirTransformer.class, (String)"(transformer.id=Slot.IAppointment)");
            if (_slotTransformer.isPresent()) {
                Slot _slot = ((IFhirTransformer)_slotTransformer.get()).getFhirObject(localObject).orElse(null);
                slotReference.setResource((IBaseResource)_slot);
                OsgiServiceUtil.ungetService(_slotTransformer.get());
            } else {
                LoggerFactory.getLogger(this.getClass()).error("Could not get slotTransformer service");
            }
        }
        appointment.setSlot(Collections.singletonList(slotReference));
        Optional assignedContact = this.appointmentService.resolveAreaAssignedContact(localObject.getSchedule());
        if (assignedContact.isPresent() && ((IContact)assignedContact.get()).isMandator()) {
            Reference practitionerReference = new Reference((IIdType)new IdDt(Practitioner.class.getSimpleName(), ((IContact)assignedContact.get()).getId()));
            if (includes.contains(new Include("Appointment:actor"))) {
                Optional _practitionerTransformer = OsgiServiceUtil.getService(IFhirTransformer.class, (String)"(transformer.id=Practitioner.IMandator)");
                if (_practitionerTransformer.isPresent()) {
                    IMandator localMandator = (IMandator)this.coreModelService.load(((IContact)assignedContact.get()).getId(), IMandator.class).get();
                    Practitioner _practitioner = (Practitioner)((IFhirTransformer)_practitionerTransformer.get()).getFhirObject(localMandator).get();
                    practitionerReference.setResource((IBaseResource)_practitioner);
                    OsgiServiceUtil.ungetService(_practitionerTransformer.get());
                } else {
                    LoggerFactory.getLogger(this.getClass()).error("Could not get patientTransformer service");
                }
            }
            Appointment.AppointmentParticipantComponent hcp = appointment.addParticipant();
            hcp.setActor(practitionerReference);
            hcp.setRequired(Appointment.ParticipantRequired.REQUIRED);
            hcp.setStatus(Appointment.ParticipationStatus.ACCEPTED);
        }
        if ((contact = localObject.getContact()) != null && contact.isPatient()) {
            Reference patientReference = new Reference((IIdType)new IdType(Patient.class.getSimpleName(), contact.getId()));
            if (includes.contains(new Include("Appointment:actor")) || includes.contains(new Include("Appointment:patient"))) {
                Optional _patientTransformer = OsgiServiceUtil.getService(IFhirTransformer.class, (String)"(transformer.id=Patient.IPatient)");
                if (_patientTransformer.isPresent()) {
                    IPatient localPatient = (IPatient)this.coreModelService.load(contact.getId(), IPatient.class).get();
                    Patient _patient = (Patient)((IFhirTransformer)_patientTransformer.get()).getFhirObject(localPatient).get();
                    patientReference.setResource((IBaseResource)_patient);
                    OsgiServiceUtil.ungetService(_patientTransformer.get());
                } else {
                    LoggerFactory.getLogger(this.getClass()).error("Could not get patientTransformer service");
                }
            }
            Appointment.AppointmentParticipantComponent patient = appointment.addParticipant();
            patient.setActor(patientReference);
            patient.setRequired(Appointment.ParticipantRequired.REQUIRED);
            patient.setStatus(Appointment.ParticipationStatus.ACCEPTED);
        } else {
            String subject = localObject.getSubjectOrPatient();
            appointment.setComment(subject);
        }
        if (appointment.getParticipant().isEmpty()) {
            Appointment.AppointmentParticipantComponent participant = appointment.addParticipant();
            participant.setStatus(Appointment.ParticipationStatus.ACCEPTED);
        }
        if (StringUtils.isNotEmpty((CharSequence)(stateHistoryFormatted = localObject.getStateHistoryFormatted("dd.MM.yyyy HH:mm:ss")))) {
            Extension historyExtension = new Extension();
            historyExtension.setUrl("http://elexis.info/appointment/");
            Extension _historyExtension = new Extension("history", (IBaseDatatype)new StringType(stateHistoryFormatted));
            historyExtension.addExtension(_historyExtension);
            appointment.getExtension().add(historyExtension);
        }
    }

    @Override
    public void fhirToElexis(Appointment source, IAppointment target) {
        this.appointmentHelper.mapApplyAppointmentStateAndType(target, source);
        this.appointmentHelper.mapApplyStartEndMinutes(target, source);
        target.setSubjectOrPatient(null);
        List participant = source.getParticipant();
        for (Appointment.AppointmentParticipantComponent appointmentParticipantComponent : participant) {
            Reference actorTarget = appointmentParticipantComponent.getActor();
            IdType idType = new IdType(actorTarget.getReference());
            if (!Patient.class.getSimpleName().equals(idType.getResourceType())) continue;
            target.setSubjectOrPatient(idType.getIdPart());
        }
        if (StringUtils.isEmpty((CharSequence)target.getSubjectOrPatient())) {
            target.setSubjectOrPatient(source.getComment());
        }
        target.setReason(source.getDescription());
    }
}

