/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.agenda.Area;
import ch.elexis.core.model.agenda.AreaType;
import ch.elexis.core.services.IAppointmentService;
import ch.elexis.core.services.IModelService;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Narrative;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.Schedule;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class ScheduleStringTransformer
implements IFhirTransformer<Schedule, String> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;
    @Reference
    private IAppointmentService appointmentService;

    @Override
    public Optional<Schedule> getFhirObject(String localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Area areaByNameOrId = this.appointmentService.getAreaByNameOrId(localObject);
        Schedule schedule = this.transformToFhir(areaByNameOrId);
        return Optional.ofNullable(schedule);
    }

    @Override
    public Optional<String> getLocalObject(Schedule fhirObject) {
        Area areaByNameOrId = this.appointmentService.getAreaByNameOrId(fhirObject.getId());
        if (areaByNameOrId != null) {
            return Optional.of(areaByNameOrId.getName());
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> updateLocalObject(Schedule fhirObject, String localObject) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<String> createLocalObject(Schedule fhirObject) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return Schedule.class.equals(fhirClazz) && String.class.equals(localClazz);
    }

    private Schedule transformToFhir(Area area) {
        Schedule schedule = new Schedule();
        schedule.setId((IIdType)new IdDt(Schedule.class.getSimpleName(), area.getId()));
        schedule.setActive(true);
        AreaType type = area.getType();
        if (Objects.equals(AreaType.CONTACT, type)) {
            Optional assignedContact = this.appointmentService.resolveAreaAssignedContact(area.getName());
            if (assignedContact.isPresent()) {
                org.hl7.fhir.r4.model.Reference actor = new org.hl7.fhir.r4.model.Reference((IIdType)new IdDt(Practitioner.class.getSimpleName(), ((IContact)assignedContact.get()).getId()));
                schedule.getActor().add(actor);
            } else {
                LoggerFactory.getLogger(this.getClass()).warn("Could not resolve contact [{}]", (Object)area.getContactId());
            }
        }
        schedule.getText().setStatus(Narrative.NarrativeStatus.GENERATED);
        schedule.getText().setDivAsString(area.getName());
        return schedule;
    }
}

