/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data.dto;

import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.data.dto.DiagnosesDTO;
import ch.elexis.data.dto.FallDTO;
import ch.elexis.data.dto.InvoiceCorrectionDTO;
import ch.elexis.data.dto.KonsultationDTO;
import ch.elexis.data.dto.LeistungDTO;
import ch.rgw.tools.TimeTool;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class InvoiceHistoryEntryDTO {
    Object base;
    Object item;
    OperationType operationType;
    Date timestamp = new Date();
    Boolean success;
    Object additional;
    boolean ignored;

    public InvoiceHistoryEntryDTO(OperationType operationType, Object base, Object item) {
        this.base = base;
        this.item = item;
        this.operationType = operationType;
        this.success = null;
    }

    public InvoiceHistoryEntryDTO(OperationType operationType, Object base, Object item, Object additional) {
        this(operationType, base, item);
        this.additional = additional;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public Boolean isSuccess() {
        return this.success;
    }

    public Object getItem() {
        return this.item;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Object getBase() {
        return this.base;
    }

    public Object getAdditional() {
        return this.additional;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.additional == null ? 0 : this.additional.hashCode());
        result = 31 * result + (this.base == null ? 0 : this.base.hashCode());
        result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
        result = 31 * result + (this.operationType == null ? 0 : this.operationType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InvoiceHistoryEntryDTO other = (InvoiceHistoryEntryDTO)obj;
        if (this.additional == null ? other.additional != null : !this.additional.equals(other.additional)) {
            return false;
        }
        if (this.base == null ? other.base != null : !this.base.equals(other.base)) {
            return false;
        }
        if (this.item == null ? other.item != null : !this.item.equals(other.item)) {
            return false;
        }
        return this.operationType == other.operationType;
    }

    public String getText() {
        StringBuilder builder = new StringBuilder();
        if (this.base instanceof KonsultationDTO) {
            builder.append(new TimeTool(this.timestamp).toString(2));
            builder.append(": ");
            builder.append("Konsultation ");
            builder.append(((KonsultationDTO)this.base).getSrcDate());
            builder.append(" - ");
        } else if (this.base instanceof FallDTO) {
            builder.append("Fall - ");
            builder.append(((FallDTO)this.base).getLabel());
        }
        switch (this.operationType) {
            case RECHNUNG_STORNO: {
                builder.append("Rechnung ");
                builder.append(((InvoiceCorrectionDTO)this.base).getInvoiceNumber());
                builder.append(" - ");
                builder.append("stornieren.");
                break;
            }
            case RECHNUNG_NEW: {
                builder.append("Neue Rechnung erstellen.");
                break;
            }
            case FALL_COPY: {
                builder.append(" kopieren.");
                break;
            }
            case FALL_CHANGE: {
                builder.append(" \u00c4nderungen \u00fcbernehmen.");
                break;
            }
            case FALL_KONSULTATION_TRANSER: {
                builder.append(" freigegebene und offene Konsultationen transferieren.");
                break;
            }
            case KONSULTATION_CHANGE_DATE: {
                builder.append("Datum auf ");
                builder.append(((KonsultationDTO)this.base).getDate());
                builder.append(" ver\u00e4ndern.");
                break;
            }
            case KONSULTATION_CHANGE_MANDANT: {
                builder.append("Mandant auf ");
                builder.append(((KonsultationDTO)this.base).getMandant().getLabel());
                builder.append(" ver\u00e4ndern.");
                break;
            }
            case KONSULTATION_TRANSFER_TO_FALL: {
                builder.append("Konsultation ");
                builder.append(" auf Fall ");
                builder.append(((IFall)this.item).getBezeichnung());
                builder.append(" transferieren.");
                break;
            }
            case LEISTUNG_ADD: {
                builder.append("Leistung ");
                builder.append(((LeistungDTO)this.item).getText());
                builder.append(" hinzuf\u00fcgen.");
                break;
            }
            case LEISTUNG_CHANGE_COUNT: {
                builder.append("Leistung ");
                builder.append(((LeistungDTO)this.item).getText());
                builder.append(" - ");
                builder.append("Anzahl auf ");
                builder.append(((LeistungDTO)this.item).getCount());
                builder.append(" ver\u00e4ndern.");
                break;
            }
            case LEISTUNG_CHANGE_PRICE: {
                builder.append("Leistung ");
                builder.append(((LeistungDTO)this.item).getText());
                builder.append(" - ");
                builder.append("Preis auf ");
                builder.append(((LeistungDTO)this.item).getPrice().getAmountAsString());
                builder.append(" ver\u00e4ndern.");
                break;
            }
            case LEISTUNG_REMOVE: {
                builder.append("Leistung ");
                builder.append(((LeistungDTO)this.item).getText());
                builder.append(" entfernen.");
                break;
            }
            case LEISTUNG_TRANSFER_TO_FALL_KONS: {
                builder.append("Leistung ");
                builder.append(this.getListToString((List)this.item));
                builder.append(" auf Fall ");
                builder.append(((IFall)this.additional).getBezeichnung());
                builder.append(" transferieren.");
                break;
            }
            case DIAGNOSE_ADD: {
                builder.append("Diagnose ");
                builder.append(((DiagnosesDTO)this.item).getLabel());
                builder.append(" hinzuf\u00fcgen.");
                break;
            }
            case DIAGNOSE_REMOVE: {
                builder.append("Diagnose ");
                builder.append(((DiagnosesDTO)this.item).getLabel());
                builder.append(" entfernen.");
                break;
            }
        }
        return builder.toString();
    }

    private String getListToString(List<LeistungDTO> leistungDTOs) {
        if (leistungDTOs != null) {
            return leistungDTOs.stream().map(item -> item.getText()).collect(Collectors.joining(", "));
        }
        return "";
    }

    public static enum OperationType {
        LEISTUNG_ADD(true),
        LEISTUNG_REMOVE(true),
        LEISTUNG_CHANGE_COUNT,
        LEISTUNG_CHANGE_PRICE,
        LEISTUNG_TRANSFER_TO_FALL_KONS(true),
        DIAGNOSE_ADD(true),
        DIAGNOSE_REMOVE(true),
        KONSULTATION_CHANGE_DATE,
        KONSULTATION_CHANGE_MANDANT,
        FALL_COPY,
        FALL_CHANGE,
        FALL_KONSULTATION_TRANSER,
        RECHNUNG_STORNO,
        RECHNUNG_NEW,
        KONSULTATION_TRANSFER_TO_FALL;

        final boolean multiAllowed;

        private OperationType() {
            this.multiAllowed = false;
        }

        private OperationType(boolean multiAllowed) {
            this.multiAllowed = multiAllowed;
        }

        public boolean isMultiAllowed() {
            return this.multiAllowed;
        }
    }
}

