/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.events;

import ch.elexis.core.data.events.ClassToModelInterfaceService;
import ch.elexis.core.data.events.ElexisContext;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.events.ElexisEventListenerImpl;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.data.server.ServerEventMapper;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.services.holder.ElexisServerServiceHolder;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.elexis.data.Anwender;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.ListenerList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class ElexisEventDispatcher
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(ElexisEventDispatcher.class);
    private final ListenerList<ElexisEventListener> listeners = new ListenerList();
    private static ElexisEventDispatcher theInstance;
    private final Queue<ElexisEvent> eventQueue = new ConcurrentLinkedQueue<ElexisEvent>();
    private final ArrayList<ElexisEvent> eventCopy = new ArrayList(50);
    private transient boolean bStop = false;
    private final ElexisContext elexisUIContext = new ElexisContext();
    private List<Integer> blockEventTypes;
    private volatile IPerformanceStatisticHandler performanceStatisticHandler;
    private ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
    private static ClassToModelInterfaceService classToModelInterfaceService;
    private static IAccessControlService accessControlService;

    private static ClassToModelInterfaceService getClassToModelInterfaceService() {
        if (classToModelInterfaceService == null) {
            classToModelInterfaceService = (ClassToModelInterfaceService)OsgiServiceUtil.getService(ClassToModelInterfaceService.class).orElseThrow(() -> new IllegalStateException("No ClassToModelInterfaceService"));
        }
        return classToModelInterfaceService;
    }

    public static Optional<Class<?>> getCoreModelInterfaceForElexisClass(Class<? extends Object> clazz) {
        return ElexisEventDispatcher.getClassToModelInterfaceService().getCoreModelInterfaceForElexisClass(clazz);
    }

    public static synchronized ElexisEventDispatcher getInstance() {
        if (theInstance == null) {
            theInstance = new ElexisEventDispatcher();
        }
        return theInstance;
    }

    private ElexisEventDispatcher() {
        accessControlService = (IAccessControlService)OsgiServiceUtil.getService(IAccessControlService.class).get();
    }

    public void start() {
        this.service.scheduleAtFixedRate(this, 0L, 25L, TimeUnit.MILLISECONDS);
    }

    @Deprecated
    public void addListeners(ElexisEventListener ... els) {
        ElexisEventListener[] elexisEventListenerArray = els;
        int n = els.length;
        int n2 = 0;
        while (n2 < n) {
            ElexisEventListener el = elexisEventListenerArray[n2];
            this.listeners.add((Object)el);
            ++n2;
        }
    }

    @Deprecated
    public void removeListeners(ElexisEventListener ... els) {
        ElexisEventListener[] elexisEventListenerArray = els;
        int n = els.length;
        int n2 = 0;
        while (n2 < n) {
            ElexisEventListener el = elexisEventListenerArray[n2];
            this.listeners.remove((Object)el);
            ++n2;
        }
    }

    @Deprecated
    public synchronized void setBlockEventTypes(List<Integer> blockEventTypes) {
        this.blockEventTypes = blockEventTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void fire(ElexisEvent ... ees) {
        ElexisEvent[] elexisEventArray = ees;
        int n = ees.length;
        int n2 = 0;
        while (n2 < n) {
            ElexisEvent ee = elexisEventArray[n2];
            if (this.blockEventTypes == null || !this.blockEventTypes.contains(ee.getType())) {
                if (ee.getPriority() == 1 && ee.getType() != 16) {
                    this.doDispatch(ee);
                } else {
                    ch.elexis.core.common.ElexisEvent mapEvent;
                    Collection<ElexisEvent> eventsToThrow;
                    if (ee.getType() == 64) {
                        this.elexisUIContext.setSelection(ee.getObjectClass(), ee.getObject());
                        this.doDispatch(ee);
                        return;
                    }
                    accessControlService.doPrivileged(() -> this.transalteAndPostOsgiEvent(ee.getType(), ee.getObject() != null ? ee.getObject() : ee.getGenericObject(), ee.getObjectClass()));
                    int eventType = ee.getType();
                    if (eventType == 16 || eventType == 32) {
                        eventsToThrow = null;
                        Queue<ElexisEvent> queue = this.eventQueue;
                        synchronized (queue) {
                            eventsToThrow = this.elexisUIContext.setSelection(ee.getObjectClass(), eventType == 16 ? ee.getObject() : null);
                            for (ElexisEvent elexisEvent : eventsToThrow) {
                                this.removeExisting(elexisEvent);
                                this.eventQueue.offer(elexisEvent);
                            }
                        }
                    }
                    if (eventType == 128) {
                        this.elexisUIContext.setSelection(Mandant.class, ee.getObject());
                    } else if (eventType == 64) {
                        this.elexisUIContext.setSelection(Anwender.class, ee.getObject());
                    }
                    eventsToThrow = this.eventQueue;
                    synchronized (eventsToThrow) {
                        this.eventQueue.offer(ee);
                    }
                    if (ElexisServerServiceHolder.get() != null && ElexisServerServiceHolder.get().deliversRemoteEvents() && (mapEvent = ServerEventMapper.mapEvent(ee)) != null) {
                        ElexisServerServiceHolder.get().postEvent(mapEvent);
                    }
                }
            }
            ++n2;
        }
    }

    private void transalteAndPostOsgiEvent(int eventType, Object object, Class<?> clazz) {
        if (ContextServiceHolder.get() == null) {
            return;
        }
        if (object instanceof Class && clazz == null) {
            clazz = (Class)object;
            object = null;
        }
        if (object != null) {
            Optional<Class<?>> modelInterface = ElexisEventDispatcher.getClassToModelInterfaceService().getCoreModelInterfaceForElexisClass(object.getClass());
            if (modelInterface.isPresent() && object instanceof PersistentObject) {
                Optional<?> identifiable = NoPoUtil.loadAsIdentifiable((PersistentObject)object, modelInterface.get());
                if (identifiable.isPresent()) {
                    if (eventType == 1) {
                        ContextServiceHolder.get().postEvent("info/elexis/model/create", identifiable.get());
                    } else if (eventType == 4) {
                        ContextServiceHolder.get().postEvent("info/elexis/model/update", identifiable.get());
                    } else if (eventType == 2) {
                        ContextServiceHolder.get().postEvent("info/elexis/model/delete", identifiable.get());
                    } else if (eventType == 4096) {
                        ContextServiceHolder.get().postEvent("info/elexis/locking/aquired", identifiable.get());
                    } else if (eventType == 8192) {
                        ContextServiceHolder.get().postEvent("info/elexis/locking/prerelease", identifiable.get());
                    } else if (eventType == 16384) {
                        ContextServiceHolder.get().postEvent("info/elexis/locking/released", identifiable.get());
                    } else if (eventType == 16) {
                        ContextServiceHolder.get().setTyped(identifiable.get());
                    } else if (eventType == 32) {
                        ContextServiceHolder.get().removeTyped(modelInterface.get());
                    } else if (eventType != 128) {
                        log.warn("Event typ [" + eventType + "] not mapped for [" + String.valueOf(object) + "]", new Throwable());
                    }
                } else {
                    log.warn("Could not load [" + String.valueOf(object) + "] as [" + String.valueOf(modelInterface.get()) + "]");
                }
            } else {
                log.warn("Unknown model class for [" + String.valueOf(object) + "] using PersistentObject");
                if (eventType == 1) {
                    ContextServiceHolder.get().postEvent("info/elexis/model/create", object);
                } else if (eventType == 4) {
                    ContextServiceHolder.get().postEvent("info/elexis/model/update", object);
                } else if (eventType == 2) {
                    ContextServiceHolder.get().postEvent("info/elexis/model/delete", object);
                } else if (eventType == 4096) {
                    ContextServiceHolder.get().postEvent("info/elexis/locking/aquired", object);
                } else if (eventType == 8192) {
                    ContextServiceHolder.get().postEvent("info/elexis/locking/prerelease", object);
                } else if (eventType == 16384) {
                    ContextServiceHolder.get().postEvent("info/elexis/locking/released", object);
                } else if (eventType == 16) {
                    ContextServiceHolder.get().setTyped(object);
                } else if (eventType == 32) {
                    ContextServiceHolder.get().removeTyped(object.getClass());
                }
            }
        } else if (clazz != null) {
            if (eventType == 8) {
                Optional<Class<?>> modelInterface = ElexisEventDispatcher.getClassToModelInterfaceService().getCoreModelInterfaceForElexisClass(clazz);
                if (modelInterface.isPresent()) {
                    ContextServiceHolder.get().postEvent("info/elexis/model/reload", modelInterface.get());
                } else {
                    ContextServiceHolder.get().postEvent("info/elexis/model/reload", (Object)clazz);
                }
            } else if (eventType == 32) {
                Optional<Class<?>> modelInterface = ElexisEventDispatcher.getClassToModelInterfaceService().getCoreModelInterfaceForElexisClass(clazz);
                if (modelInterface.isPresent()) {
                    ContextServiceHolder.get().removeTyped(modelInterface.get());
                }
            } else if (eventType != 128) {
                log.warn("Event typ [" + eventType + "] not mapped for [" + String.valueOf(clazz) + "]", new Throwable());
            }
        }
    }

    private void removeExisting(ElexisEvent elexisEvent) {
        Iterator queueIter = this.eventQueue.iterator();
        while (queueIter.hasNext()) {
            ElexisEvent queuedEvent = (ElexisEvent)queueIter.next();
            if (queuedEvent.getType() != elexisEvent.getType() || queuedEvent.getObjectClass() != elexisEvent.getObjectClass() || elexisEvent.getType() != 16) continue;
            queueIter.remove();
        }
    }

    public static IPersistentObject getSelected(Class<?> template) {
        Optional<Class<?>> ciOpt = ElexisEventDispatcher.getClassToModelInterfaceService().getCoreModelInterfaceForElexisClass(template);
        if (ciOpt.isPresent()) {
            Optional selected = Optional.empty();
            selected = Anwender.class == template ? ContextServiceHolder.get().getActiveUserContact() : ContextServiceHolder.get().getTyped(ciOpt.get());
            if (selected.isPresent() && selected.get() instanceof Identifiable) {
                return NoPoUtil.loadAsPersistentObject((Identifiable)selected.get(), template);
            }
        } else {
            LoggerFactory.getLogger(ElexisEventDispatcher.class).warn("Unknown code model interface for [" + String.valueOf(template) + "]");
            Optional selected = ContextServiceHolder.get().getTyped(template);
            if (selected.isPresent() && selected.get() instanceof IPersistentObject) {
                return (IPersistentObject)selected.get();
            }
        }
        return null;
    }

    @Deprecated
    public static void fireSelectionEvent(PersistentObject po) {
        if (po != null) {
            ElexisEventDispatcher.getInstance().fire(new ElexisEvent(po, po.getClass(), 16));
        }
    }

    @Deprecated
    public static void fireSelectionEvents(PersistentObject ... objects) {
        if (objects != null) {
            ElexisEvent[] ees = new ElexisEvent[objects.length];
            int i = 0;
            while (i < objects.length) {
                ees[i] = new ElexisEvent(objects[i], objects[i].getClass(), 16);
                ++i;
            }
            ElexisEventDispatcher.getInstance().fire(ees);
        }
    }

    @Deprecated
    public static void clearSelection(Class<?> clazz) {
        if (clazz != null) {
            ElexisEventDispatcher.getInstance().fire(new ElexisEvent(null, clazz, 32));
        }
    }

    @Deprecated
    public static void reload(Class<?> clazz) {
        if (clazz != null) {
            ElexisEventDispatcher.getInstance().fire(new ElexisEvent(null, clazz, 8));
        }
    }

    @Deprecated
    public static void update(PersistentObject po) {
        if (po != null) {
            ElexisEventDispatcher.getInstance().fire(new ElexisEvent(po, po.getClass(), 4));
        }
    }

    @Nullable
    public static Patient getSelectedPatient() {
        return (Patient)ElexisEventDispatcher.getSelected(Patient.class);
    }

    @Nullable
    public static Mandant getSelectedMandator() {
        return (Mandant)ElexisEventDispatcher.getSelected(Mandant.class);
    }

    public void shutDown() {
        this.bStop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Queue<ElexisEvent> queue = this.eventQueue;
        synchronized (queue) {
            while (!this.eventQueue.isEmpty()) {
                this.eventCopy.add(this.eventQueue.poll());
            }
            this.eventQueue.notifyAll();
        }
        for (ElexisEvent event : this.eventCopy) {
            this.doDispatch(event);
        }
        this.eventCopy.clear();
        if (this.bStop) {
            this.service.shutdown();
        }
    }

    private void doDispatch(ElexisEvent ee) {
        if (ee != null) {
            for (ElexisEventListener l : this.listeners) {
                if (!ee.matches(l.getElexisEventFilter())) continue;
                if (this.performanceStatisticHandler != null) {
                    this.startStatistics(ee, l);
                }
                try {
                    l.catchElexisEvent(ee);
                }
                catch (Exception e) {
                    log.error(ee.toString(), (Throwable)e);
                    throw e;
                }
                if (this.performanceStatisticHandler == null) continue;
                this.endStatistics(ee, l);
            }
        }
    }

    private void endStatistics(ElexisEvent ee, ElexisEventListener l) {
        if (!(l instanceof ElexisEventListenerImpl)) {
            this.performanceStatisticHandler.endCatchEvent(ee, l);
        }
    }

    private void startStatistics(ElexisEvent ee, ElexisEventListener l) {
        if (l instanceof ElexisEventListenerImpl) {
            ((ElexisEventListenerImpl)l).setPerformanceStatisticHandler(this.performanceStatisticHandler);
        } else {
            this.performanceStatisticHandler.startCatchEvent(ee, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilEventQueueIsEmpty(long millis) {
        block6: {
            Queue<ElexisEvent> queue = this.eventQueue;
            synchronized (queue) {
                if (this.eventQueue.isEmpty()) break block6;
                try {
                    this.eventQueue.wait(millis);
                    return true;
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
        return false;
    }

    public void dump() {
        StringBuilder sb = new StringBuilder();
        sb.append("ElexisEventDispatcher dump: \n");
        for (ElexisEventListener el : this.listeners) {
            ElexisEvent filter = el.getElexisEventFilter();
            sb.append(el.getClass().getName()).append(": ");
            if (filter != null && filter.getObjectClass() != null && filter.getObjectClass().getName() != null) {
                sb.append(filter.type).append(" / ").append(filter.getObjectClass().getName());
            }
            sb.append("\n");
        }
        sb.append("\n--------------\n");
        log.debug(sb.toString());
    }

    public void setPerformanceStatisticHandler(IPerformanceStatisticHandler handler) {
        this.performanceStatisticHandler = handler;
    }

    public static interface IPerformanceStatisticHandler {
        public void startCatchEvent(ElexisEvent var1, ElexisEventListener var2);

        public void endCatchEvent(ElexisEvent var1, ElexisEventListener var2);
    }
}

