/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.eenv;

import ch.elexis.core.eenv.AccessToken;
import ch.elexis.core.eenv.IElexisEnvironmentService;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.eenv.AccessTokenUtil;
import ch.elexis.core.services.eenv.RefreshAccessTokenTimerTask;
import ch.elexis.core.time.TimeUtil;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang3.StringUtils;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElexisEnvironmentService
implements IElexisEnvironmentService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String elexisEnvironmentHost;
    private IContextService contextService;
    private IConfigService configService;
    private KeycloakDeployment keycloakDeployment;
    private Timer refreshAccessTokenTimer;

    public ElexisEnvironmentService(String elexisEnvironmentHost, IContextService contextService, IConfigService configService) {
        this.elexisEnvironmentHost = elexisEnvironmentHost;
        this.contextService = contextService;
        this.configService = configService;
        LoggerFactory.getLogger(this.getClass()).info("Binding to EE {}", (Object)this.getHostname());
        this.keycloakDeployment = KeycloakDeploymentBuilder.build((AdapterConfig)this.getKeycloakConfiguration());
        this.refreshAccessTokenTimer = new Timer("Refresh EE access-token", true);
        this.refreshAccessTokenTimer.schedule((TimerTask)new RefreshAccessTokenTimerTask(this.keycloakDeployment, contextService), 60000L, 60000L);
    }

    public String getVersion() {
        return "unknown";
    }

    public String getProperty(String key) {
        String value = System.getenv(key);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return value;
        }
        return this.configService.get(key, null);
    }

    public JsonObject getStatus() {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.getBaseUrl() + "/.status.json")).build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            return JsonParser.parseString((String)response.body()).getAsJsonObject();
        }
        catch (IOException | InterruptedException e) {
            this.logger.warn("Error obtaining status", (Throwable)e);
            return null;
        }
    }

    public String getHostname() {
        return this.elexisEnvironmentHost;
    }

    public void loadAccessToken(String username, char[] password) {
        try {
            AuthzClient authzClient = AuthzClient.create((Configuration)this.getKeycloakConfiguration());
            AccessTokenResponse obtainAccessToken = authzClient.obtainAccessToken(username, String.valueOf(password));
            AccessToken keycloakAccessToken = AccessTokenUtil.load(obtainAccessToken);
            this.contextService.getRootContext().setTyped((Object)keycloakAccessToken);
            this.logger.info("Loaded access-token for [{}], valid until [{}], refresh until [{}]", new Object[]{keycloakAccessToken.getUsername(), TimeUtil.toLocalDateTime((Date)keycloakAccessToken.getAccessTokenExpiration()), TimeUtil.toLocalDateTime((Date)keycloakAccessToken.refreshTokenExpiration())});
        }
        catch (Exception e) {
            this.logger.warn("Error obtaining access token", (Throwable)e);
            return;
        }
    }

    private Configuration getKeycloakConfiguration() {
        Configuration keycloakConfiguration = new Configuration();
        keycloakConfiguration.setRealm("ElexisEnvironment");
        keycloakConfiguration.setAuthServerUrl(this.getKeycloakBaseUrl() + "/auth");
        keycloakConfiguration.setResource("elexis-rcp-openid");
        keycloakConfiguration.setPublicClient(false);
        keycloakConfiguration.setDisableTrustManager(false);
        String rcpClientSecret = this.getProperty("EE_RCP_OPENID_SECRET");
        keycloakConfiguration.getCredentials().put("secret", rcpClientSecret);
        return keycloakConfiguration;
    }
}

